/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatementClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ExpressionList;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.FullOrSubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Function;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.JoinedTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlIdentifier;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SubSelect;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableExpression;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableInfo;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.TableName;
import java.util.ArrayList;
import java.util.List;

public class TableReference
extends AbstractSqlStatementClause {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String MSUPDLOCKHINT = " (UPDLOCK) ";
    public static final String AS = " AS ";
    public static final String OUTER = "OUTER ";
    public static final String TABLE = "TABLE (";
    public static final String OPEN = "(";
    public static final String CLOSE = ")";
    public static final String C = "C";
    private Object tableValue;
    private String correlationNameString;
    private ExpressionList fColumnNames;
    private boolean fForUpdateFlag = false;

    public TableReference(RDBTable rDBTable) {
        this.reference(rDBTable);
    }

    public TableReference(TableExpression tableExpression) {
        this.reference(tableExpression);
    }

    public TableReference(RDBTable rDBTable, String string) {
        this.reference(rDBTable);
        this.correlationName(string);
    }

    public TableReference(FullOrSubSelect fullOrSubSelect, String string) {
        this.reference(fullOrSubSelect);
        this.correlationName(string);
    }

    public TableReference(FullOrSubSelect fullOrSubSelect) {
        this.reference(fullOrSubSelect);
    }

    public TableReference(JoinedTable joinedTable) {
        this.reference(joinedTable);
    }

    public TableReference(JoinedTable joinedTable, String string) {
        this.reference(joinedTable);
        this.correlationName(string);
    }

    public TableReference(TableName tableName) {
        this.reference(tableName);
    }

    public void addColumnName(String string) {
        this.columnNames().add(new SqlIdentifier(string));
    }

    public ExpressionList columnNames() {
        if (this.fColumnNames == null) {
            this.fColumnNames = new ExpressionList();
        }
        return this.fColumnNames;
    }

    public String correlationName() {
        if (this.isTableName()) {
            this.correlationNameString = this.tableName().alias();
        }
        return this.correlationNameString;
    }

    public void correlationName(String string) {
        this.correlationNameString = string;
    }

    public void doNotUseAlias() {
        if (this.isTableName()) {
            this.tableName().doNotUseAlias();
        }
    }

    public void evaluateFullSelectOn(StringBuffer stringBuffer) {
        if (this.isDB2()) {
            stringBuffer.append(TABLE);
        } else {
            stringBuffer.append(OPEN);
        }
        this.fullSelect().evaluateOn(stringBuffer);
        stringBuffer.append(CLOSE).append(" ");
        if (this.correlationName() != null) {
            stringBuffer.append(AS);
            stringBuffer.append(this.correlationName());
        }
    }

    public void evaluateFunctionOn(StringBuffer stringBuffer) {
        stringBuffer.append(TABLE);
        this.function().evaluateOn(stringBuffer);
        stringBuffer.append(CLOSE).append(" ");
        if (this.hasColumns()) {
            this.columnNames().evaluateOn(stringBuffer);
        }
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.isTableName()) {
            this.tableName().evaluateOn(stringBuffer);
            if (this.isSQLServer() && this.isForUpdate()) {
                stringBuffer.append(MSUPDLOCKHINT);
            }
            return;
        }
        if (this.isFullSelect()) {
            this.evaluateFullSelectOn(stringBuffer);
        } else if (this.isFunction()) {
            this.evaluateFunctionOn(stringBuffer);
        } else if (this.isTableExpression()) {
            stringBuffer.append(this.tableExpression().name());
        } else {
            this.joinedTable().evaluateOn(stringBuffer);
        }
        if (!this.isFullSelect() && this.isAliasGiven() && this.isUsingTableAliases()) {
            stringBuffer.append(AS);
            stringBuffer.append(this.correlationName());
        }
        if (this.hasColumns()) {
            this.columnNames().evaluateOn(stringBuffer);
        }
    }

    public void evaluateTableOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.qualifiedTableName());
    }

    public FullOrSubSelect fullSelect() {
        return (FullOrSubSelect)this.tableValue;
    }

    public Function function() {
        return (Function)this.tableValue;
    }

    public boolean hasColumns() {
        return this.fColumnNames != null && !this.fColumnNames.isEmpty();
    }

    public boolean isAliasDefined() {
        return new TableInfo(this.table()).isAliasDefined();
    }

    public boolean isAliasGiven() {
        return this.correlationName() != null;
    }

    public boolean isFullSelect() {
        if (this.tableValue != null) {
            return this.tableValue instanceof FullOrSubSelect;
        }
        return false;
    }

    public boolean isFunction() {
        if (this.tableValue != null) {
            return this.tableValue instanceof Function;
        }
        return false;
    }

    public boolean isJoinedTable() {
        if (this.tableValue != null) {
            return this.tableValue instanceof JoinedTable;
        }
        return false;
    }

    public boolean isSimpleReference() {
        return this.isTableName();
    }

    public boolean isSimpleReferenceTo(RDBTable rDBTable) {
        if (this.isTableName()) {
            return this.tableName().same(rDBTable);
        }
        return false;
    }

    public boolean isTableName() {
        if (this.tableValue != null) {
            return this.tableValue instanceof TableName;
        }
        return false;
    }

    public boolean isTableExpression() {
        if (this.tableValue != null) {
            return this.tableValue instanceof TableExpression;
        }
        return false;
    }

    public boolean isUsingAlias() {
        return this.isTableName() && this.tableName().isUsingAlias();
    }

    public JoinedTable joinedTable() {
        return (JoinedTable)this.tableValue;
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        if (this.isSimpleReference()) {
            stringBuffer.append(this.table().getName());
        } else if (this.isTableExpression()) {
            stringBuffer.append(this.tableExpression().name());
        } else if (this.isJoinedTable()) {
            stringBuffer.append("<joined table>");
        } else if (this.isFullSelect()) {
            stringBuffer.append("<full select>");
        } else {
            stringBuffer.append("<unknown>");
        }
    }

    public String qualifiedTableName() {
        if (!this.isTableName()) {
            return null;
        }
        return this.tableName().qualifiedTableName();
    }

    public void reference(RDBTable rDBTable) {
        this.reference(new TableName(rDBTable));
    }

    public void reference(FullOrSubSelect fullOrSubSelect) {
        this.tableValue = fullOrSubSelect;
    }

    public void reference(TableExpression tableExpression) {
        this.tableValue = tableExpression;
    }

    public void reference(Function function) {
        this.tableValue = function;
    }

    public void reference(JoinedTable joinedTable) {
        this.tableValue = joinedTable;
    }

    public void reference(TableName tableName) {
        this.tableValue = tableName;
    }

    public RDBTable table() {
        if (this.isTableName()) {
            return this.tableName().table();
        }
        return null;
    }

    public void qualifyColumnNames(List list) {
        if (this.isJoinedTable()) {
            this.joinedTable().qualifyColumnNames(list);
        }
    }

    public List tables() {
        if (this.isTableName()) {
            return ListWrapper.list(this.tableName().table());
        }
        if (this.isJoinedTable()) {
            return this.joinedTable().tables();
        }
        if (this.isFullSelect()) {
            return this.fullSelect().tables();
        }
        return null;
    }

    public List tableNames() {
        if (this.isTableName()) {
            return ListWrapper.list(this.tableName());
        }
        if (this.isJoinedTable()) {
            return this.joinedTable().tableNames();
        }
        if (this.isFullSelect()) {
            return this.fullSelect().tableNames();
        }
        return null;
    }

    public boolean includes(RDBTable rDBTable) {
        StSet stSet = StSet.setOn(this.tables());
        return stSet.includes(rDBTable);
    }

    public boolean includes(TableExpression tableExpression) {
        if (this.isTableExpression()) {
            return this.tableExpression().equals(tableExpression);
        }
        return false;
    }

    public TableName tableName() {
        return (TableName)this.tableValue;
    }

    public TableExpression tableExpression() {
        return (TableExpression)this.tableValue;
    }

    public void useAlias() {
        if (this.isTableName()) {
            this.tableName().useAlias();
        }
    }

    public void useQualifiedTableName() {
        if (this.isTableName()) {
            this.tableName().useQualifier();
        }
        if (this.isJoinedTable()) {
            this.joinedTable().useQualifiedTableName();
        }
    }

    public boolean isForUpdate() {
        return this.fForUpdateFlag;
    }

    public void setForUpdate() {
        this.fForUpdateFlag = true;
    }

    public String aliasFor(RDBTable rDBTable) {
        if (rDBTable == null) {
            return null;
        }
        if (!this.isJoinedTable()) {
            return null;
        }
        return this.joinedTable().aliasFor(rDBTable);
    }

    public void addAliasTables(List list) {
        if (this.isJoinedTable()) {
            this.joinedTable().addAliasTables(list);
        }
    }

    public List children() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.basicTableValue());
        return arrayList;
    }

    public Object basicTableValue() {
        return this.tableValue;
    }

    public void createNColumns(int n) {
        for (int i = 1; i <= n; ++i) {
            this.addColumnName(this.createName(i));
        }
    }

    public String createName(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(C).append(n);
        return stringBuffer.toString();
    }

    public void addColumnsFromProjectionClause() {
        if (!this.isFullSelect()) {
            return;
        }
        this.createNColumns(this.fullSelect().selectClause().getResultSetElements().size());
    }

    public void replaceTablesWith(RDBTable rDBTable, SubSelect subSelect, String string) {
        if (this.isSimpleReferenceTo(rDBTable)) {
            this.reference(subSelect);
            this.correlationName(string);
        } else if (this.isJoinedTable()) {
            this.joinedTable().leftTable().replaceTablesWith(rDBTable, subSelect, string);
        } else if (this.isFullSelect() && !this.fullSelect().equals(subSelect)) {
            this.fullSelect().replaceTablesWith(rDBTable, subSelect, string);
        }
    }
}

