/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ws.wdo.mediator.rdb.queryengine.JoinMap;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBColumn;
import com.ibm.ws.wdo.mediator.rdb.queryengine.schema.RDBTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.AbstractSqlStatementClause;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.CorrelationAliasTable;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.PredicateWithVariables;
import com.ibm.ws.wdo.mediator.rdb.queryengine.sqlquerytree.SqlStatementWithWhereClause;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WhereClause
extends AbstractSqlStatementClause {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String AND = " AND ";
    public static final String WHERE = " WHERE ";
    private List fNativeFilters;
    private PredicateWithVariables fSearchCondition;
    private SqlStatementWithWhereClause fStatement;

    public WhereClause() {
    }

    public WhereClause(Predicate predicate) {
        this.searchCondition(predicate);
    }

    public WhereClause(SqlStatementWithWhereClause sqlStatementWithWhereClause) {
        this.statement(sqlStatementWithWhereClause);
    }

    public void statement(SqlStatementWithWhereClause sqlStatementWithWhereClause) {
        this.fStatement = sqlStatementWithWhereClause;
        this.addInVariables((PredicateWithVariables)this.searchCondition());
    }

    public void addInVariables(PredicateWithVariables predicateWithVariables) {
        if (!this.hasStatement()) {
            return;
        }
    }

    public SqlStatementWithWhereClause statement() {
        return this.fStatement;
    }

    public void and(Predicate predicate) {
        this.searchCondition(this.searchCondition().and(predicate));
    }

    public void and(WhereClause whereClause) {
        this.and(whereClause.searchCondition());
    }

    public void andInPredicate(RDBColumn rDBColumn) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createInFilter(rDBColumn);
        this.and(predicateWithVariables);
    }

    public void andInPredicate(ColumnName columnName) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createInFilter(columnName);
        this.and(predicateWithVariables);
    }

    public void andInPredicate(ColumnName columnName, List list) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createInFilter(columnName, list);
        this.and(predicateWithVariables);
    }

    public PredicateWithVariables basicSearchCondition() {
        if (this.fSearchCondition == null) {
            this.fSearchCondition = new PredicateWithVariables();
        }
        return this.fSearchCondition;
    }

    public List children() {
        return ListWrapper.list(this.searchCondition());
    }

    public static WhereClause equiFilter(RDBColumn rDBColumn) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createEquiFilter(rDBColumn);
        return new WhereClause(predicateWithVariables);
    }

    public static WhereClause equiJoin(JoinMap joinMap) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createEquiJoinFilter(joinMap);
        return new WhereClause(predicateWithVariables);
    }

    public static WhereClause equiFilter(RDBColumn rDBColumn, RDBColumn rDBColumn2) {
        return WhereClause.equiFilter(ListWrapper.list(rDBColumn), ListWrapper.list(rDBColumn2));
    }

    public static WhereClause equiFilter(List list) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createEquiFilter(list);
        return new WhereClause(predicateWithVariables);
    }

    public static WhereClause equiFilter(List list, List list2) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createEquiFilter(list, list2);
        return new WhereClause(predicateWithVariables);
    }

    public static WhereClause equiJoin(RDBColumn rDBColumn, RDBColumn rDBColumn2) {
        return WhereClause.equiFilter(ListWrapper.list(rDBColumn), ListWrapper.list(rDBColumn2));
    }

    public static WhereClause equiJoinOnPath(JoinMap joinMap) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createEquiJoinFilterOnPath(joinMap);
        return new WhereClause(predicateWithVariables);
    }

    public void evaluateOn(boolean bl, StringBuffer stringBuffer) {
        if (this.isFullFormat()) {
            this.crTab(stringBuffer);
        }
        if (!bl && this.isEmpty()) {
            return;
        }
        stringBuffer.append(WHERE);
        this.searchCondition().evaluateOn(stringBuffer);
        this.evaluateNativeFiltersOn(stringBuffer);
    }

    public void evaluateNativeFiltersOn(StringBuffer stringBuffer) {
        if (!this.nativeFilters().isEmpty()) {
            if (this.searchCondition() != null && !this.searchCondition().isEmpty()) {
                stringBuffer.append(AND);
            }
            Iterator iterator = this.nativeFilters().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(AND);
            }
        }
    }

    public void evaluateOn(boolean bl, StringBuffer stringBuffer, List list) {
        if (this.isFullFormat()) {
            stringBuffer.append('\n');
            stringBuffer.append('t');
        }
        if (!bl && this.isEmpty()) {
            return;
        }
        stringBuffer.append(WHERE);
        this.searchCondition().evaluateOn(stringBuffer, list);
        this.evaluateNativeFiltersOn(stringBuffer);
    }

    public String firstAlias(List list, RDBTable rDBTable) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CorrelationAliasTable correlationAliasTable = (CorrelationAliasTable)iterator.next();
            String string = correlationAliasTable.aliasAt(rDBTable);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        if (!this.isEmpty()) {
            this.searchCondition().gatherVariableColumnsInOrderOn(list);
        }
    }

    public void gatherVariablesInOrderOn(List list) {
        if (!this.isEmpty()) {
            this.searchCondition().gatherVariablesInOrderOn(list);
        }
    }

    public static WhereClause inFilter(RDBColumn rDBColumn) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createInFilter(rDBColumn);
        return new WhereClause(predicateWithVariables);
    }

    public static WhereClause inFilter(RDBColumn rDBColumn, List list) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createInFilter(rDBColumn, list);
        return new WhereClause(predicateWithVariables);
    }

    public static WhereClause inFilter(List list) {
        PredicateWithVariables predicateWithVariables = new PredicateWithVariables();
        predicateWithVariables.createInFilter(list);
        return new WhereClause(predicateWithVariables);
    }

    public boolean isEmpty() {
        return this.nativeFilters().isEmpty() && (this.searchCondition() == null || this.searchCondition().isEmpty());
    }

    public List nativeFilters() {
        if (this.fNativeFilters == null) {
            this.fNativeFilters = new ArrayList();
        }
        return this.fNativeFilters;
    }

    public void addNativeFilter(String string) {
        this.nativeFilters().add(string);
    }

    public void not() {
        this.searchCondition(this.searchCondition().not());
    }

    public void or(Predicate predicate) {
        this.searchCondition(this.searchCondition().or(predicate));
    }

    public void or(WhereClause whereClause) {
        this.or(whereClause.searchCondition());
    }

    public void qualifyColumnNames(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator iterator = this.gatherColumns().iterator();
        while (iterator.hasNext()) {
            ColumnName columnName = (ColumnName)iterator.next();
            if (columnName.isAliasAlreadySet()) continue;
            String string = this.firstAlias(list, columnName.table());
            if (string == null) {
                throw new RuntimeException("missing table alias");
            }
            columnName.tableAlias(string);
        }
    }

    public Predicate searchCondition() {
        return this.basicSearchCondition();
    }

    public void searchCondition(Predicate predicate) {
        this.fSearchCondition = this.wrapPredicate(predicate);
    }

    public PredicateWithVariables wrapPredicate(Predicate predicate) {
        if (predicate instanceof PredicateWithVariables) {
            this.addInVariables((PredicateWithVariables)predicate);
            return (PredicateWithVariables)predicate;
        }
        if (this.hasStatement()) {
            return new PredicateWithVariables(predicate);
        }
        return new PredicateWithVariables(predicate);
    }

    public boolean hasStatement() {
        return this.fStatement != null;
    }

    public List tables() {
        return this.searchCondition().tables();
    }

    public int predicateSize() {
        return ((PredicateWithVariables)this.searchCondition()).predicateSize();
    }
}

