/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurityPriv.PrincipalAuthenticator;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.common.util.CORBAUtil;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.omg.CORBA.StringHolder;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.CredentialType;
import org.omg.Security.InvalidCredentialType;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.InvalidCredential;
import org.omg.SecurityLevel2.LoginFailed;

public class SSOAuthenticator {
    String cookieName;
    String cookieDomain;
    String cookiePath;
    boolean isCookieSecure;
    boolean setSSODomain = true;
    private static Method getSSODomainMethod = null;
    private static Class webAttributesClass = null;
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$security$SSOAuthenticator == null ? (class$com$ibm$websphere$security$SSOAuthenticator = SSOAuthenticator.class$("com.ibm.websphere.security.SSOAuthenticator")) : class$com$ibm$websphere$security$SSOAuthenticator));
    private static final Object lockObject = new Object();
    private static CurrentImpl current = null;
    private static boolean currentInitialized = false;
    static /* synthetic */ Class class$com$ibm$websphere$security$SSOAuthenticator;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$java$lang$String;

    public SSOAuthenticator() throws IllegalStateException {
        try {
            this.init();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.SSOAuthenticator.SSOAuthenticator", (String)"92", (Object)this);
            throw new IllegalStateException();
        }
    }

    public Credentials login(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws LoginFailed {
        return this.login(string, string2, httpServletRequest, httpServletResponse, true);
    }

    public Credentials login(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws LoginFailed {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login");
        }
        Credentials credentials = this.login(string, string2, bl);
        String string3 = this.getLTPACookieValue(credentials);
        Cookie cookie = new Cookie(this.cookieName, string3);
        if (this.setSSODomain) {
            String string4 = this.getCookieDomain(httpServletRequest);
            if (string4 != null && string4.length() > 0) {
                cookie.setDomain(string4);
            }
        } else if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No domain set for " + this.cookieName + " cookie"));
        }
        cookie.setPath(this.cookiePath);
        cookie.setMaxAge(-1);
        cookie.setSecure(this.isCookieSecure);
        httpServletResponse.addCookie(cookie);
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(cookie.getName() + ";" + cookie.getDomain() + ";" + cookie.getValue()));
            Tr.exit((TraceComponent)tc, (String)"login");
        }
        return credentials;
    }

    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout");
        }
        Cookie cookie = new Cookie(this.cookieName, "");
        if (this.setSSODomain) {
            String string = this.getCookieDomain(httpServletRequest);
            if (string != null && string.length() > 0) {
                cookie.setDomain(string);
            }
        } else if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No domain set for " + this.cookieName + " cookie"));
        }
        cookie.setPath(this.cookiePath);
        cookie.setSecure(this.isCookieSecure);
        cookie.setMaxAge(0);
        httpServletResponse.addCookie(cookie);
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(cookie.getName() + ";" + cookie.getDomain() + ";" + cookie.getValue()));
            Tr.exit((TraceComponent)tc, (String)"logout");
        }
    }

    public String getRefererURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRefererURL");
        }
        String string = null;
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!"WASReqURL".equals(cookieArray[i].getName())) continue;
                string = cookieArray[i].getValue();
                Cookie cookie = new Cookie("WASReqURL", "");
                cookie.setPath(this.cookiePath);
                cookie.setMaxAge(0);
                httpServletResponse.addCookie(cookie);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRefererURL");
        }
        return string;
    }

    public String getSSOCookieName() {
        return this.cookieName;
    }

    public String getLTPACookieValue(Credentials credentials) {
        byte[] byArray = null;
        StringHolder stringHolder = new StringHolder();
        OpaqueHolder opaqueHolder = new OpaqueHolder();
        if (byArray == null) {
            try {
                ((CredentialsImpl)credentials).get_credential_token(stringHolder, opaqueHolder);
                byArray = opaqueHolder.value;
                if (byArray != null && byArray.length == 0) {
                    byArray = null;
                }
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)exception.getMessage(), (Object)exception);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.SSOAuthenticator.getLTPACookieValue", (String)"292", (Object)this);
            }
        }
        String string = StringUtil.toString(byArray);
        return Base64Coder.base64Encode(string);
    }

    private synchronized void init() throws Exception {
        this.obtainSSOProperties();
        webAttributesClass = Class.forName("com.ibm.ws.security.web.WebAttributes");
        getSSODomainMethod = webAttributesClass.getMethod("getSSODomain", class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = SSOAuthenticator.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CurrentImpl getSecurityCurrent() throws IllegalStateException {
        if (!currentInitialized) {
            Object object = lockObject;
            synchronized (object) {
                if (!currentInitialized) {
                    try {
                        ORB oRB = CORBAUtil.getORB();
                        if (oRB == null) {
                            throw new IllegalStateException("SecurityCurrent: null");
                        }
                        current = (CurrentImpl)oRB.resolve_initial_references("SecurityCurrent");
                        currentInitialized = true;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.SSOAuthenticator.getSecurityCurrent", (String)"336");
                        throw new IllegalStateException("Error getting SecurityCurrent from the ORB");
                    }
                }
            }
        }
        return current;
    }

    private static Credentials getOwnedCredentials() {
        Credentials credentials = null;
        try {
            credentials = SSOAuthenticator.getSecurityCurrent().get_credentials(CredentialType.SecOwnCredentials);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.SSOAuthenticator.getOwnedCredentials", (String)"384");
        }
        return credentials;
    }

    private static Credentials beginPrivileged(Credentials credentials) throws InvalidCredentialType, InvalidCredential {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beginPrivileged");
        }
        Credentials credentials2 = SSOAuthenticator.getSecurityCurrent().get_credentials(CredentialType.SecInvocationCredentials);
        SSOAuthenticator.getSecurityCurrent().set_credentials(CredentialType.SecInvocationCredentials, credentials);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beginPrivileged");
        }
        return credentials2;
    }

    private static void endPrivileged(Credentials credentials) throws InvalidCredentialType, InvalidCredential {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endPrivileged");
        }
        SSOAuthenticator.getSecurityCurrent().set_credentials(CredentialType.SecInvocationCredentials, credentials);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endPrivileged");
        }
    }

    private void obtainSSOProperties() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"obtainSSOProperties");
        }
        this.cookieDomain = this.getCookieDomain();
        this.cookieName = "LtpaToken";
        this.cookiePath = "/";
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"obtainSSOProperties");
        }
    }

    private String getCookieDomain() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieDomain");
        }
        String string = null;
        try {
            Boolean bl;
            Boolean bl2;
            Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
            Method method = clazz.getMethod("getConfig", null);
            Method method2 = clazz.getMethod("getValue", class$java$lang$String == null ? (class$java$lang$String = SSOAuthenticator.class$("java.lang.String")) : class$java$lang$String);
            Object object = method.invoke(null, new Object[0]);
            String string2 = "security.ltpa.sso.domain";
            string = (String)method2.invoke(object, string2);
            if (string == null) {
                string = "";
            }
            if (string != null && string.length() > 0 && (string = string.trim()).charAt(0) != '.') {
                string = "." + string;
            }
            if ((bl2 = (Boolean)method2.invoke(object, string2 = "security.ltpa.sso.ssl")) != null) {
                this.isCookieSecure = bl2;
            }
            if ((bl = (Boolean)method2.invoke(object, string2 = "security.ltpa.setSSODomain")) != null) {
                this.setSSODomain = bl;
            }
            if (string.length() < 1) {
                this.setSSODomain = false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw illegalAccessException;
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)string);
            Tr.exit((TraceComponent)tc, (String)"getCookieDomain");
        }
        return string;
    }

    private String getCookieDomain(HttpServletRequest httpServletRequest) {
        Tr.entry((TraceComponent)tc, (String)"getCookieDomain");
        if (webAttributesClass == null) {
            Tr.debug((TraceComponent)tc, (String)"WebAttributes class is null, SSO via custom login will not function!");
        }
        if (getSSODomainMethod == null) {
            Tr.debug((TraceComponent)tc, (String)"getSSODomain method is null, SSO via custom login will not function!");
        }
        String string = "";
        if (webAttributesClass != null && getSSODomainMethod != null) {
            try {
                string = (String)getSSODomainMethod.invoke(null, httpServletRequest);
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)tc, (String)exception.getMessage(), (Object)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Cookie domain = " + string));
        }
        Tr.exit((TraceComponent)tc, (String)"getCookieDomain");
        return string;
    }

    private Credentials login(String string, String string2, boolean bl) throws LoginFailed {
        int n = 1;
        PrincipalAuthenticator principalAuthenticator = null;
        try {
            principalAuthenticator = (PrincipalAuthenticator)SSOAuthenticator.getSecurityCurrent().principal_authenticator(n);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.websphere.security.SSOAuthenticator.login", (String)"553", (Object)this);
            Tr.debug((TraceComponent)tc, (String)classCastException.getMessage(), (Object)classCastException);
            throw new IllegalStateException("wrong type for PrincipalAuthenticator");
        }
        byte[] byArray = null;
        if (string2 != null) {
            byArray = string2.getBytes();
        }
        int n2 = 0;
        CredentialsHolder credentialsHolder = new CredentialsHolder();
        OpaqueHolder opaqueHolder = new OpaqueHolder();
        OpaqueHolder opaqueHolder2 = new OpaqueHolder();
        try {
            AuthenticationStatus authenticationStatus = principalAuthenticator.authenticate(n2, string, byArray, null, credentialsHolder, opaqueHolder, opaqueHolder2);
            if (authenticationStatus.value() != 0) {
                throw new LoginFailed();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.SSOAuthenticator.login", (String)"584", (Object)this);
            Tr.debug((TraceComponent)tc, (String)exception.getMessage(), (Object)exception);
            throw new LoginFailed();
        }
        return credentialsHolder.value;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

