/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public final class WSSubject {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$websphere$security$auth$WSSubject == null ? (class$com$ibm$websphere$security$auth$WSSubject = WSSubject.class$("com.ibm.websphere.security.auth.WSSubject")) : class$com$ibm$websphere$security$auth$WSSubject), null, (String)"com.ibm.ejs.resources.security");
    private static final AuthPermission DOAS_PERM = new AuthPermission("doAs");
    private static final AuthPermission DOASPRIVILEGED_PERM = new AuthPermission("doAsPrivileged");
    private static final AuthPermission GETCALLERSUBJECT_PERM = new AuthPermission("wssecurity.getCallerSubject");
    private static final AuthPermission GETRUNASSUBJECT_PERM = new AuthPermission("wssecurity.getRunAsSubject");
    private static final AuthPermission SETRUNASSUBJECT_PERM = new AuthPermission("wssecurity.setRunAsSubject");
    private static final PrivilegedExceptionAction getCallerSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException {
            ContextManager contextManager;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"WSSubject.getCallerSubjectAction.run");
            }
            if ((contextManager = ContextManagerFactory.getInstance()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to get ContextManager");
                }
                throw new WSSecurityException("Failed to get ContextManager");
            }
            Subject subject = contextManager.getCallerSubject();
            if (subject != null) {
                subject.setReadOnly();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No caller subject");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"WSSubject.getCallerSubjectAction.run");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getRunAsSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException {
            ContextManager contextManager;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"WSSubject.getRunAsSubjectAction.run");
            }
            if ((contextManager = ContextManagerFactory.getInstance()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to get ContextManager");
                }
                throw new WSSecurityException("Failed to get ContextManager");
            }
            Subject subject = contextManager.getInvocationSubject();
            if (subject != null) {
                subject.setReadOnly();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No invocation credential");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"WSSubject.getRunAsSubjectAction.run");
            }
            return subject;
        }
    };
    static /* synthetic */ Class class$com$ibm$websphere$security$auth$WSSubject;

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doAs(Subject, PrivilegedAction)");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DOAS_PERM);
        }
        if (privilegedAction == null) {
            throw new NullPointerException("invalid null action provided");
        }
        Subject subject2 = WSSubject.setInvocationSubject(subject);
        try {
            Object t = Subject.doAs(subject, privilegedAction);
            return t;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.doAs(Subject, PrivilegedAction) Exception caught " + WSSubject.dump(throwable)));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.security.auth.WSSubject.doAs", (String)"105");
            throw new RuntimeException(throwable);
        }
        finally {
            WSSubject.restoreInvocationSubject(subject2);
        }
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doAs(Subject, PrivilegedAction)");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DOAS_PERM);
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException("invalid null action provided");
        }
        Subject subject2 = WSSubject.setInvocationSubject(subject);
        try {
            Object t = Subject.doAs(subject, privilegedExceptionAction);
            return t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.doAs(Subject, PrivilegedExceptionAction) Exception caught " + WSSubject.dump(throwable)));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.security.auth.WSSubject.doAs", (String)"105");
            throw new RuntimeException(throwable);
        }
        finally {
            WSSubject.restoreInvocationSubject(subject2);
        }
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doAsPrivileged(Subject, PrivilegedAction, AccessControlContext)");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DOASPRIVILEGED_PERM);
        }
        if (privilegedAction == null) {
            throw new NullPointerException("invalid null action provided");
        }
        Subject subject2 = WSSubject.setInvocationSubject(subject);
        try {
            Object t = Subject.doAsPrivileged(subject, privilegedAction, accessControlContext);
            return t;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.doAsPrivileged(Subject, PrivilegedAction, AccessControlContext) Exception caught " + WSSubject.dump(throwable)));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.security.auth.WSSubject.doAsPrivileged", (String)"105");
            throw new RuntimeException(throwable);
        }
        finally {
            WSSubject.restoreInvocationSubject(subject2);
        }
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doAsPrivileged(Subject, PrivilegedAction, AccessControlContext)");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DOASPRIVILEGED_PERM);
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException("invalid null action provided");
        }
        Subject subject2 = WSSubject.setInvocationSubject(subject);
        try {
            Object t = Subject.doAsPrivileged(subject, privilegedExceptionAction, accessControlContext);
            return t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSSubject.doAsPrivileged(Subject, PrivilegedAction, AccessControlContext) Exception caught");
                throwable.printStackTrace();
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.security.auth.WSSubject.doAsPrivileged", (String)"289");
            throw new RuntimeException(throwable);
        }
        finally {
            WSSubject.restoreInvocationSubject(subject2);
        }
    }

    public static Subject getCallerSubject() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCallerSubject");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETCALLERSUBJECT_PERM);
        }
        Subject subject = null;
        if (SecurityContext.isServerProcess()) {
            try {
                subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)getCallerSubjectAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                subject = null;
                WSSecurityException wSSecurityException = (WSSecurityException)privilegedActionException.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Failed in getting the caller identity: " + WSSubject.dump((Throwable)wSSecurityException)));
                }
                FFDCFilter.processException((Throwable)wSSecurityException, (String)((class$com$ibm$websphere$security$auth$WSSubject == null ? (class$com$ibm$websphere$security$auth$WSSubject = WSSubject.class$("com.ibm.websphere.security.auth.WSSubject")) : class$com$ibm$websphere$security$auth$WSSubject).getName() + ".getCallerSubject()"), (String)"294");
                throw wSSecurityException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCallerSubject");
        }
        return subject;
    }

    public static Subject getRunAsSubject() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRunAsSubject");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GETRUNASSUBJECT_PERM);
        }
        Subject subject = null;
        try {
            subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)getRunAsSubjectAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            subject = null;
            WSSecurityException wSSecurityException = (WSSecurityException)privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed in getting the run as identity: " + WSSubject.dump((Throwable)wSSecurityException)));
            }
            FFDCFilter.processException((Throwable)wSSecurityException, (String)((class$com$ibm$websphere$security$auth$WSSubject == null ? (class$com$ibm$websphere$security$auth$WSSubject = WSSubject.class$("com.ibm.websphere.security.auth.WSSubject")) : class$com$ibm$websphere$security$auth$WSSubject).getName() + ".getRunAsSubject()"), (String)"358");
            throw wSSecurityException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRunAsSubject");
        }
        return subject;
    }

    public static void setRunAsSubject(Subject subject) throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRunAsSubject");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SETRUNASSUBJECT_PERM);
        }
        try {
            final Subject subject2 = subject;
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws WSSecurityException {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    if (contextManager == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to get ContextManager");
                        }
                        throw new WSSecurityException("Failed to get ContextManager");
                    }
                    contextManager.setInvocationSubject(subject2);
                    contextManager.addWSSubjectToCache(subject2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            WSSecurityException wSSecurityException = (WSSecurityException)privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed in setting the run as identity: " + WSSubject.dump((Throwable)wSSecurityException)));
            }
            FFDCFilter.processException((Throwable)wSSecurityException, (String)((class$com$ibm$websphere$security$auth$WSSubject == null ? (class$com$ibm$websphere$security$auth$WSSubject = WSSubject.class$("com.ibm.websphere.security.auth.WSSubject")) : class$com$ibm$websphere$security$auth$WSSubject).getName() + ".setRunAsSubject()"), (String)"496");
            throw wSSecurityException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRunAsSubject");
        }
    }

    public static String getCallerPrincipal() {
        String string;
        block4: {
            string = null;
            try {
                WSCredential wSCredential;
                Subject subject = ContextManagerFactory.getInstance().getCallerSubject();
                if (subject != null && (wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject)) != null && !wSCredential.isUnauthenticated()) {
                    string = wSCredential.getSecurityName();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.websphere.security.auth.WSSubject.getCallerPrincipal", (String)"541");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception of getting the caller principal", (Object)WSSubject.dump(generalSecurityException));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Caller principal: " + string));
        }
        return string;
    }

    public static Throwable getRootLoginException() {
        return ContextManagerFactory.getInstance().getRootException();
    }

    private static Subject setInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInvocationSubject(Subject)");
        }
        Subject subject2 = null;
        try {
            subject2 = subject == null ? ContextManagerFactory.getInstance().pushInvocationSubject(SubjectHelper.createUnauthenticatedSubject()) : ContextManagerFactory.getInstance().pushInvocationSubject(subject);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.setInvocationSubject(Subject), Exception caught " + WSSubject.dump(throwable)));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.security.auth.WSSubject.setInvocationSubject", (String)"594");
            throw new UndeclaredThrowableException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInvocationSubject(Subject)");
        }
        return subject2;
    }

    private static void restoreInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreInvocationSubject(Subject)");
        }
        try {
            ContextManagerFactory.getInstance().popInvocationSubject(subject);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WSSubject.restoreInvocationSubject(Subject) Exception caught " + WSSubject.dump(throwable)));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.security.auth.WSSubject.restoreInvocationSubject", (String)"616");
            throw new UndeclaredThrowableException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreInvocationSubject(Subject)");
        }
    }

    private static String dump(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

