/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XSDComplexTypeTraverser
extends XSDAbstractParticleTraverser {
    private static int GLOBAL_NUM = 10;
    private boolean fIsAbstract = false;
    private boolean fIsAnonymous = false;
    private String fName = null;
    private String fTargetNamespace = null;
    private short fDerivedBy = 0;
    private short fFinal = 0;
    private short fBlock = 0;
    private short fContentType = 0;
    private XSTypeDecl fBaseType = null;
    private XSAttributeGroupDecl fAttrGrp = new XSAttributeGroupDecl();
    private XSParticleDecl fParticle = null;
    private XSSimpleType fXSSimpleType = null;
    private Object[] fGlobalStore = null;
    private int fGlobalStorePos = 0;
    private static final boolean DEBUG = false;
    private SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();

    XSDComplexTypeTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    XSComplexTypeDecl traverseLocal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        String string = this.genAnonTypeName(element);
        XSComplexTypeDecl xSComplexTypeDecl = this.traverseComplexTypeDecl(element, string, objectArray, xSDocumentInfo, schemaGrammar, true);
        schemaGrammar.addComplexTypeDecl(xSComplexTypeDecl, this.fSchemaHandler.element2Locator(element));
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSComplexTypeDecl;
    }

    XSComplexTypeDecl traverseGlobal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        XSComplexTypeDecl xSComplexTypeDecl = this.traverseComplexTypeDecl(element, string, objectArray, xSDocumentInfo, schemaGrammar, false);
        if (string == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_COMPLEXTYPE, SchemaSymbols.ATT_NAME}, element);
        } else {
            schemaGrammar.addGlobalTypeDecl(xSComplexTypeDecl);
        }
        schemaGrammar.addComplexTypeDecl(xSComplexTypeDecl, this.fSchemaHandler.element2Locator(element));
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSComplexTypeDecl;
    }

    private XSComplexTypeDecl traverseComplexTypeDecl(Element element, String string, Object[] objectArray, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar, boolean bl) {
        Object object;
        Boolean bl2 = (Boolean)objectArray[XSAttributeChecker.ATTIDX_ABSTRACT];
        XInt xInt = (XInt)objectArray[XSAttributeChecker.ATTIDX_BLOCK];
        Boolean bl3 = (Boolean)objectArray[XSAttributeChecker.ATTIDX_MIXED];
        XInt xInt2 = (XInt)objectArray[XSAttributeChecker.ATTIDX_FINAL];
        this.contentBackup();
        this.fIsAbstract = false;
        this.fIsAnonymous = bl;
        this.fName = string;
        this.fDerivedBy = 0;
        this.fContentType = 0;
        this.fBaseType = null;
        this.fAttrGrp = new XSAttributeGroupDecl();
        this.fParticle = null;
        this.fXSSimpleType = null;
        this.fTargetNamespace = xSDocumentInfo.fTargetNamespace;
        this.fBlock = xInt == null ? xSDocumentInfo.fBlockDefault : xInt.shortValue();
        short s = this.fFinal = xInt2 == null ? xSDocumentInfo.fFinalDefault : xInt2.shortValue();
        if (bl2 != null && bl2.booleanValue()) {
            this.fIsAbstract = true;
        }
        Element element2 = null;
        try {
            element2 = DOMUtil.getFirstChildElement(element);
            if (element2 != null) {
                if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
                    element2 = DOMUtil.getNextSiblingElement(element2);
                }
                if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, element2);
                }
            }
            if (element2 == null) {
                this.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(element2, bl3, false, xSDocumentInfo, schemaGrammar);
            } else if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_SIMPLECONTENT)) {
                this.traverseSimpleContent(element2, xSDocumentInfo, schemaGrammar);
                object = DOMUtil.getNextSiblingElement(element2);
                if (object != null) {
                    String string2 = DOMUtil.getLocalName((Node)object);
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string2}, (Element)object);
                }
            } else if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_COMPLEXCONTENT)) {
                this.traverseComplexContent(element2, bl3, xSDocumentInfo, schemaGrammar);
                object = DOMUtil.getNextSiblingElement(element2);
                if (object != null) {
                    String string3 = DOMUtil.getLocalName((Node)object);
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string3}, (Element)object);
                }
            } else {
                this.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(element2, bl3, false, xSDocumentInfo, schemaGrammar);
            }
        }
        catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
            this.handleComplexTypeError(complexTypeRecoverableError.getMessage(), complexTypeRecoverableError.errorSubstText, complexTypeRecoverableError.errorElem);
        }
        object = new XSComplexTypeDecl(this.fName, this.fTargetNamespace, this.fBaseType, this.fDerivedBy, this.fFinal, this.fBlock, this.fIsAbstract, this.fIsAnonymous, this.fAttrGrp, this.fContentType, this.fXSSimpleType, this.fParticle);
        this.contentRestore();
        return object;
    }

    private void traverseSimpleContent(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        String string = this.fName;
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        this.fContentType = 1;
        this.fParticle = null;
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.2", new Object[]{this.fName, SchemaSymbols.ELT_SIMPLECONTENT}, element);
        }
        String string2 = DOMUtil.getLocalName(element2);
        if (string2.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else if (string2.equals(SchemaSymbols.ELT_EXTENSION)) {
            this.fDerivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string2}, element2);
        }
        Element element3 = DOMUtil.getNextSiblingElement(element2);
        if (element3 != null) {
            String string3 = DOMUtil.getLocalName(element3);
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string3}, element3);
        }
        objectArray = this.fAttrChecker.checkAttributes(element2, false, xSDocumentInfo);
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (qName == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.3", new Object[]{this.fName}, element2);
        }
        XSTypeDecl xSTypeDecl = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element2);
        if (xSTypeDecl == null) {
            throw new ComplexTypeRecoverableError();
        }
        this.fBaseType = xSTypeDecl;
        XSSimpleType xSSimpleType = null;
        XSComplexTypeDecl xSComplexTypeDecl = null;
        short s = 0;
        if (xSTypeDecl.getXSType() == 1) {
            xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDecl;
            if (xSComplexTypeDecl.getContentType() != 1) {
                throw new ComplexTypeRecoverableError("src-ct.2", new Object[]{this.fName}, element2);
            }
            s = xSComplexTypeDecl.getFinalSet();
            xSSimpleType = xSComplexTypeDecl.getXSSimpleType();
        } else {
            xSSimpleType = (XSSimpleType)xSTypeDecl;
            if (this.fDerivedBy == 2) {
                throw new ComplexTypeRecoverableError("src-ct.2", new Object[]{this.fName}, element2);
            }
            s = xSSimpleType.getFinalSet();
        }
        if ((s & this.fDerivedBy) != 0) {
            String string4 = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(string4, new Object[]{this.fName}, element2);
        }
        if ((element2 = DOMUtil.getFirstChildElement(element2)) != null) {
            if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(element2, null, false, xSDocumentInfo);
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{string, SchemaSymbols.ELT_ANNOTATION}, element2);
            }
        }
        if (this.fDerivedBy == 2) {
            Object object;
            Object object2;
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                object2 = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar);
                if (object2 == null) {
                    throw new ComplexTypeRecoverableError();
                }
                if (!XSConstraints.checkSimpleDerivationOk((XSSimpleType)object2, xSSimpleType, xSSimpleType.getFinalSet())) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.1.1", new Object[]{string}, element2);
                }
                xSSimpleType = object2;
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            object2 = null;
            XSFacets xSFacets = null;
            short s2 = 0;
            short s3 = 0;
            if (element2 != null) {
                object = this.traverseFacets(element2, null, string, xSSimpleType, xSDocumentInfo, schemaGrammar);
                object2 = ((XSDAbstractTraverser.FacetInfo)object).nodeAfterFacets;
                xSFacets = ((XSDAbstractTraverser.FacetInfo)object).facetdata;
                s2 = ((XSDAbstractTraverser.FacetInfo)object).fPresentFacets;
                s3 = ((XSDAbstractTraverser.FacetInfo)object).fFixedFacets;
            }
            this.fXSSimpleType = this.schemaFactory.createTypeRestriction(null, xSDocumentInfo.fTargetNamespace, (short)0, xSSimpleType);
            try {
                this.fValidationState.setNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
                this.fXSSimpleType.applyFacets(xSFacets, s2, s3, this.fValidationState);
            }
            catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
                this.reportSchemaError(invalidDatatypeFacetException.getKey(), invalidDatatypeFacetException.getArgs(), element2);
            }
            if (object2 != null) {
                if (!this.isAttrOrAttrGroup((Element)object2)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object2)}, (Element)object2);
                }
                object = this.traverseAttrsAndAttrGrps((Element)object2, this.fAttrGrp, xSDocumentInfo, schemaGrammar);
                if (object != null) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object)}, (Element)object);
                }
            }
            this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, string, false, element);
            this.fAttrGrp.removeProhibitedAttrs();
            object = this.fAttrGrp.validRestrictionOf(xSComplexTypeDecl.getAttrGrp());
            if (object != null) {
                throw new ComplexTypeRecoverableError((String)object, new Object[]{this.fName}, (Element)object2);
            }
        } else {
            this.fXSSimpleType = xSSimpleType;
            if (element2 != null) {
                Element element4 = element2;
                if (!this.isAttrOrAttrGroup(element4)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(element4)}, element4);
                }
                Element element5 = this.traverseAttrsAndAttrGrps(element4, this.fAttrGrp, xSDocumentInfo, schemaGrammar);
                if (element5 != null) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(element5)}, element5);
                }
                this.fAttrGrp.removeProhibitedAttrs();
            }
            if (xSComplexTypeDecl != null) {
                this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, string, true, element);
            }
        }
    }

    private void traverseComplexContent(Element element, boolean bl, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        String string = this.fName;
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        boolean bl2 = bl;
        Boolean bl3 = (Boolean)objectArray[XSAttributeChecker.ATTIDX_MIXED];
        if (bl3 != null) {
            bl2 = bl3;
        }
        this.fXSSimpleType = null;
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.2", new Object[]{string, SchemaSymbols.ELT_COMPLEXCONTENT}, element);
        }
        String string2 = DOMUtil.getLocalName(element2);
        if (string2.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else if (string2.equals(SchemaSymbols.ELT_EXTENSION)) {
            this.fDerivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{string, string2}, element2);
        }
        Element element3 = DOMUtil.getNextSiblingElement(element2);
        if (element3 != null) {
            String string3 = DOMUtil.getLocalName(element3);
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{string, string3}, element3);
        }
        objectArray = this.fAttrChecker.checkAttributes(element2, false, xSDocumentInfo);
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (qName == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.3", new Object[]{string}, element2);
        }
        XSTypeDecl xSTypeDecl = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element2);
        if (xSTypeDecl == null) {
            throw new ComplexTypeRecoverableError();
        }
        if (!(xSTypeDecl instanceof XSComplexTypeDecl)) {
            throw new ComplexTypeRecoverableError("src-ct.1", new Object[]{string}, element2);
        }
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDecl;
        this.fBaseType = xSComplexTypeDecl;
        if ((xSComplexTypeDecl.getFinalSet() & this.fDerivedBy) != 0) {
            String string4 = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(string4, new Object[]{this.fName}, element2);
        }
        if ((element2 = DOMUtil.getFirstChildElement(element2)) != null) {
            if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(element2, null, false, xSDocumentInfo);
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{string, SchemaSymbols.ELT_ANNOTATION}, element2);
            }
        }
        this.processComplexContent(element2, bl2, true, xSDocumentInfo, schemaGrammar);
        XSParticleDecl xSParticleDecl = xSComplexTypeDecl.getParticle();
        if (this.fDerivedBy == 2) {
            if (this.fParticle == null && xSParticleDecl != null && !xSParticleDecl.emptiable()) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.2", new Object[]{string}, element2);
            }
            if (this.fParticle != null && xSParticleDecl == null) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.3", new Object[]{string}, element2);
            }
            this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, string, false, element2);
            String string5 = this.fAttrGrp.validRestrictionOf(xSComplexTypeDecl.getAttrGrp());
            if (string5 != null) {
                throw new ComplexTypeRecoverableError(string5, new Object[]{string}, element2);
            }
            this.fAttrGrp.removeProhibitedAttrs();
        } else {
            if (xSComplexTypeDecl.getContentType() != 0 && (xSComplexTypeDecl.getContentType() == 3 && bl2 || xSComplexTypeDecl.getContentType() == 2 && !bl2)) {
                throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.2.2.2.2.1", new Object[]{string}, element2);
            }
            if (this.fParticle == null) {
                this.fParticle = xSParticleDecl;
            } else if (xSParticleDecl != null) {
                if (this.fParticle.fType == 5 || xSComplexTypeDecl.getParticle().fType == 5) {
                    throw new ComplexTypeRecoverableError("cos-all-limited.1.2", new Object[]{string}, element2);
                }
                XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
                xSParticleDecl2.fType = (short)4;
                xSParticleDecl2.fValue = xSParticleDecl;
                xSParticleDecl2.fOtherValue = this.fParticle;
                this.fParticle = xSParticleDecl2;
            }
            this.fContentType = bl2 ? (short)2 : (this.fParticle == null ? (short)0 : (short)3);
            this.fAttrGrp.removeProhibitedAttrs();
            this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, string, true, element2);
        }
    }

    private void mergeAttributes(XSAttributeGroupDecl xSAttributeGroupDecl, XSAttributeGroupDecl xSAttributeGroupDecl2, String string, boolean bl, Element element) throws ComplexTypeRecoverableError {
        XSAttributeUse[] xSAttributeUseArray = xSAttributeGroupDecl.getAttributeUses();
        Object var8_7 = null;
        int n = 0;
        while (n < xSAttributeUseArray.length) {
            XSAttributeUse xSAttributeUse = xSAttributeGroupDecl2.getAttributeUse(xSAttributeUseArray[n].fAttrDecl.fTargetNamespace, xSAttributeUseArray[n].fAttrDecl.fName);
            if (xSAttributeUse == null) {
                String string2 = xSAttributeGroupDecl2.addAttributeUse(xSAttributeUseArray[n]);
                if (string2 != null) {
                    throw new ComplexTypeRecoverableError("ct-props-correct.5", new Object[]{string, string2, xSAttributeUseArray[n].fAttrDecl.fName}, element);
                }
            } else if (bl) {
                throw new ComplexTypeRecoverableError("ct-props-correct.4", new Object[]{string, xSAttributeUse.fAttrDecl.fName}, element);
            }
            ++n;
        }
        if (bl) {
            if (xSAttributeGroupDecl2.fAttributeWC == null) {
                xSAttributeGroupDecl2.fAttributeWC = xSAttributeGroupDecl.fAttributeWC;
            } else if (xSAttributeGroupDecl.fAttributeWC != null) {
                xSAttributeGroupDecl2.fAttributeWC = xSAttributeGroupDecl2.fAttributeWC.performUnionWith(xSAttributeGroupDecl.fAttributeWC, xSAttributeGroupDecl2.fAttributeWC.fProcessContents);
            }
        }
    }

    private void processComplexContent(Element element, boolean bl, boolean bl2, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        Object object;
        Element element2 = null;
        XSParticleDecl xSParticleDecl = null;
        String string = this.fName;
        if (element != null) {
            object = DOMUtil.getLocalName(element);
            if (((String)object).equals(SchemaSymbols.ELT_GROUP)) {
                xSParticleDecl = this.fSchemaHandler.fGroupTraverser.traverseLocal(element, xSDocumentInfo, schemaGrammar);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_SEQUENCE)) {
                xSParticleDecl = this.traverseSequence(element, xSDocumentInfo, schemaGrammar, 0);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_CHOICE)) {
                xSParticleDecl = this.traverseChoice(element, xSDocumentInfo, schemaGrammar, 0);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_ALL)) {
                xSParticleDecl = this.traverseAll(element, xSDocumentInfo, schemaGrammar, 8);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else {
                element2 = element;
            }
        }
        this.fParticle = xSParticleDecl;
        this.fContentType = bl ? (short)2 : (this.fParticle == null ? (short)0 : (short)3);
        if (element2 != null) {
            if (!this.isAttrOrAttrGroup(element2)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(element2)}, element2);
            }
            object = this.traverseAttrsAndAttrGrps(element2, this.fAttrGrp, xSDocumentInfo, schemaGrammar);
            if (object != null) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object)}, (Element)object);
            }
            if (!bl2) {
                this.fAttrGrp.removeProhibitedAttrs();
            }
        }
    }

    private boolean isAttrOrAttrGroup(Element element) {
        String string = DOMUtil.getLocalName(element);
        return string.equals(SchemaSymbols.ELT_ATTRIBUTE) || string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || string.equals(SchemaSymbols.ELT_ANYATTRIBUTE);
    }

    private void traverseSimpleContentDecl(Element element) {
    }

    private void traverseComplexContentDecl(Element element, boolean bl) {
    }

    private String genAnonTypeName(Element element) {
        Element element2 = DOMUtil.getParent(element);
        String string = "#AnonType_";
        while (element2 != null && element2 != DOMUtil.getRoot(DOMUtil.getDocument(element2))) {
            string = string + element2.getAttribute(SchemaSymbols.ATT_NAME);
            element2 = DOMUtil.getParent(element2);
        }
        return string;
    }

    private void handleComplexTypeError(String string, Object[] objectArray, Element element) {
        if (string != null) {
            this.reportSchemaError(string, objectArray, element);
        }
        this.fContentType = (short)2;
        this.fParticle = XSDComplexTypeTraverser.getErrorContent();
    }

    private static XSParticleDecl getErrorContent() {
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fType = (short)4;
        XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
        XSWildcardDecl xSWildcardDecl = new XSWildcardDecl();
        xSWildcardDecl.fProcessContents = (short)2;
        xSParticleDecl2.fType = (short)2;
        xSParticleDecl2.fValue = xSWildcardDecl;
        xSParticleDecl2.fMinOccurs = 0;
        xSParticleDecl2.fMaxOccurs = -1;
        xSParticleDecl.fValue = xSParticleDecl2;
        xSParticleDecl.fOtherValue = null;
        return xSParticleDecl;
    }

    private void contentBackup() {
        if (this.fGlobalStore == null) {
            this.fGlobalStore = new Object[GLOBAL_NUM];
            this.fGlobalStorePos = 0;
        }
        if (this.fGlobalStorePos == this.fGlobalStore.length) {
            Object[] objectArray = new Object[this.fGlobalStorePos + GLOBAL_NUM];
            System.arraycopy(this.fGlobalStore, 0, objectArray, 0, this.fGlobalStorePos);
            this.fGlobalStore = objectArray;
        }
        this.fGlobalStore[this.fGlobalStorePos++] = this.fIsAbstract ? Boolean.TRUE : Boolean.FALSE;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fIsAnonymous ? Boolean.TRUE : Boolean.FALSE;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fName;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fTargetNamespace;
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fDerivedBy << 16) + this.fFinal);
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fBlock << 16) + this.fContentType);
        this.fGlobalStore[this.fGlobalStorePos++] = this.fBaseType;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fAttrGrp;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fParticle;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fXSSimpleType;
    }

    private void contentRestore() {
        this.fXSSimpleType = (XSSimpleType)this.fGlobalStore[--this.fGlobalStorePos];
        this.fParticle = (XSParticleDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fAttrGrp = (XSAttributeGroupDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBaseType = (XSTypeDecl)this.fGlobalStore[--this.fGlobalStorePos];
        int n = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBlock = (short)(n >> 16);
        this.fContentType = (short)n;
        n = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fDerivedBy = (short)(n >> 16);
        this.fFinal = (short)n;
        this.fTargetNamespace = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fName = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fIsAnonymous = (Boolean)this.fGlobalStore[--this.fGlobalStorePos];
        this.fIsAbstract = (Boolean)this.fGlobalStore[--this.fGlobalStorePos];
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        Object[] errorSubstText = null;
        Element errorElem = null;

        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String string, Object[] objectArray, Element element) {
            super(string);
            this.errorSubstText = objectArray;
            this.errorElem = element;
        }
    }
}

