/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.ls.DOMWriter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.SerializerMessageFormatter;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer
implements DOMWriter {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected final SymbolTable fSymbolTable = new SymbolTable();
    protected String fEmptySymbol;
    protected String fXmlSymbol;
    protected String fXmlnsSymbol;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    private boolean fPreserveSpace;
    protected boolean fNamespaces = false;
    private String fEncoding;
    private String fLastEncoding;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        try {
            String string4;
            String string5;
            Object object;
            if (this._printer == null) {
                String string6 = SerializerMessageFormatter.formatMessage("NoWriterSupplied", null);
                throw new IllegalStateException(string6);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2 == null || string2.length() == 0 ? string3 : string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl2 = elementState.preserveSpace;
            attributes = this.extractNamespaces(attributes);
            if (string3 == null || string3.length() == 0) {
                if (string2 == null) {
                    String string7 = SerializerMessageFormatter.formatMessage("NoName", null);
                    throw new SAXException(string7);
                }
                string3 = string != null && !string.equals("") ? ((object = this.getPrefix(string)) != null && ((String)object).length() > 0 ? (String)object + ":" + string2 : string2) : string2;
                bl = true;
            }
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    this._printer.printSpace();
                    string5 = attributes.getQName(n);
                    if (string5 != null && string5.length() == 0) {
                        string5 = attributes.getLocalName(n);
                        String string8 = attributes.getURI(n);
                        if (!(string8 == null || string8.length() == 0 || string != null && string.length() != 0 && string8.equals(string) || (object = this.getPrefix(string8)) == null || ((String)object).length() <= 0)) {
                            string5 = (String)object + ":" + string5;
                        }
                    }
                    if ((string4 = attributes.getValue(n)) == null) {
                        string4 = "";
                    }
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    if (string5.equals("xml:space")) {
                        bl2 = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            if (this._prefixes != null) {
                object = this._prefixes.keys();
                while (object.hasMoreElements()) {
                    this._printer.printSpace();
                    string4 = (String)object.nextElement();
                    string5 = (String)this._prefixes.get(string4);
                    if (string5.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string, string2, string3, bl2);
            string5 = string2 == null || string2.length() == 0 ? string3 : string + "^" + string2;
            elementState.doCData = this._format.isCDataElement(string5);
            elementState.unescaped = this._format.isNonEscapingElement(string5);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.endElementIO(string, string2, string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string, String string2, String string3) throws IOException {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.afterComment = false;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                String string2 = SerializerMessageFormatter.formatMessage("NoWriterSupplied", null);
                throw new IllegalStateException(string2);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(string);
            this._printer.indent();
            if (attributeList != null) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    this._printer.printSpace();
                    String string3 = attributeList.getName(n);
                    String string4 = attributeList.getValue(n);
                    if (string4 != null) {
                        this._printer.printText(string3);
                        this._printer.printText("=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                    }
                    if (string3.equals("xml:space")) {
                        bl = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            elementState = this.enterElementState(null, null, string, bl);
            elementState.doCData = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    protected void startDocument(String string) throws IOException {
        String string2 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                if (this._format.getEncoding() != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(this._format.getEncoding());
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int n = 0;
                            while (n < 18 + string.length()) {
                                this._printer.printText(" ");
                                ++n;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (string2 != null && string2.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string2, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (string2 != null && string2.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    this._printer.printText(" [");
                    this.printText(string2, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    /*
     * Unable to fully structure code
     */
    protected void serializeElement(Element var1_1) throws IOException {
        block59: {
            block58: {
                if (this.fNamespaces) {
                    this.fLocalNSBinder.reset(this.fSymbolTable);
                    this.fLocalNSBinder.pushContext();
                    this.fNSBinder.pushContext();
                }
                var9_2 = var1_1.getTagName();
                var6_3 = this.getElementState();
                if (this.isDocumentState()) {
                    v0 = this.fDOML1 = var1_1.getLocalName() == null;
                    if (!this._started) {
                        this.startDocument(var9_2);
                    }
                } else {
                    if (var6_3.empty) {
                        this._printer.printText('>');
                    }
                    if (var6_3.inCData) {
                        this._printer.printText("]]>");
                        var6_3.inCData = false;
                    }
                    if (this._indenting && !var6_3.preserveSpace && (var6_3.empty || var6_3.afterElement || var6_3.afterComment)) {
                        this._printer.breakLine();
                    }
                }
                this.fPreserveSpace = var6_3.preserveSpace;
                var12_4 = 0;
                var3_5 = null;
                if (var1_1.hasAttributes()) {
                    var3_5 = var1_1.getAttributes();
                    var12_4 = var3_5.getLength();
                }
                if (this.fNamespaces) break block58;
                this._printer.printText('<');
                this._printer.printText(var9_2);
                this._printer.indent();
                var4_6 = 0;
                while (var4_6 < var12_4) {
                    var2_7 = (Attr)var3_5.item(var4_6);
                    var7_8 = var2_7.getName();
                    var8_9 = var2_7.getValue();
                    if (var8_9 == null) {
                        var8_9 = "";
                    }
                    if (var2_7.getSpecified()) {
                        this._printer.printSpace();
                        this._printer.printText(var7_8);
                        this._printer.printText("=\"");
                        this.printEscaped(var8_9);
                        this._printer.printText('\"');
                    }
                    if (var7_8.equals("xml:space")) {
                        this.fPreserveSpace = var8_9.equals("preserve") != false ? true : this._format.getPreserveSpace();
                    }
                    ++var4_6;
                }
                break block59;
            }
            var11_10 = var1_1.getNamespaceURI();
            var10_11 = var1_1.getPrefix();
            if (var11_10 != null && var10_11 != null && var11_10.length() == 0 && var10_11.length() != 0) {
                var10_11 = null;
                this._printer.printText('<');
                this._printer.printText(var1_1.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(var9_2);
                this._printer.indent();
            }
            if (var11_10 != null) {
                var11_10 = this.fSymbolTable.addSymbol(var11_10);
                v1 = var10_11 = var10_11 == null || var10_11.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_11);
                if (this.fNSBinder.getURI(var10_11) != var11_10) {
                    this.printNamespaceAttr(var10_11, var11_10);
                    this.fLocalNSBinder.declarePrefix(var10_11, var11_10);
                    this.fNSBinder.declarePrefix(var10_11, var11_10);
                }
            } else {
                var13_12 = var9_2.indexOf(58);
                if (var13_12 > -1) {
                    var14_17 = var9_2.lastIndexOf(58);
                    if (var13_12 != var14_17) {
                        if (this.fDOMErrorHandler != null) {
                            var15_19 = SerializerMessageFormatter.formatMessage("ElementQName", new Object[]{var9_2});
                            this.modifyDOMError(var15_19, (short)1);
                            var16_22 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        }
                    } else if (this.fDOMErrorHandler != null) {
                        var15_19 = SerializerMessageFormatter.formatMessage("ElementPrefix", new Object[]{var9_2});
                        this.modifyDOMError(var15_19, (short)0);
                        var16_22 = this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                } else {
                    var11_10 = this.fNSBinder.getURI(this.fEmptySymbol);
                    if (var11_10 != null && var11_10.length() > 0) {
                        this.printNamespaceAttr(this.fEmptySymbol, this.fEmptySymbol);
                        this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                        this.fNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                    }
                }
            }
            var4_6 = 0;
            while (var4_6 < var12_4) {
                block61: {
                    block60: {
                        var2_7 = (Attr)var3_5.item(var4_6);
                        var8_9 = var2_7.getValue();
                        var7_8 = var2_7.getNodeName();
                        var11_10 = var2_7.getNamespaceURI();
                        if (var11_10 != null && var11_10.length() == 0) {
                            var11_10 = null;
                            var7_8 = var2_7.getLocalName();
                        }
                        if (var8_9 == null) {
                            var8_9 = this.fEmptySymbol;
                        }
                        if (var11_10 == null) break block60;
                        var10_11 = var2_7.getPrefix();
                        var10_11 = var10_11 == null ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_11);
                        var14_18 = this.fSymbolTable.addSymbol(var2_7.getLocalName());
                        if (var10_11 == this.fXmlnsSymbol) {
                            var11_10 = this.fNSBinder.getURI(var14_18);
                            var13_13 = this.fLocalNSBinder.getURI(var14_18);
                            var8_9 = this.fSymbolTable.addSymbol(var8_9);
                            if ((var11_10 == null || var13_13 == null) && var8_9.length() != 0) {
                                this.printNamespaceAttr(var14_18, var8_9);
                                this.fNSBinder.declarePrefix(var14_18, var8_9);
                                this.fLocalNSBinder.declarePrefix(var14_18, var8_9);
                            }
                        } else if (var14_18 == this.fXmlnsSymbol && var10_11 == this.fEmptySymbol) {
                            var11_10 = this.fNSBinder.getURI(this.fEmptySymbol);
                            var13_14 = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                            var8_9 = this.fSymbolTable.addSymbol(var8_9);
                            if (var13_14 == null) {
                                this.printNamespaceAttr(this.fEmptySymbol, var8_9);
                                this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, var8_9);
                                this.fNSBinder.declarePrefix(this.fEmptySymbol, var8_9);
                            }
                        } else {
                            var11_10 = this.fSymbolTable.addSymbol(var11_10);
                            var15_20 = this.fNSBinder.getURI(var10_11);
                            if (var10_11 == this.fEmptySymbol || var15_20 != var11_10) {
                                var7_8 = var2_7.getNodeName();
                                var16_23 = this.fNSBinder.getPrefix(var11_10);
                                if (var16_23 == null || var16_23 == this.fEmptySymbol) {
                                    if (var10_11 == this.fEmptySymbol) {
                                        var10_11 = "NS" + this.fNamespaceCounter++;
                                    }
                                    this.printNamespaceAttr(var10_11, var11_10);
                                    var8_9 = this.fSymbolTable.addSymbol(var8_9);
                                    this.fLocalNSBinder.declarePrefix(var10_11, var8_9);
                                    this.fNSBinder.declarePrefix(var10_11, var11_10);
                                } else {
                                    var10_11 = var16_23;
                                }
                                var7_8 = var10_11 + ":" + var14_18;
                            }
                            this.printAttribute(var7_8, var8_9 == null ? this.fEmptySymbol : var8_9, var2_7.getSpecified());
                        }
                        break block61;
                    }
                    var14_17 = var7_8.indexOf(58);
                    var15_21 = var7_8.lastIndexOf(58);
                    if (!var7_8.startsWith(this.fXmlnsSymbol)) ** GOTO lbl186
                    if (var14_17 < 0) {
                        var11_10 = this.fNSBinder.getURI(this.fEmptySymbol);
                        var13_15 = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                        if (var13_15 == null) {
                            var8_9 = this.fSymbolTable.addSymbol(var8_9);
                            this.fNSBinder.declarePrefix(this.fEmptySymbol, var8_9);
                            this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, var8_9);
                            this.printAttribute(var7_8, var8_9, var2_7.getSpecified());
                        }
                    } else {
                        if (var14_17 == var15_21) {
                            var10_11 = var7_8.substring(6);
                            v2 = var10_11 = var10_11.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_11);
                            if (var10_11.length() == 0) {
                                if (this.fDOMErrorHandler != null) {
                                    var16_24 = SerializerMessageFormatter.formatMessage("InvalidNSDecl", new Object[]{var7_8});
                                    this.modifyDOMError(var16_24, (short)1);
                                    var17_28 = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (var8_9.length() == 0 && this.fDOMErrorHandler != null) {
                                var16_25 = SerializerMessageFormatter.formatMessage("InvalidNSDecl", new Object[]{var7_8});
                                this.modifyDOMError(var16_25, (short)1);
                                var17_28 = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                            var11_10 = this.fNSBinder.getURI(var10_11);
                            var13_16 = this.fLocalNSBinder.getURI(var10_11);
                            if ((var11_10 == null || var13_16 == null) && var8_9.length() != 0) {
                                var8_9 = this.fSymbolTable.addSymbol(var8_9);
                                this.fNSBinder.declarePrefix(var10_11, var8_9);
                                this.fLocalNSBinder.declarePrefix(var10_11, var8_9);
                            }
                        }
lbl186:
                        // 6 sources

                        if (var14_17 > -1) {
                            if (var14_17 != var15_21) {
                                if (this.fDOMErrorHandler != null) {
                                    var16_26 = SerializerMessageFormatter.formatMessage("AttributeQName", new Object[]{var7_8});
                                    this.modifyDOMError(var16_26, (short)1);
                                    var17_28 = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (this.fDOMErrorHandler != null) {
                                var16_27 = SerializerMessageFormatter.formatMessage("AttributePrefix", new Object[]{var7_8});
                                this.modifyDOMError(var16_27, (short)0);
                                var17_28 = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                            this.printAttribute(var7_8, var8_9, var2_7.getSpecified());
                        } else {
                            this.printAttribute(var7_8, var8_9, var2_7.getSpecified());
                        }
                    }
                }
                ++var4_6;
            }
        }
        if (var1_1.hasChildNodes()) {
            var6_3 = this.enterElementState(null, null, var9_2, this.fPreserveSpace);
            var6_3.doCData = this._format.isCDataElement(var9_2);
            var6_3.unescaped = this._format.isNonEscapingElement(var9_2);
            var5_29 = var1_1.getFirstChild();
            while (var5_29 != null) {
                this.serializeNode(var5_29);
                var5_29 = var5_29.getNextSibling();
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, var9_2);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            var6_3.afterElement = true;
            var6_3.afterComment = false;
            var6_3.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String string, String string2) throws IOException {
        this._printer.printSpace();
        if (string == this.fEmptySymbol) {
            this._printer.printText(this.fXmlnsSymbol);
        } else {
            this._printer.printText(this.fXmlnsSymbol + ":" + string);
        }
        this._printer.printText("=\"");
        this.printEscaped(string2);
        this._printer.printText('\"');
    }

    private void printAttribute(String string, String string2, boolean bl) throws IOException {
        if (bl || this.fFeatures != null && !this.getFeature("discard-default-content")) {
            this._printer.printSpace();
            this._printer.printText(string);
            this._printer.printText("=\"");
            this.printEscaped(string2);
            this._printer.printText('\"');
        }
        if (string.equals("xml:space")) {
            this.fPreserveSpace = string2.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int n) {
        switch (n) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attributes) throws SAXException {
        if (attributes == null) {
            return null;
        }
        int n = attributes.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = attributesImpl.getQName(n2);
            if (string.startsWith("xmlns")) {
                if (string.length() == 5) {
                    this.startPrefixMapping("", attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                } else if (string.charAt(5) == ':') {
                    this.startPrefixMapping(string.substring(6), attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                }
            }
            --n2;
        }
        return attributesImpl;
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
        this.fNSBinder = new NamespaceSupport();
        this.fLocalNSBinder = new NamespaceSupport();
    }

    public void initDOMFeatures() {
        this.fFeatures = new Hashtable();
        this.fFeatures.put("normalize-characters", new Boolean(false));
        this.fFeatures.put("split-cdata-sections", new Boolean(true));
        this.fFeatures.put("validation", new Boolean(false));
        this.fFeatures.put("expand-entity-references", new Boolean(false));
        this.fFeatures.put("whitespace-in-element-content", new Boolean(true));
        this.fFeatures.put("discard-default-content", new Boolean(true));
        this.fFeatures.put("format-canonical", new Boolean(false));
        this.fFeatures.put("format-pretty-print", new Boolean(false));
    }

    private void checkAllFeatures() {
        if (this.getFeature("whitespace-in-element-content")) {
            this._format.setPreserveSpace(true);
        } else {
            this._format.setPreserveSpace(false);
        }
    }

    public void setFeature(String string, boolean bl) throws DOMException {
        if (this.fFeatures == null) {
            this.fFeatures = new Hashtable();
        }
        if (string != null && this.fFeatures.containsKey(string)) {
            if (!this.canSetFeature(string, bl)) {
                String string2 = DOMMessageFormatter.formatMessage("FEATURE_NOT_SUPPORTED", new Object[]{string});
                throw new DOMException(9, string2);
            }
        } else {
            String string3 = DOMMessageFormatter.formatMessage("FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string3);
        }
        this.fFeatures.put(string, new Boolean(bl));
    }

    public boolean canSetFeature(String string, boolean bl) {
        if (string.equals("normalize-characters") && bl) {
            return false;
        }
        if (string.equals("validation") && bl) {
            return false;
        }
        if (string.equals("whitespace-in-element-content") && !bl) {
            return false;
        }
        if (string.equals("format-canonical") && bl) {
            return false;
        }
        return !string.equals("format-pretty-print") || !bl;
    }

    public boolean getFeature(String string) throws DOMException {
        if (this.fFeatures == null) {
            return false;
        }
        Boolean bl = (Boolean)this.fFeatures.get(string);
        if (bl == null) {
            String string2 = DOMMessageFormatter.formatMessage("FEATURE_NOT_FOUND", new Object[]{string});
            throw new DOMException(8, string2);
        }
        return bl;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String string) {
        this._format.setEncoding(string);
        this.fEncoding = this._format.getEncoding();
    }

    public String getLastEncoding() {
        return this.fLastEncoding;
    }

    public String getNewLine() {
        return this._format.getLineSeparator();
    }

    public void setNewLine(String string) {
        this._format.setLineSeparator(string);
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.fDOMErrorHandler = dOMErrorHandler;
    }

    public boolean writeNode(OutputStream outputStream, Node node) throws Exception {
        block7: {
            this.checkAllFeatures();
            try {
                this.setOutputByteStream(outputStream);
                if (node == null) {
                    return false;
                }
                if (node.getNodeType() == 9) {
                    this.serialize((Document)node);
                    break block7;
                }
                if (node.getNodeType() == 11) {
                    this.serialize((DocumentFragment)node);
                    break block7;
                }
                if (node.getNodeType() == 1) {
                    this.serialize((Element)node);
                    break block7;
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
        this.fLastEncoding = this.getEncoding();
        return true;
    }

    public String writeToString(Node node) throws DOMException {
        StringWriter stringWriter;
        block6: {
            this.checkAllFeatures();
            stringWriter = new StringWriter();
            try {
                this.setOutputCharStream(stringWriter);
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 9) {
                    this.serialize((Document)node);
                    break block6;
                }
                if (node.getNodeType() == 11) {
                    this.serialize((DocumentFragment)node);
                    break block6;
                }
                if (node.getNodeType() == 1) {
                    this.serialize((Element)node);
                    break block6;
                }
                return null;
            }
            catch (IOException iOException) {
                String string = DOMMessageFormatter.formatMessage("DOMSTRING_SIZE_ERR", null);
                throw new DOMException(2, string + " " + iOException.getMessage());
            }
        }
        this.fLastEncoding = this.getEncoding();
        return stringWriter.toString();
    }

    public boolean reset() {
        super.reset();
        if (this.fNamespaces) {
            this.fNSBinder.reset(this.fSymbolTable);
            this.fNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
            this.fNamespaceCounter = 1;
            this.fXmlSymbol = this.fSymbolTable.addSymbol("xml");
            this.fXmlnsSymbol = this.fSymbolTable.addSymbol("xmlns");
            this.fEmptySymbol = this.fSymbolTable.addSymbol("");
        }
        return true;
    }
}

