/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BasicChecker
extends PKIXCertPathChecker {
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.BasicConstraints").toString(), OIDMap.getOID((String)"x509.info.extensions.KeyUsage").toString()};
    static final String[] mySometimesExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.ExtKeyUsage").toString()};
    private PublicKey workingPublicKey;
    private Principal workingIssuerName;
    private String workingPubKeyAlg;
    private Set trustBaseSet;
    private Date validationDate;
    private int numberOfCertsInCertPath;
    private CertPath certPath;
    private int currentCertIndex;
    private int maxPathLength;
    private String sigProvider;
    private TrustAnchor anchor;

    public BasicChecker(CertPath certPath, Set set, Date date, String string) throws CertPathValidatorException {
        this.certPath = certPath;
        this.trustBaseSet = set;
        this.validationDate = date;
        this.sigProvider = string;
        List<? extends Certificate> list = certPath.getCertificates();
        this.maxPathLength = this.numberOfCertsInCertPath = list.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        if (this.numberOfCertsInCertPath < 1) {
            return;
        }
        X509Certificate x509Certificate = (X509Certificate)list.get(this.numberOfCertsInCertPath - 1);
        if (x509Certificate != null) {
            try {
                this.anchor = CertPathUtil.findIssuer(x509Certificate, set, string);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("The certificate issued by " + x509Certificate.getIssuerDN().toString() + " is not trusted", (Throwable)certPathValidatorException, certPath, this.numberOfCertsInCertPath - 1);
            }
            X509Certificate x509Certificate2 = this.anchor.getTrustedCert();
            if (x509Certificate2 != null) {
                if (!(x509Certificate2 instanceof X509CertImpl)) {
                    try {
                        x509Certificate2 = new X509CertImpl(x509Certificate2.getEncoded());
                    }
                    catch (CertificateException certificateException) {
                        throw new CertPathValidatorException(certificateException.getMessage());
                    }
                }
                this.workingPublicKey = x509Certificate2.getPublicKey();
                this.workingIssuerName = x509Certificate2.getSubjectDN();
                this.workingPubKeyAlg = this.workingPublicKey.getAlgorithm();
            } else {
                this.workingPublicKey = this.anchor.getCAPublicKey();
                try {
                    this.workingIssuerName = new X500Name(this.anchor.getCAName());
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("I/O error while processing trust anchor's ca name", (Throwable)iOException, certPath, this.numberOfCertsInCertPath - 1);
                }
                this.workingPubKeyAlg = this.workingPublicKey.getAlgorithm();
            }
        } else {
            throw new CertPathValidatorException("No certificates in the path", null, certPath, this.numberOfCertsInCertPath - 1);
        }
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("The direction of forward is not supported");
        }
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        X509CertImpl x509CertImpl;
        if (certificate instanceof X509CertImpl) {
            x509CertImpl = (X509CertImpl)certificate;
        } else {
            try {
                x509CertImpl = new X509CertImpl(certificate.getEncoded());
            }
            catch (CertificateException certificateException) {
                throw new CertPathValidatorException(certificateException.getMessage());
            }
        }
        try {
            int n = CertPathUtil.verifyIssuer((X509Certificate)x509CertImpl, this.workingPublicKey, this.workingIssuerName, this.sigProvider);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Fail to verify issuer", (Throwable)certPathValidatorException, this.certPath, this.currentCertIndex);
        }
        try {
            x509CertImpl.checkValidity(this.validationDate);
        }
        catch (CertificateExpiredException certificateExpiredException) {
            throw new CertPathValidatorException("The certificate expired at " + x509CertImpl.getNotAfter(), (Throwable)certificateExpiredException, this.certPath, this.currentCertIndex);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            throw new CertPathValidatorException("The certificate is not valid until " + x509CertImpl.getNotBefore(), (Throwable)certificateNotYetValidException, this.certPath, this.currentCertIndex);
        }
        if (this.currentCertIndex > 0) {
            String string;
            int n;
            boolean bl = true;
            Object[] objectArray = CertPathUtil.getBasicConstraints((X509Certificate)x509CertImpl);
            if (objectArray[0] == null) {
                throw new CertPathValidatorException("The CA certificate did not contain BasicConstraints", null, this.certPath, this.currentCertIndex);
            }
            bl = (Boolean)objectArray[1];
            if (!bl) {
                throw new CertPathValidatorException("The certificate is not a CA certificate.", null, this.certPath, this.currentCertIndex);
            }
            if (!x509CertImpl.getIssuerDN().equals(x509CertImpl.getSubjectDN())) {
                if (this.maxPathLength > 0) {
                    --this.maxPathLength;
                } else {
                    throw new CertPathValidatorException("Max path length incorrect", null, this.certPath, this.currentCertIndex);
                }
            }
            if ((n = ((Integer)objectArray[2]).intValue()) >= 0 && n < this.maxPathLength) {
                this.maxPathLength = n;
            }
            if ((string = this.checkKeyUsage((X509Certificate)x509CertImpl, collection)) != null) {
                throw new CertPathValidatorException(string, null, this.certPath, this.currentCertIndex);
            }
            this.workingPublicKey = x509CertImpl.getPublicKey();
            this.workingIssuerName = x509CertImpl.getSubjectDN();
            --this.currentCertIndex;
        }
        CertPathUtil.removeExtensions(collection, myExtensions);
    }

    public Object clone() {
        return null;
    }

    String checkKeyUsage(X509Certificate x509Certificate, Collection collection) throws CertPathValidatorException {
        String string = null;
        boolean[] blArray = CertPathUtil.getKeyUsage(x509Certificate);
        if (blArray != null) {
            if (!blArray[5]) {
                string = "This certificate may not sign other certificates";
                return string;
            }
            Collection collection2 = CertPathUtil.getExtendedKeyUsage(x509Certificate);
            if (collection2 != null) {
                Iterator iterator = collection2.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string2.equals("1.3.6.1.5.5.7.1")) {
                        if (!blArray[0] && !blArray[2] && !blArray[4]) continue;
                        bl = true;
                        break;
                    }
                    if (string2.equals("1.3.6.1.5.5.7.2")) {
                        if (!blArray[0] && !blArray[4]) continue;
                        bl = true;
                        break;
                    }
                    if (string2.equals("1.3.6.1.5.5.7.3")) {
                        if (!blArray[0]) continue;
                        bl = true;
                        break;
                    }
                    if (string2.equals("1.3.6.1.5.5.7.4")) {
                        if (!blArray[0] && !blArray[1] && !blArray[2] && !blArray[4]) continue;
                        bl = true;
                        break;
                    }
                    if (!string2.equals("1.3.6.1.5.5.7.8") || !blArray[0] && !blArray[1]) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    string = "Inconsistent key usage in the certificate.";
                }
            }
        }
        return string;
    }

    public TrustAnchor getTrustAnchor() {
        return this.anchor;
    }
}

