/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralSubtree;
import com.ibm.security.x509.GeneralSubtrees;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.OIDMap;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class NameChecker
extends PKIXCertPathChecker {
    static final int NAME_CONSTRAINTS_ERROR = 5;
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.NameConstraints").toString(), OIDMap.getOID((String)"x509.info.extensions.SubjectAlternativeName").toString()};
    private int numberOfCertsInCertPath;
    private CertPath certPath;
    private int currentCertIndex;
    private ArrayList[] permittedSubtrees;
    private ArrayList[] excludedSubtrees;
    private String sigProvider;

    public NameChecker(CertPath certPath, String string) throws CertPathValidatorException {
        this.certPath = certPath;
        List<? extends Certificate> list = certPath.getCertificates();
        this.numberOfCertsInCertPath = list.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        this.sigProvider = string;
        this.permittedSubtrees = null;
        this.excludedSubtrees = null;
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("The direction of forward is not supported.");
        }
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN()) || this.currentCertIndex <= 0) {
            Iterator iterator;
            int n;
            Cloneable cloneable;
            GeneralSubtrees generalSubtrees = null;
            GeneralSubtrees generalSubtrees2 = null;
            if (this.permittedSubtrees != null) {
                cloneable = new Vector<GeneralSubtree>();
                n = 0;
                while (n < this.permittedSubtrees.length) {
                    iterator = this.permittedSubtrees[n].iterator();
                    while (iterator.hasNext()) {
                        ((Vector)cloneable).add(new GeneralSubtree((GeneralName)iterator.next(), 0, 1));
                    }
                    ++n;
                }
                try {
                    generalSubtrees = new GeneralSubtrees(cloneable);
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("An internal error has occurred.", iOException);
                }
            }
            if (this.excludedSubtrees != null) {
                cloneable = new Vector();
                n = 0;
                while (n < this.excludedSubtrees.length) {
                    iterator = this.excludedSubtrees[n].iterator();
                    while (iterator.hasNext()) {
                        ((Vector)cloneable).add(new GeneralSubtree((GeneralName)iterator.next(), 0, 1));
                    }
                    ++n;
                }
                try {
                    generalSubtrees2 = new GeneralSubtrees(cloneable);
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("An internal error has occurred.", iOException);
                }
            }
            try {
                generalSubtrees2 = new GeneralSubtrees(new Vector());
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
            cloneable = null;
            try {
                NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(generalSubtrees, generalSubtrees2);
                cloneable = new X509CertSelector();
                ((X509CertSelector)cloneable).setNameConstraints(nameConstraintsExtension.getExtensionValue());
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
            if (!((X509CertSelector)cloneable).match(x509Certificate)) {
                throw new CertPathValidatorException("The certificate failed the name constraint check", null, this.certPath, this.currentCertIndex);
            }
            if (this.currentCertIndex < this.numberOfCertsInCertPath) {
                this.processNameConstraints(x509Certificate);
            }
        }
        --this.currentCertIndex;
        CertPathUtil.removeExtensions(collection, myExtensions);
    }

    public Object clone() {
        return null;
    }

    private void processNameConstraints(X509Certificate x509Certificate) throws CertPathValidatorException {
        NameConstraintsExtension nameConstraintsExtension = null;
        Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.NameConstraints", x509Certificate);
        if (objectArray[1] != null) {
            try {
                nameConstraintsExtension = new NameConstraintsExtension((Boolean)objectArray[0], objectArray[1]);
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        if (nameConstraintsExtension != null) {
            ArrayList[] arrayListArray;
            GeneralSubtrees generalSubtrees;
            if (!nameConstraintsExtension.isCritical()) {
                throw new CertPathValidatorException("The NameConstraints extension was not critical.");
            }
            try {
                generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("permitted_subtrees");
                if (generalSubtrees != null) {
                    arrayListArray = this.processGeneralSubtrees(generalSubtrees);
                    this.permittedSubtrees = this.intersectPermittedSubtrees(arrayListArray);
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
            try {
                generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("excluded_subtrees");
                if (generalSubtrees != null) {
                    arrayListArray = this.processGeneralSubtrees(generalSubtrees);
                    this.excludedSubtrees = this.unionExcludedSubtrees(arrayListArray);
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
    }

    private ArrayList[] intersectPermittedSubtrees(ArrayList[] arrayListArray) throws IOException {
        block7: {
            boolean bl = true;
            int n = 0;
            while (n < arrayListArray.length) {
                if (!arrayListArray[n].isEmpty()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) break block7;
            if (this.permittedSubtrees == null) {
                this.permittedSubtrees = new ArrayList[9];
                int n2 = 0;
                while (n2 < this.permittedSubtrees.length) {
                    this.permittedSubtrees[n2].addAll(arrayListArray[n2]);
                    ++n2;
                }
            } else {
                ArrayList arrayList = null;
                int n3 = 0;
                while (n3 < this.permittedSubtrees.length) {
                    if (arrayListArray[n3] != null) {
                        arrayList = this.intersectPermittedSubtree(n3, this.permittedSubtrees[n3], arrayListArray[n3]);
                        this.permittedSubtrees[n3].clear();
                        this.permittedSubtrees[n3].addAll(arrayList);
                    }
                    ++n3;
                }
            }
        }
        return this.permittedSubtrees;
    }

    private ArrayList intersectPermittedSubtree(int n, ArrayList arrayList, ArrayList arrayList2) throws IOException {
        ArrayList<GeneralName> arrayList3 = new ArrayList<GeneralName>();
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        block4: while (iterator.hasNext()) {
            String string;
            GeneralName generalName;
            String string2;
            Object object;
            GeneralName generalName2 = (GeneralName)iterator.next();
            bl = false;
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                object = (GeneralName)iterator2.next();
                if (!generalName2.toString().equals(object.toString())) continue;
                bl = true;
                arrayList3.add((GeneralName)object);
                break;
            }
            if (bl) continue;
            object = null;
            Object var10_10 = null;
            if (n == 6 || n == 1) {
                try {
                    string2 = this.getGeneralNameString(generalName2);
                    if (string2.startsWith(".")) {
                        object = arrayList2.iterator();
                        while (object.hasNext()) {
                            generalName = (GeneralName)object.next();
                            string = this.getGeneralNameString(generalName);
                            if (!string.endsWith(string2.substring(1))) continue;
                            arrayList3.add(generalName);
                        }
                        continue;
                    }
                    object = arrayList2.iterator();
                    while (object.hasNext()) {
                        generalName = (GeneralName)object.next();
                        string = this.getGeneralNameString(generalName);
                        if (string.startsWith(".") && string2.endsWith(string.substring(1))) {
                            arrayList3.add(generalName2);
                            continue block4;
                        }
                        if (string.endsWith("@" + string2)) {
                            arrayList3.add(generalName);
                            continue;
                        }
                        if (!string2.endsWith("@" + string)) continue;
                        arrayList3.add(generalName2);
                        continue block4;
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            if (n != 2) continue;
            string2 = this.getGeneralNameString(generalName2);
            object = arrayList2.iterator();
            while (object.hasNext()) {
                try {
                    generalName = (GeneralName)object.next();
                    string = this.getGeneralNameString(generalName);
                    if (string2.endsWith(string)) {
                        arrayList3.add(generalName2);
                        continue block4;
                    }
                    if (!string.endsWith(string2)) continue;
                    arrayList3.add(generalName);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return arrayList3;
    }

    private String getGeneralNameString(GeneralName generalName) throws IOException {
        DerOutputStream derOutputStream = null;
        generalName.encode(derOutputStream);
        DerInputStream derInputStream = new DerValue(derOutputStream.toByteArray()).getData();
        return new String(derInputStream.toByteArray()).toLowerCase();
    }

    private ArrayList[] unionExcludedSubtrees(ArrayList[] arrayListArray) throws IOException {
        block7: {
            boolean bl = true;
            int n = 0;
            while (n < arrayListArray.length) {
                if (!arrayListArray[n].isEmpty()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) break block7;
            if (this.excludedSubtrees != null) {
                this.excludedSubtrees = new ArrayList[9];
                int n2 = 0;
                while (n2 < this.excludedSubtrees.length) {
                    this.excludedSubtrees[n2].addAll(arrayListArray[n2]);
                    ++n2;
                }
            } else {
                ArrayList arrayList = null;
                int n3 = 0;
                while (n3 < this.excludedSubtrees.length) {
                    if (arrayListArray[n3] != null) {
                        arrayList = this.unionExcludedSubtree(n3, this.excludedSubtrees[n3], arrayListArray[n3]);
                        this.excludedSubtrees[n3].clear();
                        this.excludedSubtrees[n3].addAll(arrayList);
                    }
                    ++n3;
                }
            }
        }
        return this.excludedSubtrees;
    }

    private ArrayList unionExcludedSubtree(int n, ArrayList arrayList, ArrayList arrayList2) throws IOException {
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        boolean[] blArray = new boolean[arrayList2.size()];
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            GeneralName generalName = (GeneralName)iterator.next();
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                GeneralName generalName2 = (GeneralName)arrayList2.get(n2);
                if (generalName.toString().equals(generalName2.toString())) {
                    blArray[n2] = true;
                    break;
                }
                ++n2;
            }
            arrayList3.add(generalName);
        }
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            if (!blArray[n3]) {
                arrayList3.add(arrayList2.get(n3));
            }
            ++n3;
        }
        return arrayList3;
    }

    private ArrayList[] processGeneralSubtrees(GeneralSubtrees generalSubtrees) {
        ArrayList[] arrayListArray = new ArrayList[9];
        int n = 0;
        while (n < 9) {
            arrayListArray[n] = new ArrayList();
            ++n;
        }
        Iterator iterator = generalSubtrees.getSubtrees().iterator();
        while (iterator.hasNext()) {
            GeneralSubtree generalSubtree = (GeneralSubtree)iterator.next();
            GeneralName generalName = generalSubtree.getBase();
            try {
                arrayListArray[generalName.getType()].add(generalName);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return arrayListArray;
    }
}

