/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.PolicyNodeImpl;
import com.ibm.security.cert.PolicyTree;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.CertificatePolicyMap;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.PolicyMappingsExtension;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PolicyNode;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class PolicyChecker
extends PKIXCertPathChecker {
    private PolicyTree policyTree;
    private X509Certificate certificate;
    private boolean policyQualifiersRejected;
    private Set user_initial_policy_set;
    int inhibit_any_policy;
    private int explicit_policy;
    private int policy_mapping;
    private int currentCertIndex;
    private CertPath certPath;
    public static final ObjectIdentifier anyPolicy_OID;
    private int numberOfCertsInCertPath;
    static final String[] myExtensions;

    public PolicyChecker(CertPath certPath, boolean bl, Set set, int n, int n2, int n3) {
        this.certPath = certPath;
        this.policyQualifiersRejected = bl;
        this.user_initial_policy_set = set;
        this.explicit_policy = n;
        this.policy_mapping = n2;
        this.inhibit_any_policy = n3;
        this.policyTree = new PolicyTree();
        this.numberOfCertsInCertPath = this.certPath.getCertificates().size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        this.certificate = (X509Certificate)certificate;
        Vector vector = new Vector();
        CertificatePoliciesExtension certificatePoliciesExtension = (CertificatePoliciesExtension)CertPathUtil.getPolicyInformation(this.certificate, vector, this.policyQualifiersRejected);
        if (this.certificate.getIssuerDN().equals(this.certificate.getSubjectDN())) {
            --this.currentCertIndex;
            --this.numberOfCertsInCertPath;
            return;
        }
        try {
            if (certificatePoliciesExtension == null || certificatePoliciesExtension.get("cert_policies") == null) {
                this.policyTree.setValid(false);
            } else {
                if (this.policyQualifiersRejected && certificatePoliciesExtension.isCritical()) {
                    throw new CertPathValidatorException("Reject the certificate", null, this.certPath, this.currentCertIndex);
                }
                if (this.policyTree.isValid()) {
                    this.checkPolicies(this.certificate, certificatePoliciesExtension, this.policyTree);
                }
            }
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Internal error occurs while checking certificate policies extension", (Throwable)iOException, this.certPath, this.currentCertIndex);
        }
        if (this.explicit_policy <= 0 && !this.policyTree.isValid()) {
            throw new CertPathValidatorException("Fail to pass policy check.", null, this.certPath, this.currentCertIndex);
        }
        if (this.currentCertIndex > 0) {
            int n;
            int[] nArray;
            PolicyMappingsExtension policyMappingsExtension = null;
            Object[] objectArray = CertPathUtil.getExtension("x509.info.extensions.PolicyMappings", this.certificate);
            if (objectArray[1] != null) {
                try {
                    policyMappingsExtension = new PolicyMappingsExtension((Boolean)objectArray[0], objectArray[1]);
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("An internal error has occurred.", (Throwable)iOException, this.certPath, this.currentCertIndex);
                }
            }
            if (policyMappingsExtension != null) {
                this.checkPolicyMappings(this.certificate, policyMappingsExtension, this.policyTree);
            }
            if (this.explicit_policy != 0) {
                --this.explicit_policy;
            }
            if (this.policy_mapping != 0) {
                --this.policy_mapping;
            }
            if (this.inhibit_any_policy != 0) {
                --this.inhibit_any_policy;
            }
            if ((nArray = CertPathUtil.getPolicyConstraints(this.certificate)) != null) {
                if (nArray[0] < this.explicit_policy) {
                    this.explicit_policy = nArray[0];
                }
                if (nArray[1] < this.policy_mapping) {
                    this.policy_mapping = nArray[1];
                }
            }
            if ((n = CertPathUtil.getInhibitAnyPolicy(this.certificate)) < this.inhibit_any_policy) {
                this.inhibit_any_policy = n;
            }
        }
        CertPathUtil.removeExtensions(collection, myExtensions);
        if (this.currentCertIndex == 0) {
            this.policyTree = this.wrapUp(this.certificate);
        }
        --this.currentCertIndex;
    }

    private void checkPolicies(X509Certificate x509Certificate, CertificatePoliciesExtension certificatePoliciesExtension, PolicyTree policyTree) throws CertPathValidatorException {
        Object object;
        Object object2;
        PolicyNodeImpl policyNodeImpl;
        int n;
        Object object3;
        Object object4;
        boolean bl = certificatePoliciesExtension.isCritical();
        Vector vector = null;
        try {
            vector = (Vector)certificatePoliciesExtension.get("cert_policies");
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("Fail to pass policy check", (Throwable)iOException, this.certPath, this.currentCertIndex);
        }
        ArrayList arrayList = null;
        arrayList = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex - 1);
        int n2 = 0;
        while (n2 < vector.size()) {
            PolicyInformation policyInformation = (PolicyInformation)vector.elementAt(n2);
            object4 = null;
            try {
                object4 = policyInformation.getPolicyIdentifier();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)iOException, this.certPath, this.currentCertIndex);
            }
            if (!object4.equals(anyPolicy_OID)) {
                object3 = policyInformation.getPolicyQualifiers();
                if (object3 == null) {
                    object3 = new Vector();
                }
                boolean bl2 = false;
                n = 0;
                while (n < arrayList.size()) {
                    policyNodeImpl = (PolicyNodeImpl)arrayList.get(n);
                    if (policyNodeImpl.match((ObjectIdentifier)object4)) {
                        bl2 = true;
                        object2 = new HashSet<String>();
                        object2.add(object4.toString());
                        object = new PolicyNodeImpl((ObjectIdentifier)object4, new HashSet(object3), bl, (Set)object2, policyNodeImpl);
                        policyNodeImpl.addChild((PolicyNode)object);
                        policyTree.addNode((PolicyNodeImpl)object);
                    }
                    ++n;
                }
                if (!bl2) {
                    int n3 = 0;
                    while (n3 < arrayList.size()) {
                        object2 = (PolicyNodeImpl)arrayList.get(n3);
                        if (((PolicyNodeImpl)object2).getValidPolicy().equals(anyPolicy_OID.toString())) {
                            object = new HashSet();
                            object.add(object4.toString());
                            PolicyNodeImpl policyNodeImpl2 = new PolicyNodeImpl((ObjectIdentifier)object4, new HashSet(object3), bl, (Set)object, (PolicyNode)object2);
                            ((PolicyNodeImpl)object2).addChild(policyNodeImpl2);
                            policyTree.addNode(policyNodeImpl2);
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            object4 = (PolicyInformation)vector.elementAt(n4);
            object3 = null;
            try {
                object3 = object4.getPolicyIdentifier();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)iOException, this.certPath, this.currentCertIndex);
            }
            if (object3.equals(anyPolicy_OID) && CertPathUtil.getInhibitAnyPolicy(x509Certificate) > 0) {
                Vector vector2 = object4.getPolicyQualifiers();
                if (vector2 == null) {
                    vector2 = new Vector();
                }
                n = 0;
                while (n < arrayList.size()) {
                    policyNodeImpl = (PolicyNodeImpl)arrayList.get(n);
                    object2 = policyNodeImpl.getExpectedPolicies().iterator();
                    while (object2.hasNext()) {
                        Object object5;
                        object = null;
                        try {
                            object = new ObjectIdentifier((String)object2.next());
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                        boolean bl3 = false;
                        Iterator iterator = policyNodeImpl.getChildren();
                        while (iterator.hasNext()) {
                            object5 = (PolicyNodeImpl)iterator.next();
                            if (!((PolicyNodeImpl)object5).match((ObjectIdentifier)object)) continue;
                            bl3 = true;
                            break;
                        }
                        if (bl3) continue;
                        object5 = new HashSet();
                        object5.add(object.toString());
                        PolicyNodeImpl policyNodeImpl3 = new PolicyNodeImpl((ObjectIdentifier)object, new HashSet(vector2), bl, (Set)object5, policyNodeImpl);
                        policyNodeImpl.addChild(policyNodeImpl3);
                        policyTree.addNode(policyNodeImpl3);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        object4 = null;
        int n5 = this.numberOfCertsInCertPath - this.currentCertIndex - 1;
        while (n5 > 0) {
            object4 = policyTree.getNodes(n5);
            int n6 = ((ArrayList)object4).size();
            n = 0;
            while (n < n6) {
                policyNodeImpl = (PolicyNodeImpl)((ArrayList)object4).get(n);
                object2 = policyNodeImpl.getChildren();
                if (!object2.hasNext()) {
                    object = (PolicyNodeImpl)((PolicyNodeImpl)((ArrayList)object4).get(n)).getParent();
                    if (object != null) {
                        ((PolicyNodeImpl)object).removeChild(policyNodeImpl);
                        policyTree.remove(policyNodeImpl);
                        --n;
                        --n6;
                    } else {
                        throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
                    }
                }
                ++n;
            }
            --n5;
        }
        if (policyTree.getNodes(1) == null) {
            policyTree.setValid(false);
        }
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("The direction of forward is not supported.", null, this.certPath, this.currentCertIndex);
        }
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2.5.29.32");
        return hashSet;
    }

    public Object clone() {
        return super.clone();
    }

    public PolicyTree getPolicyTree() {
        return this.policyTree;
    }

    private void checkPolicyMappings(X509Certificate x509Certificate, PolicyMappingsExtension policyMappingsExtension, PolicyTree policyTree) throws CertPathValidatorException {
        Vector vector = null;
        try {
            vector = (Vector)policyMappingsExtension.get("map");
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("An internal error has occurred.", (Throwable)iOException, this.certPath, this.currentCertIndex);
        }
        int n = 0;
        while (n < vector.size()) {
            block25: {
                Object object;
                Iterator iterator;
                Object object2;
                int n2;
                int n3;
                ArrayList arrayList;
                CertificatePolicyMap certificatePolicyMap = (CertificatePolicyMap)vector.get(n);
                ObjectIdentifier objectIdentifier = certificatePolicyMap.getIssuerIdentifier().getIdentifier();
                ObjectIdentifier objectIdentifier2 = certificatePolicyMap.getSubjectIdentifier().getIdentifier();
                if (objectIdentifier.equals(anyPolicy_OID) || objectIdentifier2.equals(anyPolicy_OID)) {
                    throw new CertPathValidatorException("Error in policy mapping extension", null, this.certPath, this.currentCertIndex);
                }
                if (this.policy_mapping > 0) {
                    Object object3;
                    arrayList = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex);
                    n3 = 0;
                    n2 = 0;
                    while (n2 < arrayList.size()) {
                        PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)arrayList.get(n2);
                        if (policyNodeImpl.getValidPolicy().equals(objectIdentifier.toString())) {
                            n3 = 1;
                            object3 = new HashSet<String>();
                            ((HashSet)object3).add(objectIdentifier2.toString());
                            policyNodeImpl.setExpectedPolicySet((Set)object3);
                        }
                        ++n2;
                    }
                    if (n3 == 0) {
                        arrayList = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex - 1);
                        int n4 = 0;
                        while (n4 < arrayList.size()) {
                            object3 = (PolicyNodeImpl)arrayList.get(n4);
                            if (((PolicyNodeImpl)object3).getValidPolicy().equals(anyPolicy_OID)) {
                                object2 = new Vector();
                                iterator = (CertificatePoliciesExtension)CertPathUtil.getPolicyInformation(x509Certificate, (Collection)object2, this.policyQualifiersRejected);
                                object = null;
                                try {
                                    object = (Vector)iterator.get("cert_policies");
                                }
                                catch (IOException iOException) {
                                    throw new CertPathValidatorException("An internal error has occurred.", (Throwable)iOException, this.certPath, this.currentCertIndex);
                                }
                                int n5 = 0;
                                while (n5 < ((Vector)object).size()) {
                                    block24: {
                                        PolicyInformation policyInformation = (PolicyInformation)((Vector)object).get(n5);
                                        try {
                                            if (!policyInformation.getPolicyIdentifier().equals(anyPolicy_OID)) break block24;
                                            HashSet<String> hashSet = new HashSet<String>();
                                            hashSet.add(certificatePolicyMap.getSubjectIdentifier().getIdentifier().toString());
                                            PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(objectIdentifier, new HashSet(policyInformation.getPolicyQualifiers()), policyMappingsExtension.isCritical(), hashSet, (PolicyNode)object3);
                                            ((PolicyNodeImpl)object3).addChild(policyNodeImpl);
                                            policyTree.addNode(policyNodeImpl);
                                            break block25;
                                        }
                                        catch (IOException iOException) {
                                            throw new CertPathValidatorException("An internal error has occured.", (Throwable)iOException, this.certPath, this.currentCertIndex);
                                        }
                                    }
                                    ++n5;
                                }
                                break;
                            }
                            ++n4;
                        }
                    }
                } else if (this.policy_mapping == 0) {
                    arrayList = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex);
                    n3 = 0;
                    while (n3 < arrayList.size()) {
                        PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)arrayList.get(n3);
                        if (policyNodeImpl.getValidPolicy().equals(objectIdentifier.toString())) {
                            ((PolicyNodeImpl)policyNodeImpl.getParent()).removeChild(policyNodeImpl);
                            policyTree.remove(policyNodeImpl);
                        }
                        ++n3;
                    }
                    n2 = this.numberOfCertsInCertPath - this.currentCertIndex - 1;
                    while (n2 > 0) {
                        arrayList = policyTree.getNodes(n2);
                        int n6 = arrayList.size();
                        int n7 = 0;
                        while (n7 < n6) {
                            object2 = (PolicyNodeImpl)arrayList.get(n7);
                            iterator = ((PolicyNodeImpl)object2).getChildren();
                            if (!iterator.hasNext()) {
                                object = (PolicyNodeImpl)((PolicyNodeImpl)arrayList.get(n7)).getParent();
                                if (object != null) {
                                    ((PolicyNodeImpl)object).removeChild((PolicyNode)object2);
                                    policyTree.remove((PolicyNode)object2);
                                    --n7;
                                    --n6;
                                } else {
                                    throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
                                }
                            }
                            ++n7;
                        }
                        --n2;
                    }
                }
            }
            ++n;
        }
    }

    private PolicyTree wrapUp(X509Certificate x509Certificate) throws CertPathValidatorException {
        int[] nArray;
        if (!this.certificate.getIssuerDN().equals(this.certificate.getSubjectDN()) && this.explicit_policy != 0) {
            --this.explicit_policy;
        }
        if ((nArray = CertPathUtil.getPolicyConstraints(this.certificate)) != null && nArray[0] == 0) {
            this.explicit_policy = 0;
        }
        if (this.policyTree.isValid()) {
            Object object;
            Iterator iterator;
            if (this.user_initial_policy_set.size() == 1 && this.user_initial_policy_set.contains(anyPolicy_OID.toString())) {
                return this.policyTree;
            }
            ArrayList<PolicyNodeImpl> arrayList = new ArrayList<PolicyNodeImpl>();
            PolicyNodeImpl policyNodeImpl = null;
            ArrayList arrayList2 = null;
            int n = this.policyTree.getDepth();
            while (n > 0) {
                arrayList2 = this.policyTree.getNodes(n);
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    policyNodeImpl = (PolicyNodeImpl)iterator.next();
                    if (!policyNodeImpl.getParent().getValidPolicy().equals(anyPolicy_OID.toString())) continue;
                    arrayList.add(policyNodeImpl);
                }
                --n;
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                policyNodeImpl = (PolicyNodeImpl)iterator.next();
                String string = policyNodeImpl.getValidPolicy();
                if (this.user_initial_policy_set.contains(string) || string.equals(anyPolicy_OID.toString())) continue;
                object = policyNodeImpl.getChildren();
                while (object.hasNext()) {
                    PolicyNodeImpl policyNodeImpl2 = (PolicyNodeImpl)object.next();
                    this.deleteChild(this.policyTree, policyNodeImpl2);
                }
                ((PolicyNodeImpl)policyNodeImpl.getParent()).removeChild(policyNodeImpl);
                this.policyTree.remove(policyNodeImpl);
            }
            int n2 = this.numberOfCertsInCertPath - 1;
            object = null;
            while (n2 > 0) {
                object = this.policyTree.getNodes(n2);
                if (object != null) {
                    int n3 = ((ArrayList)object).size();
                    int n4 = 0;
                    while (n4 < n3) {
                        PolicyNodeImpl policyNodeImpl3 = (PolicyNodeImpl)((ArrayList)object).get(n4);
                        Iterator iterator2 = policyNodeImpl3.getChildren();
                        if (!iterator2.hasNext()) {
                            PolicyNodeImpl policyNodeImpl4 = (PolicyNodeImpl)((PolicyNodeImpl)((ArrayList)object).get(n4)).getParent();
                            if (policyNodeImpl4 != null) {
                                policyNodeImpl4.removeChild(policyNodeImpl3);
                                this.policyTree.remove(policyNodeImpl3);
                                --n4;
                                --n3;
                            } else {
                                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
                            }
                        }
                        ++n4;
                    }
                }
                --n2;
            }
            if (this.policyTree.getNodes(1) == null) {
                this.policyTree.setValid(false);
            }
        }
        if (!this.policyTree.isValid() && this.explicit_policy <= 0) {
            throw new CertPathValidatorException("Fail to pass certification path processing", null, this.certPath, this.currentCertIndex);
        }
        return this.policyTree;
    }

    private void deleteChild(PolicyTree policyTree, PolicyNodeImpl policyNodeImpl) {
        Iterator iterator = policyNodeImpl.getChildren();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl2 = (PolicyNodeImpl)iterator.next();
            this.deleteChild(policyTree, policyNodeImpl2);
        }
        policyTree.remove(policyNodeImpl);
    }

    static {
        myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.CertificatePolicies").toString(), OIDMap.getOID((String)"x509.info.extensions.PolicyConstraints").toString(), OIDMap.getOID((String)"x509.info.extensions.InhibitAnyPolicy").toString()};
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier("2.5.29.32.0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        anyPolicy_OID = objectIdentifier;
    }
}

