/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class X509CertificatePair {
    private X509Certificate forward;
    private X509Certificate reverse;
    public static final int VALID_STATUS = 0;
    public static final int INVALID_STATUS = 1;
    public static final int UNDETERMINED_STATUS = 2;

    public X509CertificatePair(byte[] byArray) throws CertificateException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
        if (this.validate() == 1) {
            throw new CertificateException("Invalid certificate pair");
        }
    }

    public X509CertificatePair(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws CertificateException {
        if (x509Certificate == null && x509Certificate2 == null) {
            throw new CertificateException("At least one certificate can not be null");
        }
        if (x509Certificate != null) {
            this.forward = new X509CertImpl(x509Certificate.getEncoded());
        }
        if (x509Certificate2 != null) {
            this.reverse = new X509CertImpl(x509Certificate2.getEncoded());
        }
        if (this.validate() == 1) {
            throw new CertificateException("Invalid certificate pair");
        }
    }

    private void decode(byte[] byArray) throws IOException, CertificateException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length > 0) {
            int n = 0;
            while (n < derValueArray.length) {
                int n2 = derValueArray[n].getTag() & 0x1F;
                switch (n2) {
                    case 0: {
                        this.forward = new X509CertImpl(derValueArray[n].getData().getDerValue());
                        break;
                    }
                    case 1: {
                        this.reverse = new X509CertImpl(derValueArray[n].getData().getDerValue());
                        break;
                    }
                    default: {
                        throw new IOException("Invalid tag number");
                    }
                }
                ++n;
            }
        }
    }

    public byte[] encode() throws IOException {
        ArrayList<DerValue> arrayList = new ArrayList<DerValue>();
        DerValue derValue = null;
        if (this.forward != null) {
            try {
                derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.forward.getEncoded());
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            arrayList.add(derValue);
        }
        if (this.reverse != null) {
            try {
                derValue = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.reverse.getEncoded());
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            arrayList.add(derValue);
        }
        DerValue[] derValueArray = new DerValue[arrayList.size()];
        arrayList.toArray(derValueArray);
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CertificatePair: [\n forward certificate: ");
        if (this.forward != null) {
            stringBuffer.append(this.forward);
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("\n reverse certificate: ");
        if (this.reverse != null) {
            stringBuffer.append(this.reverse);
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    public X509Certificate getForward() {
        if (this.forward != null) {
            return this.forward;
        }
        return null;
    }

    public X509Certificate getReverse() {
        if (this.reverse != null) {
            return this.reverse;
        }
        return null;
    }

    int validate() {
        int n = 2;
        if (this.forward != null && this.reverse != null) {
            if (!this.forward.getIssuerDN().equals(this.reverse.getSubjectDN())) {
                return 1;
            }
            if (!this.forward.getSubjectDN().equals(this.reverse.getIssuerDN())) {
                return 1;
            }
            n = this.verifySig(this.forward.getPublicKey(), this.reverse);
            if (n == 0) {
                n = this.verifySig(this.reverse.getPublicKey(), this.forward);
            }
            return n;
        }
        return 0;
    }

    private int verifySig(PublicKey publicKey, X509Certificate x509Certificate) {
        try {
            x509Certificate.verify(publicKey);
            return 0;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                x509Certificate.verify(publicKey, "IBMJCE");
                return 0;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                return 2;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                return 2;
            }
            catch (Exception exception) {
                return 1;
            }
        }
        catch (Exception exception) {
            return 1;
        }
    }
}

