/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.cert.CertPath;
import javax.security.cert.CertPath$2;
import javax.security.cert.CertPathParameters;
import javax.security.cert.CertPathValidatorException;
import javax.security.cert.CertPathValidatorResult;
import javax.security.cert.CertStore;
import javax.security.cert.CertStoreParameters;
import javax.security.cert.CollectionCertStoreParameters;
import javax.security.cert.LDAPCertStoreParameters;
import javax.security.cert.PKIXCertPathChecker;
import javax.security.cert.PKIXCertPathChecker$I;
import javax.security.cert.PKIXCertPathValidatorResult;
import javax.security.cert.PKIXParameters;
import javax.security.cert.PolicyNode$I;
import javax.security.cert.TrustAnchor;
import javax.security.cert.X509CertSelector;

public class CertPathValidator {
    private java.security.cert.CertPathValidator val;

    private CertPathValidator() {
    }

    public static CertPathValidator getInstance(String string) throws NoSuchAlgorithmException {
        CertPathValidator certPathValidator = new CertPathValidator();
        certPathValidator.val = java.security.cert.CertPathValidator.getInstance(string);
        return certPathValidator;
    }

    public static CertPathValidator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        CertPathValidator certPathValidator = new CertPathValidator();
        certPathValidator.val = java.security.cert.CertPathValidator.getInstance(string, string2);
        return certPathValidator;
    }

    public static CertPathValidator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        CertPathValidator certPathValidator = new CertPathValidator();
        certPathValidator.val = java.security.cert.CertPathValidator.getInstance(string, provider);
        return certPathValidator;
    }

    public final Provider getProvider() {
        return this.val.getProvider();
    }

    public final String getAlgorithm() {
        return this.val.getAlgorithm();
    }

    public final CertPathValidatorResult validate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        CertPath$2 certPath$2 = new CertPath$2(certPath);
        PKIXParameters pKIXParameters = null;
        try {
            pKIXParameters = (PKIXParameters)certPathParameters;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidAlgorithmParameterException("not a PKIX parameters");
        }
        Set set = pKIXParameters.getTrustAnchors();
        Iterator iterator = set.iterator();
        java.security.cert.TrustAnchor trustAnchor = null;
        HashSet<java.security.cert.TrustAnchor> hashSet = new HashSet<java.security.cert.TrustAnchor>();
        while (iterator.hasNext()) {
            object4 = (TrustAnchor)iterator.next();
            serializable = ((TrustAnchor)object4).getTrustedCert();
            trustAnchor = serializable == null ? new java.security.cert.TrustAnchor(((TrustAnchor)object4).getCAName(), ((TrustAnchor)object4).getCAPublicKey(), ((TrustAnchor)object4).getNameConstraints()) : new java.security.cert.TrustAnchor((X509Certificate)serializable, ((TrustAnchor)object4).getNameConstraints());
            hashSet.add(trustAnchor);
        }
        object4 = pKIXParameters.getCertPathCheckers();
        serializable = null;
        if (object4 != null) {
            serializable = new ArrayList();
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (PKIXCertPathChecker)iterator.next();
                object2 = new PKIXCertPathChecker$I((PKIXCertPathChecker)object3);
                ((ArrayList)serializable).add(object2);
            }
        }
        object3 = pKIXParameters.getCertStores();
        object2 = null;
        java.security.cert.CertStoreParameters certStoreParameters = null;
        CertStoreParameters certStoreParameters2 = null;
        ArrayList<java.security.cert.CertStore> arrayList = null;
        if (object3 != null) {
            arrayList = new ArrayList<java.security.cert.CertStore>();
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (CertStore)iterator.next();
                certStoreParameters2 = ((CertStore)object).getCertStoreParameters();
                if (certStoreParameters2 instanceof LDAPCertStoreParameters) {
                    certStoreParameters = new java.security.cert.LDAPCertStoreParameters(((LDAPCertStoreParameters)certStoreParameters2).getServerName(), ((LDAPCertStoreParameters)certStoreParameters2).getPort());
                } else if (certStoreParameters2 instanceof CollectionCertStoreParameters) {
                    certStoreParameters = new java.security.cert.CollectionCertStoreParameters(((CollectionCertStoreParameters)certStoreParameters2).getCollection());
                } else {
                    throw new InvalidAlgorithmParameterException("Invalid algorithm parameters");
                }
                try {
                    object2 = java.security.cert.CertStore.getInstance(((CertStore)object).getType(), certStoreParameters);
                    arrayList.add((java.security.cert.CertStore)object2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }
        object = null;
        try {
            object = (X509CertSelector)pKIXParameters.getTargetCertConstraints();
        }
        catch (ClassCastException classCastException) {
            throw new CertPathValidatorException("Target constraints not X509CertSelector type");
        }
        java.security.cert.X509CertSelector x509CertSelector = null;
        if (object != null) {
            x509CertSelector = new java.security.cert.X509CertSelector();
            try {
                x509CertSelector.setAuthorityKeyIdentifier(((X509CertSelector)object).getAuthorityKeyIdentifier());
                x509CertSelector.setBasicConstraints(((X509CertSelector)object).getBasicConstraints());
                x509CertSelector.setCertificate(((X509CertSelector)object).getCertificate());
                x509CertSelector.setCertificateValid(((X509CertSelector)object).getCertificateValid());
                x509CertSelector.setExtendedKeyUsage(((X509CertSelector)object).getExtendedKeyUsage());
                x509CertSelector.setIssuer(((X509CertSelector)object).getIssuerAsBytes());
                x509CertSelector.setIssuer(((X509CertSelector)object).getIssuerAsString());
                x509CertSelector.setKeyUsage(((X509CertSelector)object).getKeyUsage());
                x509CertSelector.setMatchAllSubjectAltNames(((X509CertSelector)object).getMatchAllSubjectAltNames());
                x509CertSelector.setNameConstraints(((X509CertSelector)object).getNameConstraints());
                x509CertSelector.setPathToNames(((X509CertSelector)object).getPathToNames());
                x509CertSelector.setPolicy(((X509CertSelector)object).getPolicy());
                x509CertSelector.setPrivateKeyValid(((X509CertSelector)object).getPrivateKeyValid());
                x509CertSelector.setSerialNumber(((X509CertSelector)object).getSerialNumber());
                x509CertSelector.setSubject(((X509CertSelector)object).getSubjectAsString());
                x509CertSelector.setSubjectAlternativeNames(((X509CertSelector)object).getSubjectAlternativeNames());
                x509CertSelector.setSubjectKeyIdentifier(((X509CertSelector)object).getSubjectKeyIdentifier());
                x509CertSelector.setSubjectPublicKey(((X509CertSelector)object).getSubjectPublicKey());
                x509CertSelector.setSubjectPublicKeyAlgID(((X509CertSelector)object).getSubjectPublicKeyAlgID());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        java.security.cert.PKIXParameters pKIXParameters2 = new java.security.cert.PKIXParameters(hashSet);
        pKIXParameters2.setAnyPolicyInhibited(pKIXParameters.isAnyPolicyInhibited());
        if (serializable != null) {
            pKIXParameters2.setCertPathCheckers((List<java.security.cert.PKIXCertPathChecker>)((Object)serializable));
        }
        if (arrayList != null) {
            pKIXParameters2.setCertStores(arrayList);
        }
        pKIXParameters2.setDate(pKIXParameters.getDate());
        pKIXParameters2.setExplicitPolicyRequired(pKIXParameters.isExplicitPolicyRequired());
        pKIXParameters2.setInitialPolicies(pKIXParameters.getInitialPolicies());
        pKIXParameters2.setPolicyMappingInhibited(pKIXParameters.isPolicyMappingInhibited());
        pKIXParameters2.setPolicyQualifiersRejected(pKIXParameters.getPolicyQualifiersRejected());
        pKIXParameters2.setRevocationEnabled(pKIXParameters.isRevocationEnabled());
        pKIXParameters2.setSigProvider(pKIXParameters.getSigProvider());
        pKIXParameters2.setTargetCertConstraints(x509CertSelector);
        pKIXParameters2.setTrustAnchors(hashSet);
        java.security.cert.PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
        try {
            pKIXCertPathValidatorResult = (java.security.cert.PKIXCertPathValidatorResult)this.val.validate(certPath$2, pKIXParameters2);
        }
        catch (java.security.cert.CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException(certPathValidatorException.getMessage());
        }
        PolicyNode$I policyNode$I = new PolicyNode$I(pKIXCertPathValidatorResult.getPolicyTree());
        TrustAnchor trustAnchor2 = new TrustAnchor(pKIXCertPathValidatorResult.getTrustAnchor());
        return new PKIXCertPathValidatorResult(trustAnchor2, policyNode$I, pKIXCertPathValidatorResult.getPublicKey());
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("certpathvalidator.type");
            }
        });
        if (string == null) {
            string = "PKIX";
        }
        return string;
    }
}

