/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Set;
import javax.security.cert.CertSelector;
import javax.security.cert.PKIXParameters;

public class PKIXBuilderParameters
extends PKIXParameters {
    private int maxPathLength;

    public PKIXBuilderParameters(Set set, CertSelector certSelector) throws ClassCastException, InvalidAlgorithmParameterException {
        super(set);
        this.initialize(certSelector);
    }

    public PKIXBuilderParameters(KeyStore keyStore, CertSelector certSelector) throws KeyStoreException, InvalidAlgorithmParameterException {
        super(keyStore);
        this.initialize(certSelector);
    }

    private void initialize(CertSelector certSelector) {
        this.setTargetCertConstraints(certSelector);
        try {
            this.setMaxPathLength(5);
        }
        catch (InvalidParameterException invalidParameterException) {}
    }

    public void setMaxPathLength(int n) throws InvalidParameterException {
        if (n < -1) {
            throw new InvalidParameterException();
        }
        this.maxPathLength = n;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public String toString() {
        return super.toString() + "\n" + "Maximum Path Length:\t" + this.maxPathLength;
    }
}

