/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workspace.query.impl;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jdbc.CMPConnectorFactory;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.websphere.models.config.multibroker.MultibrokerDomain;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import com.ibm.ws.workspace.query.WorkSpaceQueryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class WorkSpaceQueryUtilImpl
implements WorkSpaceQueryUtil {
    public boolean isStandAloneCell(RepositoryContext repositoryContext) throws WorkSpaceException {
        Cell cell = (Cell)this.getRefObjects(repositoryContext, "cell.xml", "Cell", false).iterator().next();
        return cell.getCellType().getValue() == 0;
    }

    public Collection getClusterNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getClusterContextType();
        return this.getNames(repositoryContext, repositoryContextType);
    }

    public Collection getNodeNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getNodeContextType();
        return this.getNames(repositoryContext, repositoryContextType);
    }

    public Collection getApplicationNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getApplicationContextType();
        return this.getNames(repositoryContext, repositoryContextType);
    }

    public Collection getServerTypes(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getServerEntries(repositoryContext).iterator();
        while (iterator.hasNext()) {
            String string = ((ServerEntry)iterator.next()).getServerType();
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Collection getServerEntries(RepositoryContext repositoryContext) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getNodeContextType();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = repositoryContext.findContext(repositoryContextType).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getServerEntriesFromNode((RepositoryContext)iterator.next()));
        }
        return arrayList;
    }

    public Collection getServerEntriesFromNode(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getRefObjects(repositoryContext, "serverindex.xml", "ServerIndex", false).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((ServerIndex)iterator.next()).getServerEntries());
        }
        return arrayList;
    }

    private Resource load(RepositoryContext repositoryContext, String string) {
        return repositoryContext.getResourceSet().getResource(URI.createURI(string), true);
    }

    private Collection getServerNames(Collection collection, String string) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2;
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (string.equals("SERVER_TYPE_ALL") && !arrayList.contains(serverEntry.getServerName())) {
                arrayList.add(serverEntry.getServerName());
            }
            if ((string2 = serverEntry.getServerType()) == null || !string2.equals(string) || arrayList.contains(serverEntry.getServerName())) continue;
            arrayList.add(serverEntry.getServerName());
        }
        return arrayList;
    }

    public Collection getServerContexts(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        if (repositoryContext.getType().getName().equals("nodes")) {
            return this.getServerContextsFromNode(repositoryContext, string);
        }
        RepositoryContextType repositoryContextType = this.getNodeContextType();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = repositoryContext.findContext(repositoryContextType).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getServerContextsFromNode((RepositoryContext)iterator.next(), string));
        }
        return arrayList;
    }

    private Collection getServerContextsFromNode(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        ArrayList<RepositoryContext> arrayList = new ArrayList<RepositoryContext>();
        Iterator iterator = this.getServerNames(this.getServerEntriesFromNode(repositoryContext), string).iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext2 = repositoryContext.findContext("servers/" + (String)iterator.next());
            if (repositoryContext2 == null) continue;
            arrayList.add(repositoryContext2);
        }
        return arrayList;
    }

    private RepositoryContextType getClusterContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("clusters");
    }

    private RepositoryContextType getServerContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers");
    }

    private RepositoryContextType getNodeContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
    }

    private RepositoryContextType getApplicationContextType() {
        return RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("applications");
    }

    private Collection getNames(RepositoryContext repositoryContext, RepositoryContextType repositoryContextType) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = repositoryContext.findContext(repositoryContextType).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((RepositoryContext)iterator.next()).getName());
        }
        return arrayList;
    }

    public Collection getApplServerContexts(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = this.getClusterContextType();
        ArrayList<RepositoryContext> arrayList = new ArrayList<RepositoryContext>();
        RepositoryContext repositoryContext2 = null;
        RepositoryContext repositoryContext3 = null;
        ClusterMember clusterMember = null;
        Iterator iterator = repositoryContext.findContext(repositoryContextType).iterator();
        while (iterator.hasNext()) {
            repositoryContext2 = (RepositoryContext)iterator.next();
            if (!repositoryContext2.getName().equals(string)) continue;
            Iterator iterator2 = this.getRefObjects(repositoryContext2, "cluster.xml", "ServerCluster", false).iterator();
            while (iterator2.hasNext()) {
                Iterator iterator3 = ((ServerCluster)iterator2.next()).getMembers().iterator();
                while (iterator3.hasNext()) {
                    clusterMember = (ClusterMember)iterator3.next();
                    repositoryContext3 = this.getServerContext(repositoryContext, clusterMember.getNodeName(), clusterMember.getMemberName());
                    if (repositoryContext3 == null) continue;
                    arrayList.add(repositoryContext3);
                }
            }
            break block0;
        }
        return arrayList;
    }

    private RepositoryContext getServerContext(RepositoryContext repositoryContext, String string, String string2) throws WorkSpaceException {
        StringBuffer stringBuffer = new StringBuffer(this.getNodeContextType().getName());
        stringBuffer.append('/');
        stringBuffer.append(string);
        stringBuffer.append('/');
        stringBuffer.append(this.getServerContextType().getName());
        stringBuffer.append('/');
        stringBuffer.append(string2);
        return repositoryContext.findContext(stringBuffer.toString());
    }

    public Collection getNoneClusteredApplServerContexts(RepositoryContext repositoryContext) throws WorkSpaceException {
        Collection collection = this.getServerContexts(repositoryContext, "APPLICATION_SERVER");
        Iterator iterator = this.getClusterNames(repositoryContext).iterator();
        while (iterator.hasNext()) {
            collection.removeAll(this.getApplServerContexts(repositoryContext, (String)iterator.next()));
        }
        return collection;
    }

    public Collection getResourceJNDINames(RepositoryContext repositoryContext, String string) {
        return this.getResourceJNDINames(this.getResourceFactory(repositoryContext, string));
    }

    private Collection getResourceFactory(RepositoryContext repositoryContext, String string) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", string, true).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((J2EEResourceProvider)iterator.next()).getFactories());
        }
        return arrayList;
    }

    private Collection getResourceJNDINames(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = ((J2EEResourceFactory)iterator.next()).getJndiName();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Collection get40ResourceJNDINames(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            J2EEResourceFactory j2EEResourceFactory = (J2EEResourceFactory)iterator.next();
            if (!(j2EEResourceFactory instanceof WAS40DataSource) || arrayList.contains(string = j2EEResourceFactory.getJndiName())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Collection getResourceMofTypes(RepositoryContext repositoryContext) {
        return this.getRefObjectMofTypes(repositoryContext, "resources.xml", true);
    }

    public Collection getCMPResourceJNDINames(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.getResourceJNDINames(this.getCMPConnectorFactories(repositoryContext));
    }

    public Collection get40CMPResourceJNDINames(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.get40ResourceJNDINames(this.getResourceFactory(repositoryContext, "JDBCProvider"));
    }

    public Collection get50CMPResourceJNDINames(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.getResourceJNDINames(this.getCMPConnectorFactories(repositoryContext));
    }

    public Collection getCMPConnectorFactories(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getCMPResourceAdapters(repositoryContext).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((J2CResourceAdapter)iterator.next()).getFactories());
        }
        return arrayList;
    }

    public boolean cmpResourceAdapterExists(RepositoryContext repositoryContext) throws WorkSpaceException {
        return this.getCMPResourceAdapters(repositoryContext).size() > 0;
    }

    public Collection getMultiBrokerDomainNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "multibroker.xml", "MultibrokerDomain", false).iterator();
        while (iterator.hasNext()) {
            MultibrokerDomain multibrokerDomain = (MultibrokerDomain)iterator.next();
            arrayList.add(multibrokerDomain.getName());
        }
        return arrayList;
    }

    public EList getMultiBrokerEntries(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        Iterator iterator = this.getRefObjects(repositoryContext, "multibroker.xml", "MultibrokerDomain", false).iterator();
        while (iterator.hasNext()) {
            MultibrokerDomain multibrokerDomain = (MultibrokerDomain)iterator.next();
            if (!multibrokerDomain.getName().equals(string)) continue;
            return multibrokerDomain.getEntries();
        }
        return null;
    }

    public Collection getWebContainers(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getServerRefObjects(repositoryContext, true).iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            Iterator iterator2 = server.getComponents().iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!(e instanceof ApplicationServer)) continue;
                Iterator iterator3 = ((ApplicationServer)e).getComponents().iterator();
                while (iterator3.hasNext()) {
                    Object e2 = iterator3.next();
                    if (!(e2 instanceof WebContainer)) continue;
                    arrayList.add(e2);
                }
            }
        }
        return arrayList;
    }

    public boolean isFIPSEnabled(RepositoryContext repositoryContext) throws WorkSpaceException {
        String string = "";
        String string2 = "";
        Property property = null;
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getProperties().iterator();
            while (iterator2.hasNext()) {
                property = (Property)iterator2.next();
                string = property.getName();
                if (!string.equals("com.ibm.security.useFIPS") || !(string2 = property.getValue()).equalsIgnoreCase("true")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSSLAliasFIPSApproved(RepositoryContext repositoryContext, String string) throws WorkSpaceException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        SSLConfig sSLConfig = null;
        Property property = null;
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getRepertoire().iterator();
            while (iterator2.hasNext()) {
                sSLConfig = (SSLConfig)iterator2.next();
                string2 = sSLConfig.getAlias();
                if (!string2.equals(string) || sSLConfig.getSetting() == null || sSLConfig.getSetting().getProperties() == null) continue;
                Iterator iterator3 = sSLConfig.getSetting().getProperties().iterator();
                while (iterator3.hasNext()) {
                    property = (Property)iterator3.next();
                    string3 = property.getName();
                    if (!string3.equals("com.ibm.ssl.contextProvider") || !(string4 = property.getValue()).equals("IBMJSSEFIPS")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getDefaultJCEProvider(RepositoryContext repositoryContext) throws WorkSpaceException {
        String string = "IBMJCE";
        if (this.isFIPSEnabled(repositoryContext)) {
            string = "IBMJCEFIPS";
        }
        return string;
    }

    public Collection getSSLAlias(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getRepertoire().iterator();
            while (iterator2.hasNext()) {
                String string = ((SSLConfig)iterator2.next()).getAlias();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Collection getAuthAlias(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getAuthDataEntries().iterator();
            while (iterator2.hasNext()) {
                String string = ((JAASAuthData)iterator2.next()).getAlias();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Collection getMappingConfigAlias(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "security.xml", "Security", true).iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Security)iterator.next()).getApplicationLoginConfig().getEntries().iterator();
            while (iterator2.hasNext()) {
                String string = ((JAASConfigurationEntry)iterator2.next()).getAlias();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Collection getLibraryNames(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getRefObjects(repositoryContext, "libraries.xml", "Library", true).iterator();
        while (iterator.hasNext()) {
            String string = ((Library)iterator.next()).getName();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private Collection getServerRefObjects(RepositoryContext repositoryContext, boolean bl) throws WorkSpaceException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getRefObjects(repositoryContext, "server.xml", "Server", false));
        if (bl) {
            Iterator iterator = repositoryContext.findContext(this.getServerContextType()).iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(this.getServerRefObjects((RepositoryContext)iterator.next(), false));
            }
        }
        return arrayList;
    }

    private Collection getCMPDatasource(RepositoryContext repositoryContext) throws WorkSpaceException {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        Iterator iterator = this.getCMPConnectorFactories(repositoryContext).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((CMPConnectorFactory)iterator.next()).getCmpDatasource());
        }
        return arrayList;
    }

    private Collection getCMPResourceAdapters(RepositoryContext repositoryContext) {
        ArrayList<J2CResourceAdapter> arrayList = new ArrayList<J2CResourceAdapter>();
        Iterator iterator = this.getRefObjects(repositoryContext, "resources.xml", "J2CResourceAdapter", true).iterator();
        while (iterator.hasNext()) {
            J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)iterator.next();
            String string = ((XMLResource)j2CResourceAdapter.eResource()).getID((EObject)j2CResourceAdapter);
            if (!string.equals("builtin_rra")) continue;
            arrayList.add(j2CResourceAdapter);
        }
        return arrayList;
    }

    public Collection getRefObjects(RepositoryContext repositoryContext, String string, String string2, boolean bl) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        Resource resource = this.load(repositoryContext, string);
        if (resource != null) {
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                String string3 = eObject.eClass().getName();
                if (!string3.equals(string2)) continue;
                arrayList.add(eObject);
            }
            if (bl && repositoryContext.getParent() != null) {
                arrayList.addAll(this.getRefObjects(repositoryContext.getParent(), string, string2, bl));
            }
        }
        return arrayList;
    }

    private Collection getRefObjectMofTypes(RepositoryContext repositoryContext, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Resource resource = this.load(repositoryContext, string);
        if (resource != null) {
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                String string2 = ((EObject)iterator.next()).eClass().getName();
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            if (bl && repositoryContext.getParent() != null) {
                arrayList.addAll(this.getRefObjectMofTypes(repositoryContext.getParent(), string, bl));
            }
        }
        return arrayList;
    }

    private RefObjectHelper getRefObjectHelper() {
        return RefObjectHelperFactory.getRefObjectHelper();
    }
}

