/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import com.ibm.ws.install.launchpad.ImageWindow;
import com.ibm.ws.install.launchpad.JAntiAliasLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.BreakIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HyperLabel
extends JLabel {
    public static Color NORMALTEXT = Color.white;
    public static Color HIGHLIGHT = Color.yellow;
    public static Color CLICKTEXT = Color.red;
    public static int WIDTH = 200;
    public static int HEIGHT = 30;
    public static Font LABELFONT = Font.decode("Helvetica-BOLD-14");
    public static int HINTNUDGE = 0;
    private String text = null;
    private FontMetrics fm = null;
    private boolean paintClick = false;
    private Runnable runnable = null;
    private JLabel arrowPanel = new JLabel();
    private JPanel hintArea = new JPanel();
    private String rollOverText = "";
    private MouseListener ml = null;

    public HyperLabel(String string, Runnable runnable) {
        super(string, 4);
        this.runnable = runnable;
        this.text = string;
        this.setSize(WIDTH, HEIGHT);
        this.setFont(LABELFONT);
        this.setForeground(NORMALTEXT);
        this.arrowPanel.setIcon(new ImageIcon(ImageWindow.ARROW));
        this.hintArea.setForeground(ImageWindow.HINTCOLOR);
        this.hintArea.setFont(ImageWindow.HINTFONT);
        this.ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (mouseEvent != null) {
                    Container container = HyperLabel.this.getParent();
                    while (!(container instanceof ImageWindow)) {
                        container = container.getParent();
                    }
                    ((ImageWindow)container).stopKeyboardInput();
                }
                HyperLabel.this.setCursor(new Cursor(12));
                HyperLabel.this.setForeground(HIGHLIGHT);
                HyperLabel.this.arrowPanel.setVisible(true);
                HyperLabel.this.hintArea.setVisible(true);
                HyperLabel.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                HyperLabel.this.setCursor(new Cursor(0));
                HyperLabel.this.setForeground(NORMALTEXT);
                HyperLabel.this.arrowPanel.setVisible(false);
                HyperLabel.this.hintArea.setVisible(false);
                HyperLabel.this.repaint();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                HyperLabel.this.runnable.run();
                HyperLabel.this.getParent().repaint();
                HyperLabel.this.repaint();
            }

            public void mousePressed(MouseEvent mouseEvent) {
                HyperLabel.this.setForeground(CLICKTEXT);
                HyperLabel.this.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                HyperLabel.this.setForeground(NORMALTEXT);
                HyperLabel.this.repaint();
            }
        };
        this.addMouseListener(this.ml);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).addRenderingHints(renderingHints);
        }
        super.paint(graphics);
    }

    public void refresh() {
        this.ml.mouseExited(null);
    }

    public void turnOnMouseListener() {
        this.ml.mouseExited(null);
    }

    public void turnOffMouseListener() {
        this.ml.mouseEntered(null);
    }

    public void doMouseClicked() {
        this.ml.mouseClicked(null);
    }

    public JLabel getArrowPanel() {
        Point point = this.getArrowPoint();
        this.arrowPanel.setLocation(point);
        return this.arrowPanel;
    }

    public JPanel getHintArea() {
        Point point = new Point(this.getLocation().x + this.getSize().width + 20, this.getLocation().y);
        this.hintArea.setLocation(point.x + ImageWindow.HINTOFFSET, point.y + HINTNUDGE);
        this.hintArea.setSize(ImageWindow.lengthBoundary, 150);
        this.hintArea.setBackground(new Color(0, 0, 0, 0));
        return this.hintArea;
    }

    public Point getArrowPoint() {
        Point point = new Point(this.getLocation().x + this.getSize().width + 5, this.getLocation().y - 35);
        return point;
    }

    public void setRollOverText(String string) {
        this.rollOverText = string;
        JLabel[] jLabelArray = this.breakupText(string, ImageWindow.lengthBoundary);
        this.hintArea.removeAll();
        JPanel jPanel = new JPanel();
        jPanel.setForeground(ImageWindow.HINTCOLOR);
        jPanel.setFont(ImageWindow.HINTFONT);
        jPanel.setLayout(new GridLayout(jLabelArray.length, 1, 0, ImageWindow.LINESPACE));
        jPanel.setBackground(new Color(0, 0, 0, 0));
        int n = 0;
        while (n < jLabelArray.length) {
            jPanel.add(jLabelArray[n]);
            ++n;
        }
        this.hintArea.setLayout(new BorderLayout());
        this.hintArea.add((Component)jPanel, "North");
    }

    public void addNotify() {
        super.addNotify();
        JLabel[] jLabelArray = this.breakupText(this.rollOverText, ImageWindow.lengthBoundary);
        this.hintArea.removeAll();
        JPanel jPanel = new JPanel();
        jPanel.setForeground(ImageWindow.HINTCOLOR);
        jPanel.setFont(ImageWindow.HINTFONT);
        jPanel.setLayout(new GridLayout(jLabelArray.length, 1, 0, ImageWindow.LINESPACE));
        jPanel.setBackground(new Color(0, 0, 0, 0));
        int n = 0;
        while (n < jLabelArray.length) {
            jPanel.add(jLabelArray[n]);
            ++n;
        }
        this.hintArea.setLayout(new BorderLayout());
        this.hintArea.add((Component)jPanel, "North");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private JLabel[] breakupText(String var1_1, int var2_2) {
        var3_3 = "";
        var4_4 = new Vector<JLabel[]>();
        var5_5 = BreakIterator.getLineInstance();
        var5_5.setText(var1_1);
        var6_6 = var5_5.next();
        if (this.getGraphics() == null) {
            return new JLabel[0];
        }
        var7_7 = this.getGraphics().getFontMetrics();
        ** GOTO lbl23
        {
            var6_6 = var5_5.next();
            if (var6_6 == -1) ** GOTO lbl15
            do {
                if ((int)var7_7.getStringBounds(var1_1.substring(0, var6_6), this.getGraphics()).getWidth() < var2_2 / 2) continue block0;
lbl15:
                // 2 sources

                var8_8 /* !! */  = var1_1.substring(0, var5_5.current());
                var4_4.addElement(var8_8 /* !! */ );
                var3_3 = var3_3 + (String)var8_8 /* !! */  + "\n";
                if (var6_6 == -1) continue;
                var1_1 = var1_1.substring(var5_5.current());
                var5_5.setText(var1_1);
                var6_6 = var5_5.next();
lbl23:
                // 3 sources

            } while (var6_6 != -1);
        }
        var8_8 /* !! */  = new JAntiAliasLabel[var4_4.size()];
        var9_9 = 0;
        while (var9_9 < var4_4.size()) {
            var8_8 /* !! */ [var9_9] = new JAntiAliasLabel((String)var4_4.elementAt(var9_9));
            var8_8 /* !! */ [var9_9].setForeground(ImageWindow.HINTCOLOR);
            var8_8 /* !! */ [var9_9].setFont(ImageWindow.HINTFONT);
            ++var9_9;
        }
        return var8_8 /* !! */ ;
    }
}

