/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import com.ibm.ws.install.launchpad.HyperLabel;
import com.ibm.ws.install.launchpad.ShadowLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageWindow
extends JFrame {
    public static int width = 700;
    public static int height = 500;
    public static Color HINTCOLOR = new Color(134, 134, 234);
    public static Font HINTFONT = Font.decode("Helvetica-BOLDITALIC-12");
    public static int LINESPACE = 20;
    public static Image ICON = null;
    public static Image ARROW = null;
    public static Image BACKGROUND = null;
    public static String TITLE = "";
    public static int LABELSPACING = 30;
    public static int LABELSPACINGCONST = 40;
    public static int HINTOFFSET = 50;
    public static int labelstartx = 50;
    public static int labelstarty = 150;
    public static int lengthBoundary = 250;
    public static int SHADOWNUDGE_RIGHT = 2;
    public static int SHADOWNUDGE_DOWN = 2;
    private Hashtable labels = new Hashtable();
    private Vector labelOrder = new Vector();
    private Vector hLabels = new Vector();
    private Vector shadows = new Vector();
    private int relWidth = 0;
    private int relHeight = 0;
    private JLabel contentPanel = null;
    private int selectedLabelIndex = -1;
    private FocusAdapter focusAdapter = null;
    private HyperLabel tabSelectedLabel = null;

    public ImageWindow() {
        super(TITLE);
        this.setSize(width, height);
        this.getContentPane().setLayout(new GridLayout(1, 1, 0, 0));
        this.contentPanel = new JLabel();
        this.getContentPane().add(this.contentPanel);
        this.setDefaultCloseOperation(3);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    System.exit(0);
                }
            }
        };
        this.addKeyListener(keyAdapter);
        KeyAdapter keyAdapter2 = new KeyAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            public void keyPressed(KeyEvent keyEvent) {
                block8: {
                    block7: {
                        if (keyEvent.getKeyCode() == 225) break block7;
                        if (keyEvent.getKeyCode() != 40) break block8;
                    }
                    if (ImageWindow.this.tabSelectedLabel != null) {
                        ImageWindow.this.tabSelectedLabel.turnOnMouseListener();
                        ImageWindow.this.tabSelectedLabel = null;
                    }
                    ImageWindow.this.selectNextLabelDown();
                    return;
                }
                if (keyEvent.getKeyCode() != 224) {
                    if (keyEvent.getKeyCode() != 38) {
                        if (keyEvent.getKeyCode() != 10) return;
                        ImageWindow.this.doLabelClicked();
                        return;
                    }
                }
                if (ImageWindow.this.tabSelectedLabel != null) {
                    ImageWindow.this.tabSelectedLabel.turnOnMouseListener();
                    ImageWindow.this.tabSelectedLabel = null;
                }
                ImageWindow.this.selectNextLabelUp();
            }
        };
        this.addKeyListener(keyAdapter2);
        this.focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ImageWindow.this.stopKeyboardInput();
                    ImageWindow.this.selectedLabelIndex = -1;
                    HyperLabel hyperLabel = (HyperLabel)focusEvent.getComponent();
                    hyperLabel.turnOffMouseListener();
                    ImageWindow.this.tabSelectedLabel = hyperLabel;
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ImageWindow.this.stopKeyboardInput();
                    ImageWindow.this.selectedLabelIndex = -1;
                    ImageWindow.this.tabSelectedLabel = null;
                    HyperLabel hyperLabel = (HyperLabel)focusEvent.getComponent();
                    hyperLabel.turnOnMouseListener();
                }
            }
        };
        this.setResizable(false);
    }

    public void paint(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).addRenderingHints(renderingHints);
        }
        super.paint(graphics);
    }

    public void stopKeyboardInput() {
        if (this.selectedLabelIndex >= 0) {
            HyperLabel hyperLabel = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex);
            if (hyperLabel != null) {
                hyperLabel.turnOnMouseListener();
            }
        } else if (this.tabSelectedLabel != null) {
            this.tabSelectedLabel.turnOnMouseListener();
        }
        this.selectedLabelIndex = -1;
        this.tabSelectedLabel = null;
        this.refreshLabels();
    }

    private void selectNextLabelUp() {
        HyperLabel hyperLabel;
        this.refreshLabels();
        if (this.selectedLabelIndex >= 0 && (hyperLabel = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex)) != null) {
            hyperLabel.turnOnMouseListener();
        }
        this.selectedLabelIndex = this.selectedLabelIndex == -1 || this.selectedLabelIndex == 0 ? this.hLabels.size() - 1 : --this.selectedLabelIndex;
        hyperLabel = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex);
        if (hyperLabel != null) {
            hyperLabel.turnOffMouseListener();
        }
    }

    private void refreshLabels() {
        int n = 0;
        while (n < this.hLabels.size()) {
            HyperLabel hyperLabel = (HyperLabel)this.hLabels.elementAt(n);
            hyperLabel.refresh();
            ++n;
        }
    }

    private void selectNextLabelDown() {
        HyperLabel hyperLabel;
        this.refreshLabels();
        if (this.selectedLabelIndex >= 0 && (hyperLabel = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex)) != null) {
            hyperLabel.turnOnMouseListener();
        }
        this.selectedLabelIndex = this.selectedLabelIndex == -1 || this.selectedLabelIndex == this.hLabels.size() - 1 ? 0 : ++this.selectedLabelIndex;
        hyperLabel = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex);
        if (hyperLabel != null) {
            hyperLabel.turnOffMouseListener();
        }
    }

    private void doLabelClicked() {
        if (this.selectedLabelIndex >= 0) {
            HyperLabel hyperLabel = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex);
            if (hyperLabel != null) {
                hyperLabel.doMouseClicked();
                hyperLabel.turnOnMouseListener();
            }
        } else if (this.tabSelectedLabel != null) {
            this.tabSelectedLabel.doMouseClicked();
            this.tabSelectedLabel.turnOnMouseListener();
        }
        this.selectedLabelIndex = -1;
        this.tabSelectedLabel = null;
    }

    public void show() {
        this.setSize(width, height);
        this.setTitle(TITLE);
        this.setIconImage(ICON);
        this.contentPanel.setIcon(new ImageIcon(BACKGROUND));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - width / 2, dimension.height / 2 - height / 2);
        super.show();
        this.requestFocus();
    }

    public void addLabel(HyperLabel hyperLabel) {
        this.hLabels.addElement(hyperLabel);
        hyperLabel.addFocusListener(this.focusAdapter);
        ShadowLabel shadowLabel = new ShadowLabel(hyperLabel.getText());
        this.shadows.addElement(shadowLabel);
        int n = 0;
        while (n < this.hLabels.size()) {
            Component component = (Component)this.hLabels.elementAt(n);
            Component component2 = (Component)this.shadows.elementAt(n);
            if (n < 5) {
                component.setLocation(new Point(labelstartx, labelstarty + n * LABELSPACING));
                component2.setLocation(new Point(labelstartx + SHADOWNUDGE_RIGHT, labelstarty + n * LABELSPACING + SHADOWNUDGE_DOWN));
            } else {
                component.setLocation(new Point(labelstartx, labelstarty + LABELSPACINGCONST + n * LABELSPACING));
                component2.setLocation(new Point(labelstartx + SHADOWNUDGE_RIGHT, labelstarty + LABELSPACINGCONST + n * LABELSPACING + SHADOWNUDGE_DOWN));
            }
            component2.setSize(component.getSize());
            if (hyperLabel == component) {
                this.contentPanel.add(component);
                this.contentPanel.add(component2);
                JLabel jLabel = hyperLabel.getArrowPanel();
                jLabel.setSize(100, 100);
                this.contentPanel.add(jLabel);
                jLabel.setVisible(false);
                JPanel jPanel = hyperLabel.getHintArea();
                this.contentPanel.add(jPanel);
                jPanel.setVisible(false);
            }
            ++n;
        }
    }
}

