/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LaunchPadBrowserPane
extends JFrame
implements ActionListener,
HyperlinkListener {
    private JButton backButton = new JButton("<--");
    private JButton forwardButton = new JButton("-->");
    private JLabel locationLabel = new JLabel("");
    private JToolBar toolBar = new JToolBar();
    private JEditorPane jep = new JEditorPane();
    private int currentPosition = -1;
    private Vector history = new Vector(10);

    public LaunchPadBrowserPane() {
        super("");
        this.jep.setContentType("text/html");
        this.jep.setEditable(false);
        this.jep.addHyperlinkListener(this);
        this.locationLabel.setSize(550, this.locationLabel.getHeight());
        this.toolBar.add(this.backButton);
        this.toolBar.add(this.forwardButton);
        this.toolBar.addSeparator();
        this.toolBar.add(this.locationLabel);
        this.backButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)new JScrollPane(this.jep), "Center");
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.navigate(hyperlinkEvent.getURL().toString());
        }
    }

    public void show() {
        this.history = new Vector(10);
        this.currentPosition = -1;
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        super.show();
    }

    public void navigate(String string) {
        try {
            this.jep.setPage(string);
            this.setLocation(string);
            this.jep.repaint();
            this.history.addElement(string);
            this.forwardButton.setEnabled(false);
            ++this.currentPosition;
            if (this.currentPosition > 0) {
                this.backButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            this.showHtmlError(exception, string);
        }
    }

    private void setLocation(String string) {
        this.locationLabel.setText(string);
        this.locationLabel.repaint();
    }

    private void showHtmlError(Exception exception, String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        printWriter.println("<HTML><HEAD></HEAD><BODY>");
        printWriter.println("<p><a href=\"" + string + "\">" + string + "</a></p><br><hr>");
        printWriter.println("<PRE>");
        exception.printStackTrace(printWriter);
        printWriter.println("</PRE></BODY></HTML>");
        this.jep.setText(stringWriter.toString());
        this.jep.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            block6: {
                if (actionEvent.getSource() != this.backButton) break block6;
                try {
                    this.jep.setPage((String)this.history.elementAt(this.currentPosition - 1));
                    this.setLocation((String)this.history.elementAt(this.currentPosition - 1));
                    this.jep.repaint();
                    --this.currentPosition;
                    if (this.currentPosition == 0) {
                        this.backButton.setEnabled(false);
                    }
                    this.forwardButton.setEnabled(true);
                }
                catch (Exception exception) {
                    this.showHtmlError(exception, (String)this.history.elementAt(this.currentPosition - 1));
                }
                break block7;
            }
            if (actionEvent.getSource() != this.forwardButton) break block7;
            try {
                this.jep.setPage((String)this.history.elementAt(this.currentPosition + 1));
                this.setLocation((String)this.history.elementAt(this.currentPosition + 1));
                this.jep.repaint();
                ++this.currentPosition;
                if (this.currentPosition == this.history.size() - 1) {
                    this.forwardButton.setEnabled(false);
                }
                this.backButton.setEnabled(true);
            }
            catch (Exception exception) {
                this.showHtmlError(exception, (String)this.history.elementAt(this.currentPosition + 1));
            }
        }
    }
}

