/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardContextValve() {
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        if (!(request.getRequest() instanceof HttpServletRequest) || !(response.getResponse() instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String contextPath = hreq.getContextPath();
        String requestURI = hreq.getRequestURI();
        String relativeURI = requestURI.substring(contextPath.length()).toUpperCase();
        if (relativeURI.equals("/META-INF") || relativeURI.equals("/WEB-INF") || relativeURI.startsWith("/META-INF/") || relativeURI.startsWith("/WEB-INF/")) {
            this.notFound(requestURI, (HttpServletResponse)response.getResponse());
            return;
        }
        Context context = (Context)this.getContainer();
        Wrapper wrapper = null;
        try {
            wrapper = (Wrapper)context.map(request, true);
        }
        catch (IllegalArgumentException e) {
            this.badRequest(requestURI, (HttpServletResponse)response.getResponse());
            return;
        }
        if (wrapper == null) {
            this.notFound(requestURI, (HttpServletResponse)response.getResponse());
            return;
        }
        response.setContext(context);
        wrapper.invoke(request, response);
    }

    private void badRequest(String requestURI, HttpServletResponse response) {
        try {
            response.sendError(400, requestURI);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException e) {}
    }

    private void notFound(String requestURI, HttpServletResponse response) {
        try {
            response.sendError(404, requestURI);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException e) {}
    }
}

