/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.Mapper;
import org.apache.catalina.Request;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.StringManager;

public class StandardEngineMapper
implements Mapper {
    private StandardEngine engine = null;
    private String protocol = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public Container getContainer() {
        return this.engine;
    }

    public void setContainer(Container container) {
        if (!(container instanceof StandardEngine)) {
            throw new IllegalArgumentException(sm.getString("httpEngineMapper.container"));
        }
        this.engine = (StandardEngine)container;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Container map(Request request, boolean update) {
        Host host;
        int debug = this.engine.getDebug();
        String server = request.getRequest().getServerName();
        if (server == null) {
            server = this.engine.getDefaultHost();
            if (update) {
                request.setServerName(server);
            }
        }
        if (server == null) {
            return null;
        }
        server = server.toLowerCase();
        if (debug >= 1) {
            this.engine.log("Mapping server name '" + server + "'");
        }
        if (debug >= 2) {
            this.engine.log(" Trying a direct match");
        }
        if ((host = (Host)this.engine.findChild(server)) == null) {
            if (debug >= 2) {
                this.engine.log(" Trying an alias match");
            }
            Container[] children = this.engine.findChildren();
            int i = 0;
            while (i < children.length) {
                String[] aliases = ((Host)children[i]).findAliases();
                int j = 0;
                while (j < aliases.length) {
                    if (server.equals(aliases[j])) {
                        host = (Host)children[i];
                        break;
                    }
                    ++j;
                }
                if (host != null) break;
                ++i;
            }
        }
        if (host == null) {
            if (debug >= 2) {
                this.engine.log(" Trying the default host");
            }
            host = (Host)this.engine.findChild(this.engine.getDefaultHost());
        }
        return host;
    }
}

