/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

public class PKCS11Exception
extends RuntimeException {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HOST_MEMORY = 2;
    public static final int SLOT_ID_INVALID = 3;
    public static final int GENERAL_ERROR = 5;
    public static final int FUNCTION_FAILED = 6;
    public static final int ARGUMENTS_BAD = 7;
    public static final int NO_EVENT = 8;
    public static final int NEED_TO_CREATE_THREADS = 9;
    public static final int CANT_LOCK = 10;
    public static final int ATTRIBUTE_READ_ONLY = 16;
    public static final int ATTRIBUTE_SENSITIVE = 17;
    public static final int ATTRIBUTE_TYPE_INVALID = 18;
    public static final int ATTRIBUTE_VALUE_INVALID = 19;
    public static final int DATA_INVALID = 32;
    public static final int DATA_LEN_RANGE = 33;
    public static final int DEVICE_ERROR = 48;
    public static final int DEVICE_MEMORY = 49;
    public static final int DEVICE_REMOVED = 50;
    public static final int ENCRYPTED_DATA_INVALID = 64;
    public static final int ENCRYPTED_DATA_LEN_RANGE = 65;
    public static final int FUNCTION_CANCELED = 80;
    public static final int FUNCTION_NOT_PARALLEL = 81;
    public static final int FUNCTION_NOT_SUPPORTED = 84;
    public static final int KEY_HANDLE_INVALID = 96;
    public static final int KEY_SIZE_RANGE = 98;
    public static final int KEY_TYPE_INCONSISTENT = 99;
    public static final int KEY_NOT_NEEDED = 100;
    public static final int KEY_CHANGED = 101;
    public static final int KEY_NEEDED = 102;
    public static final int KEY_INDIGESTIBLE = 103;
    public static final int KEY_FUNCTION_NOT_PERMITTED = 104;
    public static final int KEY_NOT_WRAPPABLE = 105;
    public static final int KEY_UNEXTRACTABLE = 106;
    public static final int MECHANISM_INVALID = 112;
    public static final int MECHANISM_PARAM_INVALID = 113;
    public static final int OBJECT_HANDLE_INVALID = 130;
    public static final int OPERATION_ACTIVE = 144;
    public static final int OPERATION_NOT_INITIALIZED = 145;
    public static final int PIN_INCORRECT = 160;
    public static final int PIN_INVALID = 161;
    public static final int PIN_LEN_RANGE = 162;
    public static final int PIN_EXPIRED = 163;
    public static final int PIN_LOCKED = 164;
    public static final int SESSION_CLOSED = 176;
    public static final int SESSION_COUNT = 177;
    public static final int SESSION_HANDLE_INVALID = 179;
    public static final int SESSION_PARALLEL_NOT_SUPPORTED = 180;
    public static final int SESSION_READ_ONLY = 181;
    public static final int SESSION_EXISTS = 182;
    public static final int SESSION_READ_ONLY_EXISTS = 183;
    public static final int SESSION_READ_WRITE_SO_EXISTS = 184;
    public static final int SIGNATURE_INVALID = 192;
    public static final int SIGNATURE_LEN_RANGE = 193;
    public static final int TEMPLATE_INCOMPLETE = 208;
    public static final int TEMPLATE_INCONSISTENT = 209;
    public static final int TOKEN_NOT_PRESENT = 224;
    public static final int TOKEN_NOT_RECOGNIZED = 225;
    public static final int TOKEN_WRITE_PROTECTED = 226;
    public static final int UNWRAPPING_KEY_HANDLE_INVALID = 240;
    public static final int UNWRAPPING_KEY_SIZE_RANGE = 241;
    public static final int UNWRAPPING_KEY_TYPE_INCONSISTENT = 242;
    public static final int USER_ALREADY_LOGGED_IN = 256;
    public static final int USER_NOT_LOGGED_IN = 257;
    public static final int USER_PIN_NOT_INITIALIZED = 258;
    public static final int USER_TYPE_INVALID = 259;
    public static final int USER_ANOTHER_ALREADY_LOGGED_IN = 260;
    public static final int USER_TOO_MANY_TYPES = 261;
    public static final int WRAPPED_KEY_INVALID = 272;
    public static final int WRAPPED_KEY_LEN_RANGE = 274;
    public static final int WRAPPING_KEY_HANDLE_INVALID = 275;
    public static final int WRAPPING_KEY_SIZE_RANGE = 276;
    public static final int WRAPPING_KEY_TYPE_INCONSISTENT = 277;
    public static final int RANDOM_SEED_NOT_SUPPORTED = 288;
    public static final int RANDOM_NO_RNG = 289;
    public static final int DOMAIN_PARAMS_INVALID = 304;
    public static final int BUFFER_TOO_SMALL = 336;
    public static final int SAVED_STATE_INVALID = 352;
    public static final int INFORMATION_SENSITIVE = 368;
    public static final int STATE_UNSAVEABLE = 384;
    public static final int CRYPTOKI_NOT_INITIALIZED = 400;
    public static final int CRYPTOKI_ALREADY_INITIALIZED = 401;
    public static final int MUTEX_BAD = 416;
    public static final int MUTEX_NOT_LOCKED = 417;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    private static final int[] CKR_types = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 16, 17, 18, 19, 32, 33, 48, 49, 50, 64, 65, 80, 81, 84, 96, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 130, 144, 145, 160, 161, 162, 163, 164, 176, 177, 179, 180, 181, 182, 183, 184, 192, 193, 208, 209, 224, 225, 226, 240, 241, 242, 256, 257, 258, 259, 260, 261, 272, 274, 275, 276, 277, 288, 289, 304, 336, 352, 368, 384, 400, 401, 416, 417};
    static final String[] CKR_names = new String[]{PKCS11Exception.a("K\u0010hT'd\nh\u0017;l\u0016&T<`\u0015jR'h\u0001&D&n\u0006cD k\u0010j[*"), PKCS11Exception.a("K\u0010hT'd\nh\u0017 e\ns[7-\u0007c\u00170l\u000beR?h\u0001"), PKCS11Exception.a("C\nr\u00176c\nsP;-\bcZ<\u007f\u001c&X=-\riD'"), PKCS11Exception.a("^\tiCsD!&^ -\fhA2a\fb"), PKCS11Exception.a("X\u000btR0b\u0013cE2o\tc\u00176\u007f\u0017iE"), PKCS11Exception.a("Y\rc\u0017!h\u0014sR y\u0000b\u00175x\u000beC:b\u000b&T<x\tb\u0017=b\u0011&U6-\u0015cE5b\u0017kR7"), PKCS11Exception.a("^\u0010vG?d\u0000b\u00172\u007f\u0002sZ6c\u0011u\u0017=b\u0011&V#}\u0017iG!d\u0004rR"), PKCS11Exception.a("C\n&Y6zEcA6c\u0011u\u00172{\u0004o[2o\tc"), PKCS11Exception.a("C\u0004r^%hEr_!h\u0004b\u0017 x\u0015vX!yEtR\"x\ftR7"), PKCS11Exception.a("A\ne\\:c\u0002&Y<yEgA2d\tgU?h"), PKCS11Exception.a("L\u0011rE:o\u0010rRsd\u0016&E6l\u0001+X=a\u001c"), PKCS11Exception.a("L\u0011rE:o\u0010rRsd\u0016&D6c\u0016oC:{\u0000&V=iEeV=c\nr\u00171hEtR%h\u0004jR7"), PKCS11Exception.a("L\u0011rE:o\u0010rRsy\u001cvRsd\u0016&^={\u0004j^7"), PKCS11Exception.a("L\u0011rE:o\u0010rRs{\u0004jB6-\fu\u0017:c\u0013g[:i"), PKCS11Exception.a("I\u0004rVsd\u0016&^={\u0004j^7"), PKCS11Exception.a("D\u000bpV?d\u0001&S2y\u0004&[6c\u0002r_"), PKCS11Exception.a("I\u0000p^0hEcE!b\u0017"), PKCS11Exception.a("C\nr\u00176c\nsP;-\bcZ<\u007f\u001c&X=-\u0001cA:n\u0000"), PKCS11Exception.a("I\u0000p^0hEnV -\u0007cR=-\u0017cZ<{\u0000b"), PKCS11Exception.a("H\u000beE*}\u0011cSsi\u0004rVsd\u0016&^={\u0004j^7"), PKCS11Exception.a("H\u000beE*}\u0011cSsi\u0004rVsa\u0000hP'eEoDsb\u0010r\u0017<kEtV=j\u0000"), PKCS11Exception.a("K\u0010hT'd\nh\u0017;l\u0016&U6h\u000b&T2c\u0006c[6i"), PKCS11Exception.a("C\n&Q&c\u0006r^<cEoDsh\u001dcT&y\fhPsd\u000b&G2\u007f\u0004j[6a"), PKCS11Exception.a("Y\rc\u0017!h\u0014sR y\u0000b\u00175x\u000beC:b\u000b&^ -\u000biCs~\u0010vG<\u007f\u0011cS"), PKCS11Exception.a("F\u0000\u007f\u0017;l\u000bb[6-\fu\u0017:c\u0013g[:i"), PKCS11Exception.a("F\u0000\u007f\u0017 d\u001fc\u0017:~EiB'-\n`\u0017!l\u000baR"), PKCS11Exception.a("F\u0000\u007f\u0017't\u0015c\u0017:~EoY0b\u000bu^ y\u0000hCsz\fr_s`\u0000e_2c\fuZ"), PKCS11Exception.a("F\u0000\u007f\u0017=b\u0011&Y6h\u0001cS\u007f-\u0000~C!l\u000bcX&~EmR*-\u0016sG#a\fcS"), PKCS11Exception.a("F\u0000\u007f\u0017;l\u0016&U6h\u000b&T;l\u000baR7"), PKCS11Exception.a("F\u0000\u007f\u0017=h\u0000bR7!EhXsf\u0000\u007f\u0017 x\u0015v[:h\u0001"), PKCS11Exception.a("Y\rc\u0017%l\tsRsb\u0003&C;hEuG6n\f`^6iEmR*-\u0006gY=b\u0011&U6-\u0001oP6~\u0011cS"), PKCS11Exception.a("K\u0010hT'd\nh\u0017=b\u0011&G6\u007f\boC'h\u0001&Q<\u007fEr_:~EmR*"), PKCS11Exception.a("F\u0000\u007f\u00170l\u000bhX'-\u0007c\u0017$\u007f\u0004vG6i"), PKCS11Exception.a("F\u0000\u007f\u0017:~EsY6u\u0011tV0y\u0004d[6"), PKCS11Exception.a("@\u0000e_2c\fuZsd\u000bpV?d\u0001"), PKCS11Exception.a("@\u0000e_2c\fuZs}\u0004tV>h\u0011cEsd\u0016&^={\u0004j^7"), PKCS11Exception.a("B\u0007lR0yEnV=i\tc\u0017:~EoY%l\toS"), PKCS11Exception.a("L\u000biC;h\u0017&X#h\u0017gC:b\u000b&^ -\u0004jE6l\u0001\u007f\u00172n\u0011oA6"), PKCS11Exception.a("B\u0015cE2y\fiYse\u0004u\u0017=b\u0011&U6h\u000b&^=d\u0011oV?d\u001fcS"), PKCS11Exception.a("]\fh\u0017:~EoY0b\u0017tR0y"), PKCS11Exception.a("C\u0000q\u0017\u0003D+&T<y\u0004oY -\fhA2a\fb\u00170e\u0004tV0y\u0000tD"), PKCS11Exception.a("C\u0000q\u0017\u0003D+&[6c\u0002r_sd\u0016&X&yEiQs\u007f\u0004hP6"), PKCS11Exception.a("]\fh\u0017;l\u0016&R+}\ftR7"), PKCS11Exception.a("]\fh\u0017:~EjX0f\u0000b"), PKCS11Exception.a("^\u0000uD:b\u000b&_2~EdR6cEe[<~\u0000b"), PKCS11Exception.a("^\u0000uD:b\u000b&[:`\frDse\u0004pRso\u0000cYs\u007f\u0000gT;h\u0001"), PKCS11Exception.a("^\u0000uD:b\u000b&_2c\u0001jRsd\u0016&^={\u0004j^7"), PKCS11Exception.a("]\u0004tV?a\u0000j\u00176u\u0000eB'd\nh\u0017:~EhX'-\u0016sG#b\u0017rR7"), PKCS11Exception.a("^\u0000uD:b\u000b&^ -\u0017cV7 \nh[*"), PKCS11Exception.a("LEuR ~\fiYsz\fr_sy\rc\u0017'b\u000ecYsd\u0016&V?\u007f\u0000gS*-\nvR="), PKCS11Exception.a("LEtR2iHiY?tEuR ~\fiYsl\ttR2i\u001c&R+d\u0016rDsl\u000bb\u0017'e\u0000&d\u001c-\u0006gY=b\u0011&U6-\tiP4h\u0001&^="), PKCS11Exception.a("LEtR2iJqE:y\u0000&d\u001c-\u0016cD d\nh\u00172a\u0017cV7tEcO:~\u0011u\u00172c\u0001&C;hEUxsn\u0004hY<yEdRsa\naP6iEoY"), PKCS11Exception.a("^\faY2y\u0010tRsd\u0016&^={\u0004j^7"), PKCS11Exception.a("^\faY2y\u0010tRsa\u0000hP'eEoDsb\u0010r\u0017<kEtV=j\u0000"), PKCS11Exception.a("Y\u0000kG?l\u0011c\u0017:~EoY0b\bv[6y\u0000"), PKCS11Exception.a("Y\u0000kG?l\u0011c\u0017:~EoY0b\u000bu^ y\u0000hC"), PKCS11Exception.a("^\tiCsi\ncDsc\nr\u00170b\u000brV:cEg\u0017'b\u000ecY"), PKCS11Exception.a("Y\rc\u0017'b\u000ecYsz\u0004u\u0017=b\u0011&E6n\naY:w\u0000b"), PKCS11Exception.a("Y\nmR=-\fu\u0017$\u007f\frR~}\u0017iC6n\u0011cS"), PKCS11Exception.a("X\u000bqE2}\u0015oY4-\u000ecNse\u0004hS?hEoDsd\u000bpV?d\u0001"), PKCS11Exception.a("X\u000bqE2}\u0015oY4-\u000ecNs~\f|Rsd\u0016&X&yEiQs\u007f\u0004hP6"), PKCS11Exception.a("X\u000bqE2}\u0015oY4-\u000ecNsd\u0016&^=n\nhD:~\u0011cY'-\u0012oC;-\bcT;l\u000boD>"), PKCS11Exception.a("LEsD6\u007fEoDsl\ttR2i\u001c&[<j\u0002cSsd\u000b"), PKCS11Exception.a("LEsD6\u007fEoDsc\nr\u0017?b\u0002aR7-\fh"), PKCS11Exception.a("Y\rc\u0017&~\u0000t\u0010 -5Oyse\u0004u\u0017=b\u0011&U6h\u000b&^=d\u0011oV?d\u001fcS"), PKCS11Exception.a("X\u0016cEsy\u001cvRsd\u0016&^={\u0004j^7"), PKCS11Exception.a("L\u000biC;h\u0017&B h\u0017&^ -\u0004jE6l\u0001\u007f\u0017?b\u0002aR7-\fh"), PKCS11Exception.a("Y\ni\u0017>l\u000b\u007f\u0017&~\u0000tDsa\naP6iEoY"), PKCS11Exception.a("Z\u0017gG#h\u0001&\\6tEoDsd\u000bpV?d\u0001"), PKCS11Exception.a("Z\u0017gG#h\u0001&\\6tEjR=j\u0011n\u0017:~EiB'-\n`\u0017!l\u000baR"), PKCS11Exception.a("Z\u0017gG#d\u000ba\u00178h\u001c&_2c\u0001jRsd\u0016&^={\u0004j^7"), PKCS11Exception.a("Z\u0017gG#d\u000ba\u00178h\u001c&D:w\u0000&^ -\fhA2a\fb"), PKCS11Exception.a("Z\u0017gG#d\u000ba\u00178h\u001c&C*}\u0000&^ -\fhT<c\u0016oD'h\u000br\u0017$d\u0011n\u0017>h\u0006nV=d\u0016k"), PKCS11Exception.a("_\u0004hS<`EhB>o\u0000t\u00174h\u000bcE2y\nt\u00177b\u0000u\u0017=b\u0011&V0n\u0000vCs~\u0000cS:c\u0002"), PKCS11Exception.a("Y\rc\u0017'b\u000ecYsi\ncDsc\nr\u0017;l\u0013c\u00172-\u0017gY7b\b&Y&`\u0007cEsj\u0000hR!l\u0011iE"), PKCS11Exception.a("D\u000bpV?d\u0001&X!-\u0010hD&}\u0015iE'h\u0001&S<`\u0004oYs}\u0004tV>h\u0011cE "), PKCS11Exception.a("O\u0010`Q6\u007fErX<-\u0016kV?a"), PKCS11Exception.a("Y\rc\u0017 l\u0013cSsb\u0015cE2y\fiY -\u0016rV'hEoDsd\u000bpV?d\u0001&V=iEeV=c\nr\u00171hEtR y\ntR7"), PKCS11Exception.a("Y\rc\u0017!h\u0014sR y\u0000b\u0017:c\u0003iE>l\u0011oX=-\fu\u0017 h\u000bu^'d\u0013c\u00172c\u0001&T2c\u000biCso\u0000&E6{\u0000g[6i"), PKCS11Exception.a("Y\rc\u0017<}\u0000tV'd\nhDs~\u0011gC6-\u0006gY=b\u0011&U6-\u0016gA6i"), PKCS11Exception.a("N\u0017\u007fG'b\u000eo\u0017:~EhX'-\u001ccCsd\u000boC:l\toM6i"), PKCS11Exception.a("N\u0017\u007fG'b\u000eo\u0017:~Eg[!h\u0004bNsd\u000boC:l\toM6i"), PKCS11Exception.a("@\u0010rR+-\nd]6n\u0011&^ -\u0007gS"), PKCS11Exception.a("@\u0010rR+-\fu\u0017=b\u0011&[<n\u000ecS")};
    int code;

    public PKCS11Exception(int n2) {
        super(PKCS11Exception.errorMessage(n2));
        this.code = n2;
    }

    public PKCS11Exception(String string) {
        super(string);
        this.code = Integer.MIN_VALUE;
    }

    public int getCode() {
        return this.code;
    }

    static String errorMessage(int n2) {
        if ((n2 & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return PKCS11Exception.a("[\u0000hS<\u007fEbR5d\u000bcSsh\u0017tX!");
        }
        int n3 = 0;
        while (n3 < CKR_names.length) {
            if (CKR_types[n3] == n2) {
                return CKR_names[n3];
            }
            ++n3;
        }
        return PKCS11Exception.a("X\u000bmY<z\u000b&R!\u007f\nt\u0017{=\u001d") + Integer.toHexString(n2) + ")";
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 13;
                        break;
                    }
                    case 1: {
                        n5 = 101;
                        break;
                    }
                    case 2: {
                        n5 = 6;
                        break;
                    }
                    case 3: {
                        n5 = 55;
                        break;
                    }
                    default: {
                        n5 = 83;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

