/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final int CLASS = 0;
    public static final int TOKEN = 1;
    public static final int PRIVATE = 2;
    public static final int LABEL = 3;
    public static final int APPLICATION = 16;
    public static final int VALUE = 17;
    public static final int OBJECT_ID = 18;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int ISSUER = 129;
    public static final int SERIAL_NUMBER = 130;
    public static final int AC_ISSUER = 131;
    public static final int OWNER = 132;
    public static final int ATTR_TYPES = 133;
    public static final int TRUSTED = 134;
    public static final int KEY_TYPE = 256;
    public static final int SUBJECT = 257;
    public static final int ID = 258;
    public static final int SENSITIVE = 259;
    public static final int ENCRYPT = 260;
    public static final int DECRYPT = 261;
    public static final int WRAP = 262;
    public static final int UNWRAP = 263;
    public static final int SIGN = 264;
    public static final int SIGN_RECOVER = 265;
    public static final int VERIFY = 266;
    public static final int VERIFY_RECOVER = 267;
    public static final int DERIVE = 268;
    public static final int START_DATE = 272;
    public static final int END_DATE = 273;
    public static final int MODULUS = 288;
    public static final int MODULUS_BITS = 289;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PRIME_1 = 292;
    public static final int PRIME_2 = 293;
    public static final int EXPONENT_1 = 294;
    public static final int EXPONENT_2 = 295;
    public static final int COEFFICIENT = 296;
    public static final int PRIME = 304;
    public static final int SUBPRIME = 305;
    public static final int BASE = 306;
    public static final int PRIME_BITS = 307;
    public static final int SUBPRIME_BITS = 308;
    public static final int VALUE_BITS = 352;
    public static final int VALUE_LEN = 353;
    public static final int EXTRACTABLE = 354;
    public static final int LOCAL = 355;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int KEY_GEN_MECHANISM = 358;
    public static final int MODIFIABLE = 368;
    public static final int ECDSA_PARAMS = 384;
    public static final int EC_PARAMS = 384;
    public static final int EC_POINT = 385;
    public static final int SECONDARY_AUTH = 512;
    public static final int AUTH_PIN_FLAGS = 513;
    public static final int HW_FEATURE_TYPE = 768;
    public static final int RESET_ON_INIT = 769;
    public static final int HAS_RESET = 770;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int INVALID = -1;
    private static final int[] CKA_types = new int[]{0, 1, 2, 3, 16, 17, 18, 128, 129, 130, 131, 132, 133, 134, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 272, 273, 288, 289, 290, 291, 292, 293, 294, 295, 296, 304, 305, 306, 307, 308, 352, 353, 354, 355, 356, 357, 358, 368, 384, 384, 385, 512, 513, 768, 769, 770};
    private static final String[] CKA_names = new String[]{PKCS11Object.a("\u001bg\u001c^9"), PKCS11Object.a("\fd\u0016H$"), PKCS11Object.a("\by\u0014[+\fn"), PKCS11Object.a("\u0014j\u001fH&"), PKCS11Object.a("\u0019{\rA#\u001bj\tD%\u0016"), PKCS11Object.a("\u000ej\u0011X/"), PKCS11Object.a("\u0017i\u0017H)\ft\u0014I"), PKCS11Object.a("\u001bn\u000fY#\u001eb\u001eL>\u001dt\tT:\u001d"), PKCS11Object.a("\u0011x\u000eX/\n"), PKCS11Object.a("\u000bn\u000fD+\u0014t\u0013X'\u001an\u000f"), PKCS11Object.a("\u0019h\u0002D9\u000b~\u0018_"), PKCS11Object.a("\u0017|\u0013H8"), PKCS11Object.a("\u0019\u007f\t_5\fr\rH9"), PKCS11Object.a("\fy\b^>\u001do"), PKCS11Object.a("\u0013n\u0004R>\u0001{\u0018"), PKCS11Object.a("\u000b~\u001fG/\u001b\u007f"), PKCS11Object.a("\u0011o"), PKCS11Object.a("\u000bn\u0013^#\fb\u000bH"), PKCS11Object.a("\u001de\u001e_3\b\u007f"), PKCS11Object.a("\u001cn\u001e_3\b\u007f"), PKCS11Object.a("\u000fy\u001c]"), PKCS11Object.a("\re\n_+\b"), PKCS11Object.a("\u000bb\u001aC"), PKCS11Object.a("\u000bb\u001aC5\nn\u001eB<\u001dy"), PKCS11Object.a("\u000en\u000fD,\u0001"), PKCS11Object.a("\u000en\u000fD,\u0001t\u000fH)\u0017}\u0018_"), PKCS11Object.a("\u001cn\u000fD<\u001d"), PKCS11Object.a("\u000b\u007f\u001c_>\u0007o\u001cY/"), PKCS11Object.a("\u001de\u0019R.\u0019\u007f\u0018"), PKCS11Object.a("\u0015d\u0019X&\rx"), PKCS11Object.a("\u0015d\u0019X&\rx\u0002O#\fx"), PKCS11Object.a("\b~\u001fA#\u001bt\u0018U:\u0017e\u0018C>"), PKCS11Object.a("\by\u0014[+\fn\u0002H2\bd\u0013H$\f"), PKCS11Object.a("\by\u0014@/\u0007\u001a"), PKCS11Object.a("\by\u0014@/\u0007\u0019"), PKCS11Object.a("\u001ds\rB$\u001de\tR["), PKCS11Object.a("\u001ds\rB$\u001de\tRX"), PKCS11Object.a("\u001bd\u0018K,\u0011h\u0014H$\f"), PKCS11Object.a("\by\u0014@/"), PKCS11Object.a("\u000b~\u001f]8\u0011f\u0018"), PKCS11Object.a("\u001aj\u000eH"), PKCS11Object.a("\by\u0014@/\u0007i\u0014Y9"), PKCS11Object.a("\u000b~\u001f]8\u0011f\u0018R(\u0011\u007f\u000e"), PKCS11Object.a("\u000ej\u0011X/\u0007i\u0014Y9"), PKCS11Object.a("\u000ej\u0011X/\u0007g\u0018C"), PKCS11Object.a("\u001ds\t_+\u001b\u007f\u001cO&\u001d"), PKCS11Object.a("\u0014d\u001eL&"), PKCS11Object.a("\u0016n\u000bH8\u0007n\u0005Y8\u0019h\tL(\u0014n"), PKCS11Object.a("\u0019g\nL3\u000bt\u000eH$\u000bb\tD<\u001d"), PKCS11Object.a("\u0013n\u0004R-\u001de\u0002@/\u001bc\u001cC#\u000bf"), PKCS11Object.a("\u0015d\u0019D,\u0011j\u001fA/"), PKCS11Object.a("\u001dh\u0019^+\u0007{\u001c_+\u0015x"), PKCS11Object.a("\u001dh\u0002]+\nj\u0010^"), PKCS11Object.a("\u001dh\u0002]%\u0011e\t"), PKCS11Object.a("\u000bn\u001eB$\u001cj\u000fT5\u0019~\tE"), PKCS11Object.a("\u0019~\tE5\bb\u0013R,\u0014j\u001a^"), PKCS11Object.a("\u0010|\u0002K/\u0019\u007f\b_/\u0007\u007f\u0004]/"), PKCS11Object.a("\nn\u000eH>\u0007d\u0013R#\u0016b\t"), PKCS11Object.a("\u0010j\u000eR8\u001dx\u0018Y")};
    private static final Class[] CKA_classes = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u000b_/d\u0004?"))) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u000b_/d\u0004?"))) : class$java$lang$String, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("2J+lD-_4aD\u001cJ)h"))) : class$java$util$Date, class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("2J+lD-_4aD\u001cJ)h"))) : class$java$util$Date, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean};
    public static final Integer RSA = new Integer(0);
    public static final Integer DSA = new Integer(1);
    public static final Integer DH = new Integer(2);
    public static final Integer ECDSA = new Integer(3);
    public static final Integer EC = new Integer(3);
    public static final Integer X9_42_DH = new Integer(4);
    public static final Integer KEA = new Integer(5);
    public static final Integer GENERIC_SECRET = new Integer(16);
    public static final Integer RC2 = new Integer(17);
    public static final Integer RC4 = new Integer(18);
    public static final Integer DES = new Integer(19);
    public static final Integer DES2 = new Integer(20);
    public static final Integer DES3 = new Integer(21);
    public static final Integer CAST = new Integer(22);
    public static final Integer CAST3 = new Integer(23);
    public static final Integer CAST5 = new Integer(24);
    public static final Integer CAST128 = new Integer(24);
    public static final Integer RC5 = new Integer(25);
    public static final Integer IDEA = new Integer(26);
    public static final Integer SKIPJACK = new Integer(27);
    public static final Integer BATON = new Integer(28);
    public static final Integer JUNIPER = new Integer(29);
    public static final Integer CDMF = new Integer(30);
    public static final Integer AES = new Integer(31);
    private static final Integer[] CKK_types = new Integer[]{RSA, DSA, DH, ECDSA, EC, X9_42_DH, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, CAST128, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF, AES};
    private static final String[] CKK_names = new String[]{PKCS11Object.a("\nx\u001c"), PKCS11Object.a("\u001cx\u001c"), PKCS11Object.a("\u001cc"), PKCS11Object.a("\u001dh\u0019^+"), PKCS11Object.a("\u001dh"), PKCS11Object.a("\u0000\u0012\u00029X\u0007o\u0015"), PKCS11Object.a("\u0013n\u001c"), PKCS11Object.a("\u001fn\u0013H8\u0011h\u0002^/\u001by\u0018Y"), PKCS11Object.a("\nho"), PKCS11Object.a("\nhi"), PKCS11Object.a("\u001cn\u000e"), PKCS11Object.a("\u001cn\u000e?"), PKCS11Object.a("\u001cn\u000e>"), PKCS11Object.a("\u001bj\u000eY"), PKCS11Object.a("\u001bj\u000eYY"), PKCS11Object.a("\u001bj\u000eY_"), PKCS11Object.a("\u001bj\u000eY[j\u0013"), PKCS11Object.a("\nhh"), PKCS11Object.a("\u0011o\u0018L"), PKCS11Object.a("\u000b`\u0014] \u0019h\u0016"), PKCS11Object.a("\u001aj\tB$"), PKCS11Object.a("\u0012~\u0013D:\u001dy"), PKCS11Object.a("\u001bo\u0010K"), PKCS11Object.a("\u0019n\u000e")};
    public static final Integer DATA = new Integer(0);
    public static final Integer CERTIFICATE = new Integer(1);
    public static final Integer PUBLIC_KEY = new Integer(2);
    public static final Integer PRIVATE_KEY = new Integer(3);
    public static final Integer SECRET_KEY = new Integer(4);
    public static final Integer HW_FEATURE = new Integer(5);
    public static final Integer DOMAIN_PARAMETERS = new Integer(6);
    private static final Integer[] CKO_types = new Integer[]{DATA, CERTIFICATE, PUBLIC_KEY, PRIVATE_KEY, SECRET_KEY, HW_FEATURE, DOMAIN_PARAMETERS};
    private static final String[] CKO_names = new String[]{PKCS11Object.a("\u001cj\tL"), PKCS11Object.a("\u001bn\u000fY#\u001eb\u001eL>\u001d"), PKCS11Object.a("\b~\u001fA#\u001bt\u0016H3"), PKCS11Object.a("\by\u0014[+\fn\u0002F/\u0001"), PKCS11Object.a("\u000bn\u001e_/\ft\u0016H3"), PKCS11Object.a("\u0010|\u0002K/\u0019\u007f\b_/"), PKCS11Object.a("\u001cd\u0010L#\u0016t\rL8\u0019f\u0018Y/\nx")};
    public static final Integer MONOTONIC_COUNTER = new Integer(1);
    public static final Integer CLOCK = new Integer(2);
    private static final Integer[] CKH_types = new Integer[]{MONOTONIC_COUNTER, CLOCK};
    private static final String[] CKH_names = new String[]{PKCS11Object.a("\u0015d\u0013B>\u0017e\u0014N5\u001bd\bC>\u001dy"), PKCS11Object.a("\u001bg\u0012N!")};
    public static final Integer X_509 = new Integer(0);
    public static final Integer X_509_ATTR_CERT = new Integer(1);
    private static final Integer[] CKC_types = new Integer[]{X_509, X_509_ATTR_CERT};
    private static final String[] CKC_names = new String[]{PKCS11Object.a("\u0000th=S"), PKCS11Object.a("\u0000th=S\u0007j\tY8\u0007h\u0018_>")};
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    private static final int[] pinflagList = new int[]{65536, 131072, 262144, 524288};
    static final String[] pinflagNames = new String[]{PKCS11Object.a("\rx\u0018_5\bb\u0013R)\u0017~\u0013Y5\u0014d\n"), PKCS11Object.a("\rx\u0018_5\bb\u0013R,\u0011e\u001cA5\fy\u0004"), PKCS11Object.a("\rx\u0018_5\bb\u0013R&\u0017h\u0016H."), PKCS11Object.a("\rx\u0018_5\bb\u0013R>\u0017t\u001fH5\u001bc\u001cC-\u001do")};
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract int size() throws PKCS11Exception;

    public Object[] getAttributeValues(int[] nArray) throws PKCS11Exception {
        Object[] objectArray = new Object[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            objectArray[n2] = this.getAttributeValue(nArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public boolean getBoolAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean)) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(n2);
    }

    public int getIntAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer)) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(n2);
    }

    public String getStringAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u000b_/d\u0004?"))) : class$java$lang$String)) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(n2);
    }

    public byte[] getByteArrayAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B)) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(n2);
    }

    public Date getDateAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("2J+lD-_4aD\u001cJ)h"))) : class$java$util$Date)) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(n2);
    }

    public BigInteger getBigIntegerAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger)) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(n2);
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public void setBoolAttributeValue(int n2, boolean bl2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u001aD2a\u000f9E"))) : class$java$lang$Boolean)) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Boolean(bl2));
    }

    public void setIntAttributeValue(int n2, int n3) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer)) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Integer(n3));
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(512);
        String string = PKCS11Object.a("x\u000b}-Jx\u000b}-Jx\u000b}-Jx\u000b}-J");
        stringBuffer.append(PKCS11Object.a("7I7h\t,\u0011W"));
        int n3 = 0;
        while (n3 < CKA_types.length) {
            String string2;
            String string3;
            block6: {
                n2 = CKA_types[n3];
                string3 = PKCS11Object.typeToString(n2);
                string2 = null;
                try {
                    Object object = this.getAttributeValue(n2);
                    string2 = PKCS11Object.attrToString(n2, object);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (pKCS11Exception.getCode() != 17) break block6;
                    string2 = PKCS11Object.a("pj\tY8\u0011i\bY/\u0007x\u0018C9\u0011\u007f\u0014[/q");
                }
            }
            if (string2 != null) {
                stringBuffer.append("\t").append(string3).append(":");
                stringBuffer.append(string.substring(string3.length()));
                stringBuffer.append(string2).append("\n");
            }
            ++n3;
        }
        try {
            n2 = this.size();
            stringBuffer.append(PKCS11Object.a("Qx\u0014W/b")).append(string.substring(4)).append(n2).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static Class valueClass(int n2) {
        int n3 = 0;
        while (n3 < CKA_types.length) {
            if (CKA_types[n3] == n2) {
                return CKA_classes[n3];
            }
            ++n3;
        }
        return null;
    }

    public static String typeToString(int n2) {
        int n3 = 0;
        while (n3 < CKA_types.length) {
            if (CKA_types[n3] == n2) {
                return CKA_names[n3];
            }
            ++n3;
        }
        return PKCS11Object.a("hS") + Integer.toHexString(n2);
    }

    public static String classToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKO_types, CKO_names);
    }

    public static String keyToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKK_types, CKK_names);
    }

    public static String hwfeatureToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKH_types, CKH_names);
    }

    public static String certToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKC_types, CKC_names);
    }

    public static String pinflagsToString(Integer n2) {
        return PKCS11.flagsToString(n2, pinflagList, pinflagNames, PKCS11Object.a("xW}"));
    }

    public static String attrToString(int n2, Object object) {
        if (object == null) {
            return PKCS11Object.a("6^1a");
        }
        Class clazz = PKCS11Object.valueClass(n2);
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("2J+lD4J3jD\u0011E)h\r=Y"))) : class$java$lang$Integer)) {
            switch (n2) {
                case 0: {
                    return PKCS11Object.classToString((Integer)object);
                }
                case 256: {
                    return PKCS11Object.keyToString((Integer)object);
                }
                case 128: {
                    return PKCS11Object.certToString((Integer)object);
                }
                case 513: {
                    return PKCS11Object.pinflagsToString((Integer)object);
                }
                case 768: {
                    return PKCS11Object.hwfeatureToString((Integer)object);
                }
            }
            return object.toString();
        }
        if (clazz == (array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("\u0003i"))) : array$B)) {
            return PKCS11Object.bytesToString((byte[])object, 10);
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("2J+lD5J)eD\u001aB:D\u0004,N:h\u0018"))) : class$java$math$BigInteger)) {
            return PKCS11Object.a("hS") + ((BigInteger)object).toString(16);
        }
        return object.toString();
    }

    public static String bytesToString(byte[] byArray, int n2) {
        if (byArray == null) {
            return PKCS11Object.a("6^1a");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if (n2 != 0 && n4 > n2) {
                stringBuffer.append(PKCS11Object.a("x\u0005s#Jp")).append(byArray.length).append(PKCS11Object.a("xI$y\u000f+\u0002"));
                break;
            }
            if (n3 == 16) {
                stringBuffer.append('\n');
                n3 = 0;
            }
            if (n3 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(PKCS11Object.a("h\u001ao>^m\u001dj5S9I>i\u000f>").charAt(byArray[n4] >> 4 & 0xF));
            stringBuffer.append(PKCS11Object.a("h\u001ao>^m\u001dj5S9I>i\u000f>").charAt(byArray[n4] & 0xF));
            ++n4;
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String IntegerToString(Integer n2, Integer[] integerArray, String[] stringArray) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < integerArray.length) {
            if (integerArray[n4] == n3) {
                return stringArray[n4];
            }
            ++n4;
        }
        return PKCS11Object.a("hS") + Integer.toHexString(n3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 88;
                        break;
                    }
                    case 1: {
                        n5 = 43;
                        break;
                    }
                    case 2: {
                        n5 = 93;
                        break;
                    }
                    case 3: {
                        n5 = 13;
                        break;
                    }
                    default: {
                        n5 = 106;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

