/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11SlotInfo {
    public static final int TOKEN_PRESENT = 1;
    public static final int REMOVABLE_DEVICE = 2;
    public static final int HW_SLOT = 4;
    static int[] flagList = new int[]{1, 2, 4};
    static String[] flagNames = new String[]{PKCS11SlotInfo.a("\u001d+xpV\u00164apK\f*g"), PKCS11SlotInfo.a("\u001b!~zN\b&\u007fpG\r!e|[\f"), PKCS11SlotInfo.a("\u00013lfT\u00060")};
    private String description;
    private String manufacturer;
    private int flags;
    private int hardwareVersion;
    private int firmwareVersion;

    public PKCS11SlotInfo(String string, String string2, int n2, int n3, int n4) {
        this.description = string;
        this.manufacturer = string2;
        this.flags = n2;
        this.hardwareVersion = n3;
        this.firmwareVersion = n4;
    }

    public String description() {
        return this.description;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public int flags() {
        return this.flags;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean tokenPresent() {
        return (this.flags & 1) != 0;
    }

    public boolean removableDevice() {
        return (this.flags & 2) != 0;
    }

    public boolean hardwareSlot() {
        return (this.flags & 4) != 0;
    }

    public String toString() {
        return PKCS11SlotInfo.a("\u0019/pf)x7_Zl\u0000\nUZ\"CD\u0013\u00158\r\u0001@Vj \u0014G\\w'^\u0013\u00158iD\u0013\u0015") + this.description + PKCS11SlotInfo.a("CD\u0013\u00158\u0004\u0005]@~(\u0007G@j,\u0016\t\u00158iD\u0013\u0015") + this.manufacturer + PKCS11SlotInfo.a("CD\u0013\u00158\u000f\bRRksD\u0013\u00158iD\u0013\u00158iD\u0013\u0015") + this.flagsToString(PKCS11SlotInfo.a("i\u0018\u0013")) + PKCS11SlotInfo.a("CD\u0013\u00158\u0001\u0005AQo(\u0016V\u0015n,\u0016@\\w'^\u0013\u0015") + PKCS11.versionString(this.hardwareVersion) + PKCS11SlotInfo.a("CD\u0013\u00158\u000f\rAXo(\u0016V\u0015n,\u0016@\\w'^\u0013\u0015") + PKCS11.versionString(this.firmwareVersion);
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 73;
                        break;
                    }
                    case 1: {
                        n5 = 100;
                        break;
                    }
                    case 2: {
                        n5 = 51;
                        break;
                    }
                    case 3: {
                        n5 = 53;
                        break;
                    }
                    default: {
                        n5 = 24;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

