/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11TokenInfo {
    public static final int RNG = 1;
    public static final int WRITE_PROTECTED = 2;
    public static final int LOGIN_REQUIRED = 4;
    public static final int USER_PIN_INITIALIZED = 8;
    public static final int EXCLUSIVE_EXISTS = 16;
    public static final int RESTORE_KEY_NOT_NEEDED = 32;
    public static final int CLOCK_ON_TOKEN = 64;
    public static final int SUPPORTS_PARALLEL = 128;
    public static final int PROTECTED_AUTHENTICATION_PATH = 256;
    public static final int DUAL_CRYPTO_OPERATIONS = 512;
    public static final int TOKEN_INITIALIZED = 1024;
    public static final int SECONDARY_AUTHENTICATION = 2048;
    public static final int USER_PIN_COUNT_LOW = 65536;
    public static final int USER_PIN_FINAL_TRY = 131072;
    public static final int USER_PIN_LOCKED = 262144;
    public static final int USER_PIN_TO_BE_CHANGED = 524288;
    public static final int SO_PIN_COUNT_LOW = 0x100000;
    public static final int SO_PIN_FINAL_TRY = 0x200000;
    public static final int SO_PIN_LOCKED = 0x400000;
    public static final int SO_PIN_TO_BE_CHANGED = 0x800000;
    public static final int UNAVAILABLE_INFORMATION = -1;
    public static final int EFFECTIVELY_INFINITE = 0;
    static final int[] flagList = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000};
    static final String[] flagNames = new String[]{PKCS11TokenInfo.a("-!H"), PKCS11TokenInfo.a("(=Fi9 ?]r(:,[x8"), PKCS11TokenInfo.a("3 Ht2 =Jl)6=Jy"), PKCS11TokenInfo.a("*<Jo#/&Ab51&[t=3&Ux8"), PKCS11TokenInfo.a(":7Lq),&Yx#:7Fn(,"), PKCS11TokenInfo.a("-*\\i3-*Pv9&0Ar( !Jx8:+"), PKCS11TokenInfo.a("<#@~7  Ab(0$Js"), PKCS11TokenInfo.a(",:_m3-;\\b,>=Nq0:#"), PKCS11TokenInfo.a("/=@i9<;Jy#>:[u91;F~=+&@s#/.[u"), PKCS11TokenInfo.a(";:Nq#<=Vm(00@m9-.[t31<"), PKCS11TokenInfo.a("+ Dx2 &At(6.Ct&:+"), PKCS11TokenInfo.a(",*Lr2;.]d#>:[u91;F~=+&@s"), PKCS11TokenInfo.a("*<Jo#/&Ab?0:Ai#3 X"), PKCS11TokenInfo.a("*<Jo#/&Ab:6!Nq#+=V"), PKCS11TokenInfo.a("*<Jo#/&Ab00,Dx8"), PKCS11TokenInfo.a("*<Jo#/&Ab(00Mx#<'Ns;:+"), PKCS11TokenInfo.a(", Pm510Lr)1;Pq3("), PKCS11TokenInfo.a(", Pm510It2>#Pi.&"), PKCS11TokenInfo.a(", Pm510Cr?4*K"), PKCS11TokenInfo.a(", Pm510[r#=*P~4>!Hx8")};
    private String label;
    private String manufacturer;
    private String model;
    private String serialNumber;
    private int flags;
    private int maxSessionCount;
    private int sessionCount;
    private int maxRwSessionCount;
    private int rwSessionCount;
    private int maxPinLen;
    private int minPinLen;
    private int totalPublicMemory;
    private int freePublicMemory;
    private int totalPrivateMemory;
    private int freePrivateMemory;
    private int hardwareVersion;
    private int firmwareVersion;
    private String utcTime;

    public PKCS11TokenInfo(String string, String string2, String string3, String string4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, String string5) {
        this.label = string;
        this.manufacturer = string2;
        this.model = string3;
        this.serialNumber = string4;
        this.flags = n2;
        this.maxSessionCount = n3;
        this.sessionCount = n4;
        this.maxRwSessionCount = n5;
        this.rwSessionCount = n6;
        this.maxPinLen = n7;
        this.minPinLen = n8;
        this.totalPublicMemory = n9;
        this.freePublicMemory = n10;
        this.totalPrivateMemory = n11;
        this.freePrivateMemory = n12;
        this.hardwareVersion = n13;
        this.firmwareVersion = n14;
        this.utcTime = string5;
    }

    public String label() {
        return this.label;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public int flags() {
        return this.flags;
    }

    public int maxSessionCount() {
        return this.maxSessionCount;
    }

    public int sessionCount() {
        return this.sessionCount;
    }

    public int maxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public int rwSessionCount() {
        return this.rwSessionCount;
    }

    public int maxPinLen() {
        return this.maxPinLen;
    }

    public int minPinLen() {
        return this.minPinLen;
    }

    public int totalPublicMemory() {
        return this.totalPublicMemory;
    }

    public int freePublicMemory() {
        return this.freePublicMemory;
    }

    public int totalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public int freePrivateMemory() {
        return this.freePrivateMemory;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public String utcTime() {
        return this.utcTime;
    }

    public String toString() {
        return PKCS11TokenInfo.a("/$LnMN;`V\u0019\u0011&a[\u0013Ee/\u001d\\_#n_\u0019\u0013U/\u001d\\_O/\u001d\\_O/\u001d\\") + this.label + PKCS11TokenInfo.a("uO/\u001d\\2\u000eaH\u001a\u001e\f{H\u000e\u001a\u001d5\u001d\\_O/\u001d") + this.manufacturer + PKCS11TokenInfo.a("uO/\u001d\\2\u0000kX\u0010EO/\u001d\\_O/\u001d\\_O/\u001d") + this.model + PKCS11TokenInfo.a("uO/\u001d\\,\n}T\u001d\u0013U/\u001d\\_O/\u001d\\_O/\u001d") + this.serialNumber + PKCS11TokenInfo.a("uO/\u001d\\9\u0003nZ\u000fEO/\u001d\\_O/\u001d\\_O/\u001d") + this.flagsToString(PKCS11TokenInfo.a("_\u0013/")) + PKCS11TokenInfo.a("uO/\u001d\\2\u000ew\u001d\u000f\u001a\u001c|T\u0013\u0011\u001c5\u001d\\_O/\u001d") + this.infinite(this.maxSessionCount) + PKCS11TokenInfo.a("uO/\u001d\\,\n|N\u0015\u0010\u0001|\u0007\\_O/\u001d\\_O/\u001d") + this.unavailable(this.sessionCount) + PKCS11TokenInfo.a("uO/\u001d\\2\u000ew\u001d.(O|X\u000f\f\u0006`S\u000fEO/\u001d") + this.infinite(this.maxRwSessionCount) + PKCS11TokenInfo.a("uO/\u001d\\-8/N\u0019\f\u001cfR\u0012\fU/\u001d\\_O/\u001d") + this.unavailable(this.rwSessionCount) + PKCS11TokenInfo.a("uO/\u001d\\2\u000ew\u001d,6!/Q\u0019\u0011U/\u001d\\_O/\u001d") + this.maxPinLen + PKCS11TokenInfo.a("uO/\u001d\\2\u0006a\u001d,6!/Q\u0019\u0011U/\u001d\\_O/\u001d") + this.minPinLen + PKCS11TokenInfo.a("uO/\u001d\\+\u0000{\\\u0010_\u001fz_\u0010\u0016\f/P\u0019\u0012U/\u001d") + this.unavailable(this.totalPublicMemory) + PKCS11TokenInfo.a("uO/\u001d\\9\u001djX\\\u000f\u001amQ\u0015\u001cObX\u0011EO/\u001d") + this.unavailable(this.freePublicMemory) + PKCS11TokenInfo.a("uO/\u001d\\+\u0000{\\\u0010_\u001f}T\n\u001e\u001bj\u001d\u0011\u001a\u00025\u001d") + this.unavailable(this.totalPrivateMemory) + PKCS11TokenInfo.a("uO/\u001d\\9\u001djX\\\u000f\u001dfK\u001d\u000b\n/P\u0019\u0012U/\u001d") + this.unavailable(this.freePrivateMemory) + PKCS11TokenInfo.a("uO/\u001d\\7\u000e}Y\u000b\u001e\u001dj\u001d\n\u001a\u001d|T\u0013\u0011U/\u001d") + PKCS11.versionString(this.hardwareVersion) + PKCS11TokenInfo.a("uO/\u001d\\9\u0006}P\u000b\u001e\u001dj\u001d\n\u001a\u001d|T\u0013\u0011U/\u001d") + PKCS11.versionString(this.firmwareVersion) + (this.utcTime != null ? PKCS11TokenInfo.a("uO/\u001d\\*;L\u001d\b\u0016\u0002j\u0007\\_O/\u001d\\_O/\u001d") + this.utcTime : "");
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    String infinite(int n2) {
        return n2 == 0 ? PKCS11TokenInfo.a(":)Ix?+&Yx0&0Fs:6!Fi9") : this.unavailable(n2);
    }

    String unavailable(int n2) {
        return n2 == -1 ? PKCS11TokenInfo.a("*!Nk=6#N\u007f0:0Fs:0=B|(6 A") : Integer.toString(n2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 127;
                        break;
                    }
                    case 1: {
                        n5 = 111;
                        break;
                    }
                    case 2: {
                        n5 = 15;
                        break;
                    }
                    case 3: {
                        n5 = 61;
                        break;
                    }
                    default: {
                        n5 = 124;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

