/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class AVAKeyword {
    private static final Map oidMap = new HashMap();
    private static final Map keywordMap = new HashMap();
    private String keyword;
    private ObjectIdentifier oid;
    private boolean rfc1779Compliant;
    private boolean rfc2253Compliant;

    private AVAKeyword(String string, ObjectIdentifier objectIdentifier, boolean bl, boolean bl2) {
        this.keyword = string;
        this.oid = objectIdentifier;
        this.rfc1779Compliant = bl;
        this.rfc2253Compliant = bl2;
        oidMap.put(objectIdentifier, this);
        keywordMap.put(string, this);
    }

    private boolean isCompliant(int n) {
        switch (n) {
            case 2: {
                return this.rfc1779Compliant;
            }
            case 3: {
                return this.rfc2253Compliant;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid standard " + n);
    }

    static ObjectIdentifier getOID(String string, int n) throws IOException {
        char c;
        AVAKeyword aVAKeyword;
        string = string.toUpperCase();
        if (n == 3) {
            if (string.startsWith(" ") || string.endsWith(" ")) {
                throw new IOException("Invalid leading or trailing space in keyword \"" + string + "\"");
            }
        } else {
            string = string.trim();
        }
        if ((aVAKeyword = (AVAKeyword)keywordMap.get(string)) != null && aVAKeyword.isCompliant(n)) {
            return aVAKeyword.oid;
        }
        if (n == 2) {
            if (!string.startsWith("OID.")) {
                throw new IOException("Invalid RFC1779 keyword: " + string);
            }
            string = string.substring(4);
        } else if (n == 1 && string.startsWith("OID.")) {
            string = string.substring(4);
        }
        boolean bl = false;
        if (string.length() != 0 && (c = string.charAt(0)) >= '0' && c <= '9') {
            bl = true;
        }
        if (!bl) {
            throw new IOException("Invalid keyword \"" + string + "\"");
        }
        return new ObjectIdentifier(string);
    }

    static String getKeyword(ObjectIdentifier objectIdentifier, int n) {
        AVAKeyword aVAKeyword = (AVAKeyword)oidMap.get(objectIdentifier);
        if (aVAKeyword != null && aVAKeyword.isCompliant(n)) {
            return aVAKeyword.keyword;
        }
        String string = objectIdentifier.toString();
        if (n == 3) {
            return string;
        }
        return "OID." + string;
    }

    static boolean hasKeyword(ObjectIdentifier objectIdentifier, int n) {
        AVAKeyword aVAKeyword = (AVAKeyword)oidMap.get(objectIdentifier);
        if (aVAKeyword == null) {
            return false;
        }
        return aVAKeyword.isCompliant(n);
    }

    static {
        new AVAKeyword("CN", X500Name.commonName_oid, true, true);
        new AVAKeyword("C", X500Name.countryName_oid, true, true);
        new AVAKeyword("L", X500Name.localityName_oid, true, true);
        new AVAKeyword("S", X500Name.stateName_oid, false, false);
        new AVAKeyword("ST", X500Name.stateName_oid, true, true);
        new AVAKeyword("O", X500Name.orgName_oid, true, true);
        new AVAKeyword("OU", X500Name.orgUnitName_oid, true, true);
        new AVAKeyword("T", X500Name.title_oid, false, false);
        new AVAKeyword("IP", X500Name.ipAddress_oid, false, false);
        new AVAKeyword("STREET", X500Name.streetAddress_oid, true, true);
        new AVAKeyword("DC", X500Name.domainComponent_oid, false, true);
        new AVAKeyword("DNQUALIFIER", X500Name.dnQualifier_oid, false, false);
        new AVAKeyword("DNQ", X500Name.dnQualifier_oid, false, false);
        new AVAKeyword("SURNAME", X500Name.surName_oid, false, false);
        new AVAKeyword("GIVENNAME", X500Name.givenName_oid, false, false);
        new AVAKeyword("INITIALS", X500Name.initials_oid, false, false);
        new AVAKeyword("GENERATION", X500Name.generationQualifier_oid, false, false);
        new AVAKeyword("EMAIL", X500Name.emailAddress_oid, false, false);
        new AVAKeyword("EMAILADDRESS", X500Name.emailAddress_oid, false, false);
        new AVAKeyword("UID", X500Name.userid_oid, false, true);
        new AVAKeyword("SERIALNUMBER", X500Name.serialNumber_oid, false, false);
        new AVAKeyword("POSTALCODE", X500Name.postalCode_oid, false, false);
    }
}

