/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBuff;
import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventListener;
import com.ibm.ejs.ras.TraceLogger;
import java.io.FileOutputStream;
import java.util.Enumeration;

class CBuffLogger
implements TraceEventListener {
    private CBuff ivCBuff;

    CBuffLogger(int size) {
        if (size < 1) {
            size = 8;
        }
        int sizeInKB = size * 1024;
        this.ivCBuff = new CBuff(sizeInKB);
    }

    synchronized void setSize(int size) {
        if (size < 1) {
            return;
        }
        int sizeInKB = size * 1024;
        this.ivCBuff.setSize(sizeInKB);
    }

    synchronized int getSize() {
        int size = this.ivCBuff.getSize() / 1024;
        return size;
    }

    synchronized void clear() {
        int size = this.ivCBuff.getSize();
        this.ivCBuff = new CBuff(size);
    }

    public synchronized void auditEvent(MessageEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void debugEvent(TraceEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void dumpEvent(TraceEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void errorEvent(MessageEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void eventEvent(TraceEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void entryEvent(TraceEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void exitEvent(TraceEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void fatalEvent(MessageEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void infoEvent(MessageEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void serviceEvent(MessageEvent event) {
    }

    public synchronized void systemErrEvent(StreamEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void systemOutEvent(StreamEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void uncondTraceEvent(TraceEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    public synchronized void warningEvent(MessageEvent event) {
        if (ComponentManager.svTraceEnabled) {
            this.ivCBuff.put(event);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void dump(String fileToWriteTo) throws RasException {
        FileOutputStream fs = null;
        try {
            try {
                RasHelper.validateFileName(fileToWriteTo.trim());
                fs = RasHelper.createFileOutputStream(fileToWriteTo, false);
                TraceLogger logger = null;
                logger = RasProperties.svTraceFormat.equals("loganalyzer") ? new ExtendedTraceLogger(fs) : (RasProperties.svTraceFormat.equals("advanced") ? new TraceLogger(fs, false) : new TraceLogger(fs, true));
                logger.printHeader();
                Enumeration enumeration = this.ivCBuff.elements();
                while (enumeration.hasMoreElements()) {
                    RasEvent event = (RasEvent)enumeration.nextElement();
                    if (event instanceof MessageEvent) {
                        MessageEvent me = (MessageEvent)event;
                        logger.logMessage(me);
                        continue;
                    }
                    TraceEvent te = (TraceEvent)event;
                    logger.logTrace(te);
                }
            }
            catch (RasException re) {
                throw new RasException("Failed to open file " + fileToWriteTo, (Throwable)((Object)re));
            }
            catch (Throwable t) {
                throw new RasException("Failure dumping the ring buffer " + fileToWriteTo, t);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                fs.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable t) {}
        fs.close();
        return;
    }
}

