/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Group;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceElement;
import com.ibm.ejs.ras.TraceEnableEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ComponentManager {
    static boolean svTraceEnabled = false;
    private static Hashtable traceTypeMap = new Hashtable();
    private Hashtable components = new Hashtable();
    private Hashtable groups = new Hashtable();
    private Hashtable dumpables;
    private Vector traceEnableEvents = new Vector();
    private int eventsThatEnableTrace = 0;

    ComponentManager() {
        this.dumpables = new Hashtable();
    }

    synchronized String[] getGroups() {
        String[] result = null;
        result = new String[this.groups.size()];
        Enumeration enumeration = this.groups.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            result[i++] = (String)enumeration.nextElement();
        }
        return result;
    }

    synchronized String[] getGroupComponents(String group) {
        Group g;
        String[] result = new String[]{};
        if (group != null && (g = (Group)this.groups.get(group)) != null) {
            result = g.getComponents();
        }
        return result;
    }

    synchronized String getTraceSpecification(String component) {
        String result = null;
        if (component != null) {
            TraceElement e = (TraceElement)this.groups.get(component);
            if (e == null) {
                e = (TraceElement)this.components.get(component);
            }
            if (e != null) {
                result = e.getTraceSpecification();
            }
        }
        return result;
    }

    synchronized String getTraceSpecification() {
        StringBuffer b = new StringBuffer(16);
        int size = this.traceEnableEvents.size();
        if (size == 0) {
            return "*=all=disabled";
        }
        int i = 0;
        while (i < size) {
            TraceEnableEvent te = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (i != 0) {
                b.append(":");
            }
            b.append(te.getComponentName());
            switch (te.getType()) {
                case 0: {
                    b.append("=all=");
                    break;
                }
                case 1: {
                    b.append("=debug=");
                    break;
                }
                case 2: {
                    b.append("=entryExit=");
                    break;
                }
                case 3: {
                    b.append("=event=");
                    break;
                }
                case 4: {
                    b.append("=dump=");
                }
            }
            if (te.enabled()) {
                b.append("enabled");
            } else {
                b.append("disabled");
            }
            ++i;
        }
        return new String(b);
    }

    synchronized void processTraceString(String string, boolean reset) {
        if (reset) {
            this.fireTraceEnableEvent(new TraceEnableEvent(false, 0, "*"));
        }
        if ((string = RasHelper.peelQuotes(string)) == null) {
            return;
        }
        String[] traceStrings = RasHelper.split(string, 58);
        int i = 0;
        while (i < traceStrings.length) {
            String[] typeEnableStrings;
            int endOfNameIndex = traceStrings[i].indexOf(61);
            if (endOfNameIndex == -1) {
                return;
            }
            String comp = traceStrings[i].substring(0, endOfNameIndex);
            if ((typeEnableStrings = RasHelper.split(traceStrings[i].substring(++endOfNameIndex), 44)).length == 0) {
                return;
            }
            int j = 0;
            while (j < typeEnableStrings.length) {
                String[] pieces = RasHelper.split(typeEnableStrings[j], 61);
                if (pieces.length != 2 || pieces[0] == null) {
                    return;
                }
                Integer type = (Integer)traceTypeMap.get(pieces[0]);
                if (type == null) {
                    return;
                }
                try {
                    TraceEnableEvent e = new TraceEnableEvent(pieces[1], (int)type, comp);
                    this.fireTraceEnableEvent(e);
                }
                catch (RasException re) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    synchronized void processDumpString(String s) {
        Dumpable d;
        Vector v;
        String currentComponent;
        if (s == null) {
            this.processNullDumpString();
            return;
        }
        if ((s = RasHelper.peelQuotes(s)) == null) {
            return;
        }
        String[] strComponents = RasHelper.split(s, 58);
        Object comp = null;
        Vector<TraceComponent> debugReenables = new Vector<TraceComponent>();
        Enumeration traceComps = this.components.elements();
        while (traceComps.hasMoreElements()) {
            TraceComponent tc = (TraceComponent)traceComps.nextElement();
            if (!tc.ivDebugEnabled) continue;
            tc.ivDebugEnabled = false;
            debugReenables.addElement(tc);
        }
        int i = 0;
        while (i < strComponents.length) {
            boolean enabled = true;
            currentComponent = strComponents[i];
            if (currentComponent.endsWith("=disabled")) {
                enabled = false;
                currentComponent = RasHelper.split(currentComponent, 61)[0];
            }
            TraceEnableEvent e = new TraceEnableEvent(enabled, 4, currentComponent);
            this.fireTraceEnableEvent(e);
            ++i;
        }
        int i2 = 0;
        while (i2 < strComponents.length) {
            currentComponent = RasHelper.split(strComponents[i2], 61)[0];
            Enumeration enumeration = this.dumpables.keys();
            while (enumeration.hasMoreElements()) {
                String dumpableComponent = (String)enumeration.nextElement();
                if (!this.componentEnabled(currentComponent, dumpableComponent)) continue;
                v = (Vector)this.dumpables.get(dumpableComponent);
                int j = 0;
                while (j < v.size()) {
                    d = (Dumpable)v.elementAt(j);
                    d.dump();
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < strComponents.length) {
            String currentComponent2 = RasHelper.split(strComponents[i3], 61)[0];
            TraceEnableEvent e = new TraceEnableEvent(false, 4, currentComponent2);
            this.fireTraceEnableEvent(e);
            ++i3;
        }
        int i4 = 0;
        while (i4 < debugReenables.size()) {
            TraceComponent tc = (TraceComponent)debugReenables.elementAt(i4);
            tc.ivDebugEnabled = true;
            ++i4;
        }
        Enumeration enumeration = this.dumpables.elements();
        while (enumeration.hasMoreElements()) {
            v = (Vector)enumeration.nextElement();
            int i5 = 0;
            while (i5 < v.size()) {
                d = (Dumpable)v.elementAt(i5);
                d.resetDump();
                ++i5;
            }
        }
    }

    synchronized TraceComponent register(String name) {
        TraceComponent result = (TraceComponent)this.components.get(name);
        if (result != null) {
            return result;
        }
        result = new TraceComponent(name);
        this.components.put(name, result);
        int size = this.traceEnableEvents.size();
        int i = 0;
        while (i < size) {
            TraceEnableEvent te = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (this.componentEnabled(te.getComponentName(), result.getName())) {
                result.applyTraceEnableEvent(te);
            }
            ++i;
        }
        return result;
    }

    synchronized TraceComponent register(String name, String groupName) {
        TraceComponent result = this.register(name);
        Group group = (Group)this.groups.get(groupName);
        if (group == null) {
            group = new Group(groupName);
            this.groups.put(groupName, group);
        }
        group.addComponent(result);
        int size = this.traceEnableEvents.size();
        int i = 0;
        while (i < size) {
            TraceEnableEvent te = (TraceEnableEvent)this.traceEnableEvents.elementAt(i);
            if (this.componentEnabled(te.getComponentName(), group.getName())) {
                group.applyTraceEnableEvent(te);
            }
            ++i;
        }
        return result;
    }

    synchronized void registerDumpable(TraceComponent tc, Dumpable d) {
        String componentName = tc.getName();
        Hashtable hashtable = this.dumpables;
        synchronized (hashtable) {
            Vector<Dumpable> v = (Vector<Dumpable>)this.dumpables.get(componentName);
            if (v == null) {
                v = new Vector<Dumpable>();
                this.dumpables.put(componentName, v);
            }
            if (!v.contains(d)) {
                v.addElement(d);
            }
        }
    }

    synchronized String[] getComponents() {
        String[] result = new String[this.components.size()];
        Enumeration enumeration = this.components.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            result[i++] = (String)enumeration.nextElement();
        }
        return result;
    }

    synchronized Vector getTracedGroups() {
        Vector<Group> result = new Vector<Group>();
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            Group g = (Group)this.groups.get(enumeration.nextElement());
            if (!g.isDebugEnabled() && !g.isEventEnabled() && !g.isEntryEnabled()) continue;
            result.addElement(g);
        }
        return result;
    }

    synchronized Vector getTracedComponents() {
        Vector<TraceComponent> result = new Vector<TraceComponent>();
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            TraceComponent tc = (TraceComponent)this.components.get(enumeration.nextElement());
            if (!tc.isDebugEnabled() && !tc.isEventEnabled() && !tc.isEntryEnabled()) continue;
            result.addElement(tc);
        }
        return result;
    }

    private void fireTraceEnableEvent(TraceEnableEvent event) {
        if (!event.enabled() && this.eventsThatEnableTrace == 0) {
            return;
        }
        String componentName = event.getComponentName();
        Enumeration enumGroup = this.groups.keys();
        while (enumGroup.hasMoreElements()) {
            Group gr = (Group)this.groups.get(enumGroup.nextElement());
            if (!this.componentEnabled(componentName, gr.getName())) continue;
            gr.applyTraceEnableEvent(event);
        }
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            TraceComponent tc = (TraceComponent)this.components.get(enumeration.nextElement());
            if (!this.componentEnabled(componentName, tc.getName())) continue;
            tc.applyTraceEnableEvent(event);
        }
        if (event.enabled()) {
            ++this.eventsThatEnableTrace;
        }
        int size = this.traceEnableEvents.size();
        int index = 0;
        int i = 0;
        while (i < size) {
            int type;
            boolean remove = false;
            TraceEnableEvent cachedEvent = (TraceEnableEvent)this.traceEnableEvents.elementAt(index);
            if (this.componentEnabled(componentName, cachedEvent.getComponentName()) && ((type = event.getType()) == 0 || type == cachedEvent.getType())) {
                if (cachedEvent.enabled()) {
                    --this.eventsThatEnableTrace;
                }
                remove = true;
            }
            if (remove) {
                this.traceEnableEvents.removeElementAt(index);
            } else {
                ++index;
            }
            ++i;
        }
        if (this.eventsThatEnableTrace > 0) {
            this.traceEnableEvents.addElement(event);
            svTraceEnabled = true;
        } else {
            if (this.traceEnableEvents.size() > 0) {
                this.traceEnableEvents.removeAllElements();
            }
            svTraceEnabled = false;
        }
    }

    private boolean componentEnabled(String component1Name, String component2Name) {
        if (component1Name.equals(component2Name)) {
            return true;
        }
        int length = component1Name.length();
        if (component1Name.lastIndexOf(42) == length - 1) {
            return component1Name.regionMatches(0, component2Name, 0, length - 1);
        }
        return false;
    }

    private void processNullDumpString() {
        Dumpable d;
        Vector v;
        Enumeration enumeration = this.dumpables.elements();
        while (enumeration.hasMoreElements()) {
            v = (Vector)enumeration.nextElement();
            int j = 0;
            while (j < v.size()) {
                d = (Dumpable)v.elementAt(j);
                d.dump();
                ++j;
            }
        }
        enumeration = this.dumpables.elements();
        while (enumeration.hasMoreElements()) {
            v = (Vector)enumeration.nextElement();
            int i = 0;
            while (i < v.size()) {
                d = (Dumpable)v.elementAt(i);
                d.resetDump();
                ++i;
            }
        }
    }

    static {
        traceTypeMap.put("all", new Integer(0));
        traceTypeMap.put("debug", new Integer(1));
        traceTypeMap.put("entryExit", new Integer(2));
        traceTypeMap.put("event", new Integer(3));
        traceTypeMap.put("dump", new Integer(4));
    }
}

