/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

class ExtendedTraceLogger
extends TraceLogger {
    private static final String svSpace = " ";
    private static final String svEquals = "=";
    private static final String svEqualsQuote = "=\"";
    private static final String svQuote = "\"";
    private static final String svQuoteSpace = "\" ";
    private static final String svXmlStart = "<";
    private static final String svXmlEnd = "/>";
    private static final String emptyString = "";
    private static final String svBundle = "com.ibm.ejs.resources.RasMessages";
    private String manufacturerLabel;
    private String productLabel;
    private String versionLabel;
    private String compIDLabel;
    private String processIDLabel;
    private String threadIDLabel;
    private String sourceIDLabel;
    private String classNameLabel;
    private String methodNameLabel;
    private String serverNameLabel;
    private String timeStampLabel;
    private String uowLabel;
    private String severityLabel;
    private String categoryLabel;
    private String primMessageLabel;
    private String extMessageLabel;
    private NumberFormat numberFormat;
    private int paddingCounter = 0;
    private long previousTimestamp = -1L;
    private String ivLineSep;
    private StringBuffer ivTimeBuffer = new StringBuffer();
    private StringBuffer ivNormalizeBuffer = new StringBuffer();
    ByteArrayOutputStream ivBaos = null;
    PrintStream ivPs = null;
    private boolean ivOutputXML = false;
    private Locale ivLocale;

    ExtendedTraceLogger(OutputStream stream) {
        this(stream, false, Locale.getDefault());
    }

    ExtendedTraceLogger(OutputStream stream, boolean xml, Locale locale) {
        super(stream);
        this.ivOutputXML = xml;
        this.ivLocale = locale;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMaximumIntegerDigits(6);
        this.numberFormat.setMinimumIntegerDigits(6);
        this.ivFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.ivBaos = new ByteArrayOutputStream();
        this.ivPs = new PrintStream(this.ivBaos);
        this.ivLineSep = RasHelper.getSystemProperty("line.separator");
        if (this.ivOutputXML) {
            this.manufacturerLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_MANUFAC", this.ivLocale, "Manufacturer");
            this.productLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRODUCT", this.ivLocale, "Product");
            this.versionLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_VERSION", this.ivLocale, "Version");
            this.compIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_COMPID", this.ivLocale, "ComponentId");
            this.processIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PROCESSID", this.ivLocale, "ProcessId");
            this.threadIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADID", this.ivLocale, "ThreadId");
            this.sourceIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SOURCEID", this.ivLocale, "SourceId");
            this.classNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CLASSNAME", this.ivLocale, "ClassName");
            this.methodNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_METHODNAME", this.ivLocale, "MethodName");
            this.serverNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SERVNAME", this.ivLocale, "ServerName");
            this.timeStampLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_TIMESTMP", this.ivLocale, "TimeStamp");
            this.uowLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_UOW", this.ivLocale, "UnitOfWork");
            this.severityLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SEVERITY", this.ivLocale, "Severity");
            this.categoryLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CATEGORY", this.ivLocale, "Category");
            this.primMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRIMMSG", this.ivLocale, "PrimaryMessage");
            this.extMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_EXTMSG", this.ivLocale, "ExtendedMessage");
        } else {
            this.manufacturerLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_MANUFAC", this.ivLocale, "Manufacturer") + ":\t ";
            this.productLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRODUCT", this.ivLocale, "Product") + ":\t ";
            this.versionLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_VERSION", this.ivLocale, "Version") + ":\t ";
            this.compIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_COMPID", this.ivLocale, "ComponentId") + ":\t ";
            this.processIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PROCESSID", this.ivLocale, "ProcessId") + ":\t ";
            this.threadIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADID", this.ivLocale, "ThreadId") + ":\t ";
            this.sourceIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SOURCEID", this.ivLocale, "SourceId") + ":\t ";
            this.classNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CLASSNAME", this.ivLocale, "ClassName") + ":\t ";
            this.methodNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_METHODNAME", this.ivLocale, "MethodName") + ":\t ";
            this.serverNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SERVNAME", this.ivLocale, "ServerName") + ":\t ";
            this.timeStampLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_TIMESTMP", this.ivLocale, "TimeStamp") + ":\t ";
            this.uowLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_UOW", this.ivLocale, "UnitOfWork") + ":\t ";
            this.severityLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SEVERITY", this.ivLocale, "Severity") + ":\t ";
            this.categoryLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CATEGORY", this.ivLocale, "Category") + ":\t ";
            this.primMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRIMMSG", this.ivLocale, "PrimaryMessage") + ":\t ";
            this.extMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_EXTMSG", this.ivLocale, "ExtendedMessage") + ": ";
        }
    }

    void printHeader() {
        String a = this.ivLocale.getLanguage();
        String b = this.ivLocale.getCountry();
        String c = RasHelper.getSystemProperty("file.encoding");
        if (this.ivOutputXML) {
            this.ivOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.ivOut.println("<WASActivityLogFile>");
            this.ivOut.println("<encoding language=\"" + a + "_" + b + svQuoteSpace + "codeset=\"" + c + svQuote + svXmlEnd);
        } else {
            this.ivOut.println("$LANG = " + a + "_" + b);
            this.ivOut.println("$CODESET = " + c);
        }
    }

    void printFooter(int numberOfMessages) {
        String number = Integer.toString(numberOfMessages);
        if (this.ivOutputXML) {
            this.ivOut.println("<total records=\"" + number + svQuote + svXmlEnd);
            this.ivOut.println("</WASActivityLogFile>");
        } else {
            this.ivOut.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG006", this.ivLocale, new Object[]{number}, "{0} records found and printed."));
        }
    }

    synchronized void logMessage(MessageEvent event) {
        if (event == null) {
            return;
        }
        String primaryMessage = event.getLocalizedMessage(this.ivLocale);
        if (this.ivOutputXML) {
            this.ivOut.println(this.formatMessageInXML(primaryMessage, event));
        } else {
            this.ivOut.println(this.formatEntryHeader(event));
            this.ivOut.println(this.primMessageLabel + primaryMessage);
            this.ivOut.println(this.formatEntryTrailer(event));
        }
    }

    synchronized void logTrace(TraceEvent event) {
        if (event == null) {
            return;
        }
        String[] strings = event.getStrs();
        String primaryMessage = strings[0];
        int numberParms = strings.length - 1;
        int i = 0;
        while (i < numberParms) {
            primaryMessage = primaryMessage.concat(svSpace).concat(strings[i]);
            ++i;
        }
        if (this.ivOutputXML) {
            this.ivOut.println(this.formatMessageInXML(primaryMessage, event));
        } else {
            this.ivOut.println(this.formatEntryHeader(event));
            this.ivOut.println(this.primMessageLabel + primaryMessage);
            this.ivOut.println(this.formatEntryTrailer(event));
        }
    }

    synchronized void logSystemStream(StreamEvent event) {
        if (event == null) {
            return;
        }
        if (this.ivOutputXML) {
            this.ivBaos.reset();
            event.writeDataToStream(this.ivPs, true);
            this.ivPs.flush();
            String primaryMessage = this.ivBaos.toString();
            this.ivOut.println(this.formatMessageInXML(primaryMessage, event));
        } else {
            this.ivOut.println(this.formatEntryHeader(event));
            this.ivOut.print(this.primMessageLabel);
            event.writeDataToStream(this.ivOut, true);
            this.ivOut.println(this.formatEntryTrailer(event));
        }
    }

    private String formatEntryHeader(RasEvent event) {
        String methodName = emptyString;
        String unitOfWork = emptyString;
        String eventSource = emptyString;
        String datePadding = "000000";
        String component = emptyString;
        String organization = emptyString;
        String product = emptyString;
        String processId = emptyString;
        String className = emptyString;
        if (event.ivClassName != null) {
            className = event.ivClassName;
        }
        if (event.ivMethodName != null) {
            methodName = event.ivMethodName;
        }
        if (event.ivUnitOfWork != null) {
            unitOfWork = event.ivUnitOfWork;
        }
        if (event.ivEventSource != null) {
            eventSource = event.ivEventSource;
        }
        if (event.ivComponent != null) {
            component = event.ivComponent;
        }
        if (event.ivOrganization != null) {
            organization = event.ivOrganization;
        }
        if (event.ivProduct != null) {
            product = event.ivProduct;
        }
        if (event.ivProcessId != null) {
            processId = event.ivProcessId;
        }
        if (event.ivTimeStamp == this.previousTimestamp) {
            ++this.paddingCounter;
            datePadding = this.numberFormat.format(this.paddingCounter);
        } else {
            this.previousTimestamp = event.ivTimeStamp;
            this.paddingCounter = 0;
        }
        this.ivBuffer.setLength(0);
        this.ivBuffer.append("---------------------------------------------------------------");
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.compIDLabel);
        this.ivBuffer.append(component);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.processIDLabel);
        this.ivBuffer.append(processId);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.threadIDLabel);
        this.ivBuffer.append(event.ivThreadId);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.sourceIDLabel);
        this.ivBuffer.append(eventSource);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.classNameLabel);
        this.ivBuffer.append(className);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.methodNameLabel);
        this.ivBuffer.append(methodName);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.manufacturerLabel);
        this.ivBuffer.append(organization);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.productLabel);
        this.ivBuffer.append(product);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.versionLabel);
        this.ivBuffer.append(event.ivVersion);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.serverNameLabel);
        this.ivBuffer.append(event.ivServerName);
        this.ivBuffer.append(this.ivLineSep);
        this.ivDate.setTime(event.ivTimeStamp);
        this.ivTimeBuffer.setLength(0);
        this.ivTimeBuffer = this.ivFormatter.format(this.ivDate, this.ivTimeBuffer, this.ivFieldPos);
        this.ivBuffer.append(this.timeStampLabel);
        this.ivBuffer.append(this.ivTimeBuffer.toString() + datePadding);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.uowLabel);
        this.ivBuffer.append(unitOfWork);
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.severityLabel);
        this.ivBuffer.append(ExtendedTraceLogger.getSeverity(event.ivType));
        this.ivBuffer.append(this.ivLineSep);
        this.ivBuffer.append(this.categoryLabel);
        this.ivBuffer.append(RasEvent.getTypeString(event.ivType));
        return this.ivBuffer.toString();
    }

    private String formatEntryTrailer(RasEvent event) {
        String extendedMessage = emptyString;
        if (event.ivExtendedMessage != null && event.ivExtendedMessage.compareTo(emptyString) != 0) {
            extendedMessage = event.ivExtendedMessage;
        }
        return this.extMessageLabel + extendedMessage;
    }

    private String formatMessageInXML(String primaryMessage, RasEvent event) {
        String methodName = emptyString;
        String unitOfWork = emptyString;
        String eventSource = emptyString;
        String datePadding = "000000";
        String component = emptyString;
        String organization = emptyString;
        String product = emptyString;
        String processId = emptyString;
        String className = emptyString;
        primaryMessage = this.normalize(primaryMessage);
        if (event.ivClassName != null) {
            className = this.normalize(event.ivClassName);
        }
        if (event.ivMethodName != null) {
            methodName = this.normalize(event.ivMethodName);
        }
        if (event.ivUnitOfWork != null) {
            unitOfWork = this.normalize(event.ivUnitOfWork);
        }
        if (event.ivEventSource != null) {
            eventSource = this.normalize(event.ivEventSource);
        }
        if (event.ivComponent != null) {
            component = this.normalize(event.ivComponent);
        }
        if (event.ivOrganization != null) {
            organization = this.normalize(event.ivOrganization);
        }
        if (event.ivProduct != null) {
            product = this.normalize(event.ivProduct);
        }
        if (event.ivProcessId != null) {
            processId = this.normalize(event.ivProcessId);
        }
        if (event.ivTimeStamp == this.previousTimestamp) {
            ++this.paddingCounter;
            datePadding = this.numberFormat.format(this.paddingCounter);
        } else {
            this.previousTimestamp = event.ivTimeStamp;
            this.paddingCounter = 0;
        }
        String extendedMessage = emptyString;
        if (event.ivExtendedMessage != null && event.ivExtendedMessage.compareTo(emptyString) != 0) {
            extendedMessage = this.normalize(event.ivExtendedMessage);
        }
        this.ivBuffer.setLength(0);
        this.ivBuffer.append("<WASActivityLogEntry");
        this.ivBuffer.append(svSpace);
        this.ivBuffer.append(this.compIDLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(component);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.processIDLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(processId);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.threadIDLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(event.ivThreadId);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.sourceIDLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(eventSource);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.classNameLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(className);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.methodNameLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(methodName);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.manufacturerLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(organization);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.productLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(product);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.versionLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(this.normalize(event.ivVersion));
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.serverNameLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(this.normalize(event.ivServerName));
        this.ivBuffer.append(svQuoteSpace);
        this.ivDate.setTime(event.ivTimeStamp);
        this.ivTimeBuffer.setLength(0);
        this.ivTimeBuffer = this.ivFormatter.format(this.ivDate, this.ivTimeBuffer, this.ivFieldPos);
        this.ivBuffer.append(this.timeStampLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(this.ivTimeBuffer.toString() + datePadding);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.uowLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(unitOfWork);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.severityLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(ExtendedTraceLogger.getSeverity(event.ivType));
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.categoryLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(RasEvent.getTypeString(event.ivType));
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.primMessageLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(primaryMessage);
        this.ivBuffer.append(svQuoteSpace);
        this.ivBuffer.append(this.extMessageLabel);
        this.ivBuffer.append(svEqualsQuote);
        this.ivBuffer.append(extendedMessage);
        this.ivBuffer.append(svQuote);
        this.ivBuffer.append(svXmlEnd);
        return this.ivBuffer.toString();
    }

    private String normalize(String string) {
        int length = string.length();
        this.ivNormalizeBuffer.setLength(0);
        int counter = 0;
        while (counter < length) {
            char character = string.charAt(counter);
            if (character == '<') {
                this.ivNormalizeBuffer.append("&lt;");
            } else if (character == '>') {
                this.ivNormalizeBuffer.append("&gt;");
            } else if (character == '&') {
                this.ivNormalizeBuffer.append("&amp;");
            } else if (character == '\"') {
                this.ivNormalizeBuffer.append("&quot;");
            } else if (character == '\'') {
                this.ivNormalizeBuffer.append("&apos;");
            } else {
                this.ivNormalizeBuffer.append(character);
            }
            ++counter;
        }
        return this.ivNormalizeBuffer.toString();
    }

    private static int getSeverity(int type) {
        int severity;
        switch (type) {
            case 4: 
            case 8: {
                severity = 1;
                break;
            }
            case 9: 
            case 10: {
                severity = 2;
                break;
            }
            default: {
                severity = 3;
            }
        }
        return severity;
    }
}

