/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBuffLogger;
import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogWriter;
import com.ibm.ejs.ras.SystemErrStream;
import com.ibm.ejs.ras.SystemOutStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceElement;
import com.ibm.ejs.ras.TraceEventGenerator;
import com.ibm.ejs.ras.TraceEventListener;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import com.ibm.websphere.ras.TraceElementState;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class ManagerAdmin {
    private static TraceComponent svTc = Tr.register(class$com$ibm$ejs$ras$ManagerAdmin == null ? (class$com$ibm$ejs$ras$ManagerAdmin = ManagerAdmin.class$("com.ibm.ejs.ras.ManagerAdmin")) : class$com$ibm$ejs$ras$ManagerAdmin, null, "com.ibm.ejs.resources.RasMessages");
    static final byte DUMP = 0;
    public static final byte DEBUG = 1;
    public static final byte ENTRY_EXIT = 2;
    public static final byte EVENT = 4;
    public static final byte ALL = 7;
    public static final String BASIC = "basic";
    public static final String ADVANCED = "advanced";
    public static final String LOGANALYZER = "loganalyzer";
    public static final String stdout = "stdout";
    public static final String file = "named file";
    public static final String ringBuffer = "ringbuffer";
    public static final int RING_BUFFER_MIN_SIZE = 1;
    public static final int RING_BUFFER_DEFAULT_SIZE = 8;
    public static final int SERVICE_LOG_MIN_SIZE = 2;
    public static final int SERVICE_LOG_DEFAULT_SIZE = 1024;
    public static final int SERVICE_LOG_MAX_SIZE = 0x100000;
    public static final String none = "none";
    public static final String audit = "audit";
    public static final String service = "service";
    public static final String warning = "warning";
    public static final String sysOut = "SystemOut";
    public static final String sysErr = "SystemErr";
    static final String enabled = "enabled";
    static final String disabled = "disabled";
    private static final String svBundle = "com.ibm.ejs.resources.RasMessages";
    private static boolean svTracingToFile;
    private static boolean svTraceIsEnabled;
    private static CBuffLogger svCbuff;
    private static TraceLogger svTraceFileListener;
    private static String svTraceFileName;
    private static long svRolloverSize;
    private static int svMaxBackups;
    private static WrappingFileOutputStream svTraceFileStream;
    private static boolean svHeaderPrinted;
    private static boolean svTraceConfigured;
    private static boolean svLoggingConfigured;
    static /* synthetic */ Class class$com$ibm$ejs$ras$ManagerAdmin;

    private ManagerAdmin() {
    }

    public static synchronized void configureMessageLogging(boolean serviceLogEnabled, String serviceLogName, int serviceLogSize, String messageFilterLevel, boolean enableCorrelationId) {
        if (!RasHelper.isServer()) {
            return;
        }
        if (svLoggingConfigured) {
            return;
        }
        svLoggingConfigured = true;
        RasProperties.setMessageFilterLevelProperty(messageFilterLevel);
        RasProperties.setUnitOfWorkProperty(enableCorrelationId);
        if (!serviceLogEnabled) {
            Tr.audit(svTc, "MSG_SHARED_LOG_DISABLED");
        } else {
            try {
                String name = RasHelper.generateOutputFileName(serviceLogName, "ActivityLog", svTc);
                RasProperties.setActivityLogName(serviceLogName);
                RasProperties.setActivityLogSize(serviceLogSize);
                try {
                    SharedLogWriter activityLog = SharedLogWriter.getInstance();
                    if (activityLog != null) {
                        Tr.addTraceEventListener(activityLog);
                    }
                }
                catch (Throwable t) {}
            }
            catch (RasException re) {
                Tr.error(svTc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{serviceLogName, re});
            }
        }
    }

    public static synchronized void configureServerTrace(String traceSpec, String traceOutput, String fileName, long rollover, int maxBackups, int ringBufferSize, String traceFormat) {
        if (!RasHelper.isServer()) {
            return;
        }
        if (svTraceConfigured) {
            return;
        }
        svTraceConfigured = true;
        SystemOutStream.initialize();
        Tr.getComponentManager().processTraceString(traceSpec, true);
        traceFormat = RasProperties.setTraceFormatProperty(traceFormat);
        svTraceIsEnabled = ComponentManager.svTraceEnabled;
        if (traceOutput.equals(file)) {
            ManagerAdmin.addServerTraceFileListener(fileName, rollover, maxBackups);
        } else {
            ManagerAdmin.addServerRingBufferListener(ringBufferSize);
        }
        Tr.info(svTc, "MSG_INITIAL_TRACE_STATE", Tr.getComponentManager().getTraceSpecification());
    }

    public static synchronized void configureClientTrace(String traceSpec, String traceOutput, String fileName, boolean truncateTraceFile, String traceFormat, boolean enableCorrelationId) {
        block6: {
            if (RasHelper.isServer()) {
                return;
            }
            if (svTraceConfigured) {
                return;
            }
            svTraceConfigured = true;
            Tr.getComponentManager().processTraceString(traceSpec, true);
            traceFormat = RasProperties.setTraceFormatProperty(traceFormat);
            RasProperties.setUnitOfWorkProperty(enableCorrelationId);
            try {
                if (traceOutput.equals(file)) {
                    ManagerAdmin.openClientTraceFile(fileName, truncateTraceFile);
                } else {
                    TraceLogger tl = ManagerAdmin.createListener(Tr.getSystemOut());
                    tl.printHeader();
                    Tr.addTraceEventListener(tl);
                    svTracingToFile = false;
                }
            }
            catch (Throwable t) {
                TraceLogger tl = ManagerAdmin.createListener(Tr.getSystemOut());
                tl.printHeader();
                Tr.addTraceEventListener(tl);
                svTracingToFile = false;
                if (traceOutput == null || !traceOutput.equals(file)) break block6;
                Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{fileName, t});
                Tr.info(svTc, "MSG_TRACE_TO_SYSOUT");
            }
        }
        Tr.info(svTc, "MSG_INITIAL_TRACE_STATE", Tr.getComponentManager().getTraceSpecification());
    }

    public static void addJmxListener(TraceEventListener listener) throws RasException {
        if (listener == null) {
            throw new RasException("A null JMX listener is not allowed");
        }
        Tr.addJmxListener(listener);
    }

    public static void setTraceEventGenerator(TraceEventGenerator teg) {
        Tr.setTraceEventGenerator(teg);
    }

    public static String getTraceFileName() {
        if (svTracingToFile) {
            return svTraceFileName;
        }
        return null;
    }

    public static String getTraceSpecification() {
        return Tr.getComponentManager().getTraceSpecification();
    }

    public static String getTraceSpecification(String component) {
        return Tr.getComponentManager().getTraceSpecification(component);
    }

    public static void setTraceState(String traceString) {
        Tr.getComponentManager().processTraceString(traceString, true);
        ManagerAdmin.processTraceStateChanged();
        Tr.info(svTc, "MSG_TRACE_STATE_CHANGED", Tr.getComponentManager().getTraceSpecification());
    }

    public static void appendTraceString(String traceString) {
        Tr.getComponentManager().processTraceString(traceString, false);
        ManagerAdmin.processTraceStateChanged();
        Tr.info(svTc, "MSG_TRACE_STATE_CHANGED", Tr.getComponentManager().getTraceSpecification());
    }

    public static synchronized int getRingBufferSize() {
        if (svCbuff == null) {
            return 0;
        }
        return svCbuff.getSize();
    }

    public static synchronized void setRingBufferSize(int size) {
        if (svCbuff == null) {
            return;
        }
        svCbuff.setSize(size);
    }

    public static void dumpRingBuffer(String fileToWriteTo) {
        if (svCbuff == null) {
            return;
        }
        try {
            svCbuff.dump(fileToWriteTo);
        }
        catch (RasException rasException) {
            // empty catch block
        }
    }

    public static void clearRingBuffer() {
        if (svCbuff != null) {
            svCbuff.clear();
        }
    }

    public static String[] listAllRegisteredComponents() {
        return Tr.getComponentManager().getComponents();
    }

    public static String[] listAllRegisteredGroups() {
        return Tr.getComponentManager().getGroups();
    }

    public static String[] listComponentsInGroup(String group) {
        return Tr.getComponentManager().getGroupComponents(group);
    }

    public static TraceElementState[] getTracedComponents() {
        Vector elements = Tr.getComponentManager().getTracedComponents();
        int size = elements.size();
        TraceElementState[] results = new TraceElementState[size];
        int i = 0;
        while (i < size) {
            TraceElementState tes;
            TraceElement te = (TraceElement)elements.elementAt(i);
            results[i] = tes = new TraceElementState(te);
            ++i;
        }
        return results;
    }

    public static TraceElementState[] getTracedGroups() {
        Vector elements = Tr.getComponentManager().getTracedGroups();
        int size = elements.size();
        TraceElementState[] results = new TraceElementState[size];
        int i = 0;
        while (i < size) {
            TraceElementState tes;
            TraceElement te = (TraceElement)elements.elementAt(i);
            results[i] = tes = new TraceElementState(te);
            ++i;
        }
        return results;
    }

    public static void processDumpString(String dumpString) {
        Tr.getComponentManager().processDumpString(dumpString);
    }

    public static synchronized void setTraceOutputToFile(String fileName, long rollover, int maxBackups, String traceFormat) throws RasException {
        if (!svTraceConfigured) {
            throw new RasException("Trace must be configured before it can be changed");
        }
        traceFormat = RasProperties.setTraceFormatProperty(traceFormat);
        if (svTracingToFile) {
            ManagerAdmin.removeServerTraceFileListener();
        } else {
            ManagerAdmin.removeServerRingBufferListener();
        }
        ManagerAdmin.addServerTraceFileListener(fileName, rollover, maxBackups);
        svHeaderPrinted = false;
    }

    public static synchronized void setTraceOutputToRingBuffer(int ringBufferSize, String traceFormat) throws RasException {
        if (!svTraceConfigured) {
            throw new RasException("Trace must be configured before it can be changed");
        }
        traceFormat = RasProperties.setTraceFormatProperty(traceFormat);
        if (svTracingToFile) {
            ManagerAdmin.removeServerTraceFileListener();
            ManagerAdmin.addServerRingBufferListener(ringBufferSize);
        } else {
            ManagerAdmin.setRingBufferSize(ringBufferSize);
        }
    }

    public static void checkTraceString(String traceString) throws MalformedTraceStringException {
        String msg = null;
        if ((traceString = RasHelper.peelQuotes(traceString)) == null) {
            return;
        }
        if (traceString.equals("")) {
            msg = TraceNLS.getStringFromBundle(svBundle, "EXCEPTION_EMPTY_STRING_TRACESTRING", "Empty string is not part of trace string grammar");
            throw new MalformedTraceStringException(msg);
        }
        String[] components = RasHelper.split(traceString, 58);
        String comp = null;
        int i = 0;
        while (i < components.length) {
            String typeList;
            if (components[i].equals("")) {
                msg = TraceNLS.getStringFromBundle(svBundle, "EXCEPTION_EMPTY_STRING_SUBTRACESTRING", "empty string encountered - remove extra colon");
                throw new MalformedTraceStringException(msg);
            }
            int endCompNameIndex = components[i].indexOf(61);
            if (endCompNameIndex == -1) {
                msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_NO_VALUE_PAIRS", new Object[]{components[i]}, "No type=state value pair(s) found at ''{0}''");
                throw new MalformedTraceStringException(msg);
            }
            comp = components[i].substring(0, endCompNameIndex);
            if (comp.equals("")) {
                msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_NO_COMPONENT_NAME", new Object[]{components[i]}, "No component name found at ''{0}''");
                throw new MalformedTraceStringException(msg);
            }
            if ((typeList = components[i].substring(++endCompNameIndex)).equals("")) {
                msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_NO_VALUE_PAIRS", new Object[]{components[i]}, "No type=state value pair(s) found at ''{0}''");
                throw new MalformedTraceStringException(msg);
            }
            String[] types = RasHelper.split(typeList, 44);
            int j = 0;
            while (j < types.length) {
                if (types[j].equals("")) {
                    msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_MISSING_VALUE_PAIR", new Object[]{components[i]}, "Missing type=state value pair at ''{0}'', remove extra comma");
                    throw new MalformedTraceStringException(msg);
                }
                String[] pieces = RasHelper.split(types[j], 61);
                if (pieces.length > 2) {
                    msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_INVALID_VALUE_PAIR", new Object[]{types[j], components[i]}, "Invalid type=state value pair - ''{0}'' at ''{1}''");
                    throw new MalformedTraceStringException(msg);
                }
                if (pieces.length == 1) {
                    msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_MISSING_STATE", new Object[]{components[i]}, "Missing state value at ''{0}''");
                    throw new MalformedTraceStringException(msg);
                }
                String type = pieces[0];
                if (type.equals("")) {
                    msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_MISSING_TYPE", new Object[]{components[i]}, "Missing type value at ''{0}''");
                    throw new MalformedTraceStringException(msg);
                }
                if (!(type.equals("all") || type.equals("event") || type.equals("debug") || type.equals("entryExit") || type.equals("dump"))) {
                    msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_INVALID_TYPE", new Object[]{type, components[i]}, "Invalid type value - ''{0}'' at ''{1}''");
                    throw new MalformedTraceStringException(msg);
                }
                String state = pieces[1];
                if (state.equals("")) {
                    msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_MISSING_STATE", new Object[]{components[i]}, "Missing state value at ''{0}''");
                    throw new MalformedTraceStringException(msg);
                }
                if (!state.equalsIgnoreCase(enabled) && !state.equalsIgnoreCase(disabled)) {
                    msg = TraceNLS.getFormattedMessage(svBundle, "EXCEPTION_INVALID_STATE", new Object[]{state, components[i]}, "Invalid state value - ''{0}'' at ''{1}''");
                    throw new MalformedTraceStringException(msg);
                }
                ++j;
            }
            ++i;
        }
    }

    public static String rolloverLogFileImmediate(String streamName, String fileName) throws RasException {
        if (streamName == null) {
            throw new RasException("invalid stream indicator of null specified");
        }
        if (streamName.equals(sysOut)) {
            return SystemOutStream.rolloverLogFileImmediate(fileName);
        }
        if (streamName.equals(sysErr)) {
            return SystemErrStream.rolloverLogFileImmediate(fileName);
        }
        throw new RasException("specified stream name of " + streamName + " is invalid or unsupported");
    }

    public static boolean isLogFileWriteable(String fileName) {
        try {
            RasHelper.validateFileName(fileName.trim());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static TraceLogger createListener(OutputStream stream) {
        if (RasProperties.svTraceFormat.equalsIgnoreCase(LOGANALYZER)) {
            return new ExtendedTraceLogger(stream);
        }
        if (RasProperties.svTraceFormat.equalsIgnoreCase(ADVANCED)) {
            return new TraceLogger(stream, false);
        }
        return new TraceLogger(stream, true);
    }

    private static synchronized void addServerRingBufferListener(int size) {
        if (svCbuff != null) {
            return;
        }
        svCbuff = size < 1 ? new CBuffLogger(8) : new CBuffLogger(size);
        Tr.addTraceEventListener(svCbuff);
        svTracingToFile = false;
    }

    private static synchronized void removeServerRingBufferListener() {
        if (svCbuff == null) {
            return;
        }
        Tr.removeTraceEventListener(svCbuff);
        svCbuff = null;
    }

    private static synchronized void addServerTraceFileListener(String fileName, long rollover, int maxBackups) {
        try {
            svTraceFileName = RasHelper.generateOutputFileName(fileName, "TraceFile", svTc);
        }
        catch (Throwable t) {
            Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{fileName, t});
            Tr.info(svTc, "MSG_TRACE_TO_RING_BUFFER");
            ManagerAdmin.addServerRingBufferListener(8);
            svTracingToFile = false;
            return;
        }
        svRolloverSize = rollover;
        svMaxBackups = maxBackups;
        svTracingToFile = true;
        if (svTraceIsEnabled) {
            ManagerAdmin.openServerTraceFile();
        }
    }

    private static synchronized void removeServerTraceFileListener() {
        if (svTraceFileListener != null) {
            Tr.removeTraceEventListener(svTraceFileListener);
            svTraceFileListener = null;
        }
        ManagerAdmin.closeServerTraceFile();
    }

    private static synchronized void openServerTraceFile() {
        try {
            svTraceFileStream = new WrappingFileOutputStream(svTraceFileName, svMaxBackups, svRolloverSize);
            svTraceFileListener = ManagerAdmin.createListener(svTraceFileStream);
            svTraceFileStream.addRolloverListener(svTraceFileListener);
            if (!svHeaderPrinted) {
                svTraceFileListener.printHeader();
                svHeaderPrinted = true;
            }
            Tr.addTraceEventListener(svTraceFileListener);
        }
        catch (Throwable t) {
            Tr.error(svTc, "MSG_OPEN_TRACE_FILE_FAILED", new Object[]{svTraceFileName, t});
            Tr.info(svTc, "MSG_TRACE_TO_RING_BUFFER");
            ManagerAdmin.addServerRingBufferListener(8);
            svTracingToFile = false;
            svTraceFileListener = null;
            ManagerAdmin.closeServerTraceFile();
        }
    }

    private static synchronized void closeServerTraceFile() {
        if (svTraceFileStream != null) {
            try {
                svTraceFileStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            svTraceFileStream = null;
        }
    }

    private static synchronized void openClientTraceFile(String fileName, boolean truncate) throws RasException, IOException {
        svTraceFileName = fileName.trim();
        RasHelper.validateFileName(svTraceFileName);
        FileOutputStream stream = RasHelper.createFileOutputStream(svTraceFileName, !truncate);
        svTraceFileListener = ManagerAdmin.createListener(stream);
        svTraceFileListener.printHeader();
        Tr.addTraceEventListener(svTraceFileListener);
        svTracingToFile = true;
    }

    private static synchronized void processTraceStateChanged() {
        if (svTraceIsEnabled == ComponentManager.svTraceEnabled) {
            return;
        }
        if (!svTraceConfigured) {
            return;
        }
        if (RasHelper.isServer() && svTracingToFile) {
            if (svTraceIsEnabled) {
                ManagerAdmin.removeServerTraceFileListener();
            } else {
                ManagerAdmin.openServerTraceFile();
            }
        }
        svTraceIsEnabled = ComponentManager.svTraceEnabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        svTraceIsEnabled = false;
        svCbuff = null;
        svTraceFileListener = null;
        svTraceFileName = null;
        svTraceFileStream = null;
        svHeaderPrinted = false;
        svTraceConfigured = false;
        svLoggingConfigured = false;
    }
}

