/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ejs.ras.Untraceable;
import com.ibm.websphere.ras.RasMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Locale;

public class MessageEvent
extends RasEvent
implements RasMessage {
    private static final int svClassVersion = 2;
    private int ivClassVersion = 2;
    String ivBundleName;
    private Object[] ivMsgParms;
    private transient String tivFormattedMessage = null;
    static /* synthetic */ Class class$java$lang$Object;

    public MessageEvent(int type, TraceComponent tc, String msgKey, String msgFile, Object msgParms, String organization, String product, String component, String className, String methodName, String extendedMessage) {
        super(type, tc, className, methodName, msgKey, organization, product, component, extendedMessage, true);
        this.ivBundleName = msgFile;
        this.convertParameters(msgParms);
        this.tivFormattedMessage = this.getLocalizedMessage(Locale.getDefault());
    }

    MessageEvent(int type, TraceComponent tc, String methodName, String msgKey, Object msgParms) {
        super(type, tc, null, methodName, msgKey, "IBM", "WebSphere", "Application Server", null, false);
        this.ivBundleName = tc.getResourceBundleName();
        this.convertParameters(msgParms);
        this.tivFormattedMessage = this.getLocalizedMessage(Locale.getDefault());
    }

    MessageEvent() {
    }

    public String getMessageSeverity() {
        switch (this.ivType) {
            case 1: {
                return "Audit";
            }
            case 4: {
                return "Error";
            }
            case 8: {
                return "Fatal";
            }
            case 9: {
                return "Service";
            }
            case 10: {
                return "Warning";
            }
            case 11: {
                return "Informational";
            }
        }
        return "Unknown";
    }

    public String getMessageKey() {
        return this.ivMsgKey;
    }

    public String getResourceBundleName() {
        return this.ivBundleName;
    }

    public String getMessageOriginator() {
        return this.ivEventSource;
    }

    public String getLocalizedMessage(Locale locale) {
        if (this.ivBundleName == null) {
            StringBuffer sb = new StringBuffer(this.ivMsgKey);
            if (this.ivMsgParms != null) {
                int length = this.ivMsgParms.length;
                int i = 0;
                while (i < length) {
                    sb.append(" ");
                    sb.append(this.ivMsgParms[i].toString());
                    ++i;
                }
            }
            return new String(sb);
        }
        String key = this.ivMsgKey.replace(' ', '.');
        if (this.ivMsgParms == null) {
            return TraceNLS.getStringFromBundle(this.ivBundleName, key, locale, this.ivMsgKey);
        }
        return TraceNLS.getFormattedMessage(this.ivBundleName, key, locale, this.ivMsgParms, this.ivMsgKey);
    }

    public String formatBasic(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        this.formatHeaderBasic(buffer, formatter, date, fPos);
        buffer.append(this.tivFormattedMessage);
        if (this.ivExtendedMessage != null) {
            buffer.append(RasEvent.lineSeparator);
            buffer.append(RasEvent.svBasicPadding);
            buffer.append(this.ivExtendedMessage);
        }
        return new String(buffer);
    }

    public String formatAdvanced(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        this.formatHeaderAdvanced(buffer, formatter, date, fPos);
        buffer.append(RasEvent.lineSeparator);
        buffer.append(RasEvent.svAdvancedPadding);
        buffer.append(this.tivFormattedMessage);
        if (this.ivExtendedMessage != null) {
            buffer.append(RasEvent.lineSeparator);
            buffer.append(RasEvent.svAdvancedPadding);
            buffer.append(this.ivExtendedMessage);
        }
        return new String(buffer);
    }

    final Object[] getMessageInserts() {
        return this.ivMsgParms;
    }

    private void convertParameters(Object msgParms) {
        if (msgParms == null) {
            this.ivMsgParms = null;
            return;
        }
        Object[] objs = null;
        Class<?> objectClass = msgParms.getClass();
        objs = objectClass.isArray() ? ((class$java$lang$Object == null ? (class$java$lang$Object = MessageEvent.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(objectClass.getComponentType()) ? (Object[])msgParms : RasHelper.primitiveArrayToString(msgParms)) : new Object[]{msgParms};
        int numObjs = objs.length;
        this.ivMsgParms = new Object[numObjs];
        String param = null;
        int i = numObjs - 1;
        while (i >= 0) {
            if (objs[i] == null) {
                this.ivMsgParms[i] = "<null>";
            } else if (objs[i] instanceof String) {
                this.ivMsgParms[i] = objs[i];
            } else if (objs[i] instanceof Number || objs[i] instanceof Date) {
                this.ivMsgParms[i] = objs[i];
            } else {
                try {
                    param = objs[i] instanceof Untraceable ? objs[i].getClass().getName() : (objs[i] instanceof Traceable ? ((Traceable)objs[i]).toTraceString() : (objs[i] instanceof Throwable ? RasHelper.throwableToString((Throwable)objs[i]) : objs[i].toString()));
                    if (param == null) {
                        param = "<malformed parameter>";
                    }
                    this.ivMsgParms[i] = param;
                }
                catch (Throwable t) {
                    this.ivMsgParms[i] = "<malformed parameter>";
                }
            }
            --i;
        }
    }

    void writeToStream(DataOutputStream dos) throws IOException {
        dos.writeInt(this.ivClassVersion);
        if (this.ivOrganization == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivOrganization);
        }
        if (this.ivProduct == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivProduct);
        }
        if (this.ivComponent == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivComponent);
        }
        dos.writeUTF(this.ivVersion);
        if (this.ivEventSource == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivEventSource);
        }
        if (this.ivMethodName == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivMethodName);
        }
        dos.writeUTF(this.ivThreadId);
        if (this.ivProcessId == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivProcessId);
        }
        dos.writeUTF(this.ivServerName);
        if (this.ivMsgKey == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivMsgKey);
        }
        if (this.ivBundleName == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivBundleName);
        }
        if (this.ivExtendedMessage == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivExtendedMessage);
        }
        if (this.ivUnitOfWork == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivUnitOfWork);
        }
        dos.writeLong(this.ivTimeStamp);
        dos.writeInt(this.ivType);
        if (this.ivMsgParms == null) {
            dos.writeInt(0);
        } else {
            int numberOfParms = this.ivMsgParms.length;
            dos.writeInt(numberOfParms);
            int i = 0;
            while (i < numberOfParms) {
                dos.writeUTF(this.ivMsgParms[i].toString());
                ++i;
            }
        }
        if (this.ivRawData == null) {
            dos.writeInt(0);
        } else {
            int rawDataLength = this.ivRawData.length;
            dos.writeInt(rawDataLength);
            dos.write(this.ivRawData, 0, rawDataLength);
        }
        if (this.ivClassName == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.ivClassName);
        }
    }

    void readFromStream(DataInputStream dis) throws IOException {
        this.ivClassVersion = dis.readInt();
        this.ivOrganization = dis.readUTF();
        this.ivProduct = dis.readUTF();
        this.ivComponent = dis.readUTF();
        this.ivVersion = dis.readUTF();
        this.ivEventSource = dis.readUTF();
        this.ivMethodName = dis.readUTF();
        this.ivThreadId = dis.readUTF();
        this.ivProcessId = dis.readUTF();
        this.ivServerName = dis.readUTF();
        this.ivMsgKey = dis.readUTF();
        this.ivBundleName = dis.readUTF();
        this.ivExtendedMessage = dis.readUTF();
        this.ivUnitOfWork = dis.readUTF();
        this.ivTimeStamp = dis.readLong();
        this.ivType = dis.readInt();
        int numberOfParms = dis.readInt();
        if (numberOfParms == 0) {
            this.ivMsgParms = null;
        } else {
            this.ivMsgParms = new Object[numberOfParms];
            int i = 0;
            while (i < numberOfParms) {
                String parm = dis.readUTF();
                this.ivMsgParms[i] = parm;
                ++i;
            }
        }
        int rawDataLength = dis.readInt();
        if (rawDataLength == 0) {
            this.ivRawData = null;
        } else {
            this.ivRawData = new byte[rawDataLength];
            dis.read(this.ivRawData, 0, rawDataLength);
        }
        if (this.ivClassVersion == 2) {
            this.ivClassName = dis.readUTF();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

