/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import org.omg.CORBA.portable.UnknownException;

public class RasHelper {
    private static String svProcessId = "";
    private static String svVersion = "";
    private static String svServerName = "";
    private static boolean svServer = false;
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getProcessId() {
        return svProcessId;
    }

    public static String getVersionId() {
        return svVersion;
    }

    public static boolean isServer() {
        return svServer;
    }

    public static void setServer() {
        svServer = true;
        Tr.createServerStartupListener();
    }

    public static String getServerName() {
        return svServerName;
    }

    public static void setServerAttributes(String serverName, String processId, String version) {
        if (serverName != null) {
            svServerName = serverName;
        }
        if (processId != null) {
            svProcessId = processId;
        }
        if (version != null) {
            svVersion = version;
        }
    }

    public static final String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        RasHelper.printStackTrace(t, p);
        return s.toString();
    }

    private static final void printStackTrace(Throwable t, PrintWriter p) {
        if (t == null) {
            p.println("none");
            return;
        }
        t.printStackTrace(p);
        if (t instanceof UnknownException) {
            UnknownException ue = (UnknownException)t;
            if (ue.originalEx != null) {
                p.println("---- Begin backtrace for originalEx");
                RasHelper.printStackTrace(ue.originalEx, p);
            }
        } else if (t instanceof RemoteException) {
            RemoteException re = (RemoteException)t;
            if (re.detail != null) {
                p.println("----- Begin backtrace for detail");
                RasHelper.printStackTrace(re.detail, p);
            }
        } else if (t instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)t;
            Throwable targetException = ite.getTargetException();
            if (targetException != null) {
                p.println("----- Begin backtrace for targetException");
                RasHelper.printStackTrace(targetException, p);
            }
        } else if (t instanceof NamingException) {
            NamingException ne = (NamingException)t;
            Throwable rootCause = ne.getRootCause();
            if (rootCause != null) {
                p.println("----- Begin backtrace for rootCause");
                RasHelper.printStackTrace(rootCause, p);
            }
        } else if (t instanceof EJBException) {
            EJBException ejbe = (EJBException)t;
            Exception causedBy = ejbe.getCausedByException();
            if (causedBy != null) {
                p.println("----- Begin backtrace for causedBy");
                RasHelper.printStackTrace(causedBy, p);
            }
        } else if (t instanceof SQLException) {
            SQLException sqle = (SQLException)t;
            SQLException next = sqle.getNextException();
            if (next != null) {
                p.println("----- Begin backtrace for next");
                RasHelper.printStackTrace(next, p);
            }
        } else if (t instanceof TraceException) {
            TraceException te = (TraceException)((Object)t);
            Throwable[] subexs = te.getSubexceptions();
            if (subexs == null) {
                return;
            }
            int i = 0;
            while (i < subexs.length) {
                p.println("----- Begin backtrace for subexception[" + i + "]");
                RasHelper.printStackTrace(subexs[i], p);
                ++i;
            }
        }
    }

    static String[] split(String aString, int ch) {
        if (aString == null || aString.equals("")) {
            return new String[0];
        }
        int numComponents = 0;
        int curIndex = 0;
        while (true) {
            curIndex = aString.indexOf(ch, curIndex);
            ++numComponents;
            if (curIndex == -1) break;
            ++curIndex;
        }
        String[] result = new String[numComponents];
        int start = 0;
        int end = aString.indexOf(ch, 0);
        int i = 0;
        while (i < numComponents) {
            result[i] = i + 1 == numComponents ? aString.substring(start) : aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(ch, start);
            ++i;
        }
        return result;
    }

    static final String peelQuotes(String aString) {
        if (aString == null || aString.equals("")) {
            return null;
        }
        if (aString.startsWith("\"")) {
            aString = aString.substring(1);
        }
        if (aString.endsWith("\"")) {
            aString = aString.substring(0, aString.length() - 1);
        }
        if (aString.equals("")) {
            return null;
        }
        return aString;
    }

    static String[] primitiveArrayToString(Object o) {
        if (Byte.TYPE.equals(o.getClass().getComponentType())) {
            return new String[]{RasHelper.byteArrayToHexString((byte[])o)};
        }
        if (Integer.TYPE.equals(o.getClass().getComponentType())) {
            int[] tmp = (int[])o;
            String[] result = new String[tmp.length];
            int i = tmp.length - 1;
            while (i >= 0) {
                result[i] = Integer.toString(tmp[i]);
                --i;
            }
            return result;
        }
        return new String[]{"Illegal trace argument: array of " + o.getClass().getComponentType()};
    }

    static String byteArrayToHexString(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            result.append(hexChars[b[i] >> 4 & 0xF]);
            result.append(hexChars[b[i] & 0xF]);
            ++i;
        }
        return new String(result);
    }

    static DateFormat getBasicDateFormatter() {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            newPattern = newPattern.trim();
            sdFormatter.applyPattern(newPattern);
            formatter = sdFormatter;
        } else {
            formatter = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        return formatter;
    }

    static String generateOutputFileName(String fileName, String defaultPrefix, TraceComponent tc) throws RasException {
        String tempName = null;
        if (fileName == null || fileName.equals("")) {
            tempName = RasHelper.generateFilename(defaultPrefix);
            Tr.warning(tc, "MSG_INVALID_FILENAME", new Object[]{fileName, defaultPrefix, tempName});
        } else {
            tempName = fileName.trim();
        }
        File x = new File(tempName);
        tempName = x.getAbsolutePath();
        RasHelper.validateFileName(tempName);
        return tempName;
    }

    static void validateFileName(String fileName) throws RasException {
        File file = new File(fileName);
        String name = file.getName();
        if (name == null || name.equals("")) {
            throw new RasException("File name " + fileName + " does not have a usable name qualifier");
        }
        String directory = null;
        if (RasHelper.fileExists(file)) {
            directory = file.getParent();
        } else {
            directory = file.getParent();
            if (directory == null) {
                String tempName = file.getAbsolutePath();
                int last = tempName.lastIndexOf(File.separator);
                if (last == -1) {
                    throw new RasException("Incoherent file name of " + fileName);
                }
                directory = tempName.substring(0, last);
                file = new File(directory);
            } else {
                file = new File(directory);
                if (!RasHelper.fileExists(file) && !RasHelper.makeDirectories(file)) {
                    throw new RasException("Unable to create directory  " + directory + " for file " + fileName);
                }
            }
        }
        if (!RasHelper.canWriteFile(file)) {
            throw new RasException("Ras does not have necessary permission to write file " + name + " to directory " + file.getAbsolutePath());
        }
    }

    private static String generateFilename(String defaultPrefix) throws RasException {
        try {
            Date date = new Date(System.currentTimeMillis());
            SimpleDateFormat formatter = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
            String ts = formatter.format(date);
            String name = svServerName + "_" + defaultPrefix + "_" + ts + ".txt";
            String baseDir = RasProperties.getDefaultLoggingDirectory();
            name = baseDir + File.separator + name;
            return name;
        }
        catch (Throwable t) {
            throw new RasException(t);
        }
    }

    static FileOutputStream createFileOutputStream(String fileName, boolean append) throws RasException {
        final String tempFileName = fileName;
        final boolean tempAppend = append;
        try {
            FileOutputStream fs = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileOutputStream(tempFileName, tempAppend);
                }
            });
            return fs;
        }
        catch (Throwable t) {
            throw new RasException("Unable to create FileOutputStream over file " + fileName, t);
        }
    }

    static String getSystemProperty(String propName) {
        final String temp = propName;
        try {
            String prop = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(temp);
                }
            });
            return prop;
        }
        catch (SecurityException se) {
            return null;
        }
    }

    static void setSystemOut(PrintStream stream) throws RasException {
        final PrintStream tempStream = stream;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setOut(tempStream);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            throw new RasException("Unable to replace System.out", t);
        }
    }

    static void setSystemErr(PrintStream stream) throws RasException {
        final PrintStream tempStream = stream;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setErr(tempStream);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            throw new RasException("Unable to replace System.err", t);
        }
    }

    static String getHostName() throws RasException {
        try {
            String hostName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
            return hostName;
        }
        catch (Throwable t) {
            throw new RasException("Unable to obtain host name ", t);
        }
    }

    static InputStream getResourceAsStream(String resource) throws RasException {
        final String tempResource = resource;
        try {
            InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Thread.currentThread().getContextClassLoader().getResourceAsStream(tempResource);
                }
            });
            return stream;
        }
        catch (Throwable t) {
            throw new RasException("unable to get resource " + resource, t);
        }
    }

    static boolean deleteFile(File fileToDelete) {
        try {
            final File tempFileToDelete = fileToDelete;
            Boolean deleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToDelete.delete());
                }
            });
            return deleted;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean fileExists(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.exists());
                }
            });
            return exists;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean canReadFile(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.canRead());
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static long fileLastModified(File fileToCheck) throws RasException {
        final File tempFileToCheck = fileToCheck;
        try {
            Long time = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(tempFileToCheck.lastModified());
                }
            });
            long realTime = time;
            if (realTime == 0L) {
                throw new RasException("Unable to determine time file was last modified");
            }
            return realTime;
        }
        catch (Throwable t) {
            throw new RasException("Unable to determine time file was last modified", t);
        }
    }

    static long getFileLength(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Long size = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(tempFileToCheck.length());
                }
            });
            return size;
        }
        catch (SecurityException se) {
            return 0L;
        }
    }

    static boolean canWriteFile(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.canWrite());
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean createNewFile(File fileToCreate) throws IOException, RasException {
        final File tempFileToCreate = fileToCreate;
        try {
            Boolean bool = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new Boolean(tempFileToCreate.createNewFile());
                }
            });
            return bool;
        }
        catch (Throwable t) {
            throw new RasException("unable to create new file", t);
        }
    }

    static boolean makeDirectories(File dirToMake) {
        final File tempDirToMake = dirToMake;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempDirToMake.mkdirs());
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean renameFile(File current, File newName) {
        final File tempCurrentFile = current;
        final File tempNewName = newName;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempCurrentFile.renameTo(tempNewName));
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean isFile(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean isFile = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.isFile());
                }
            });
            return isFile;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static String[] listFileNames(File file) {
        final File tempFile = file;
        try {
            String[] result = (String[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return tempFile.list();
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return new String[0];
        }
    }

    static boolean isDirectory(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.isDirectory());
                }
            });
            return exists;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static {
        try {
            svProcessId = Long.toString(System.currentTimeMillis());
        }
        catch (Throwable t) {
            svProcessId = "Unknown";
        }
    }
}

