/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.SharedLogConstants;
import com.ibm.ejs.ras.SharedLogLockException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;

abstract class SharedLogBase
implements SharedLogConstants {
    private static TraceComponent tc = Tr.register(class$com$ibm$ejs$ras$SharedLogBase == null ? (class$com$ibm$ejs$ras$SharedLogBase = SharedLogBase.class$("com.ibm.ejs.ras.SharedLogBase")) : class$com$ibm$ejs$ras$SharedLogBase);
    static /* synthetic */ Class class$com$ibm$ejs$ras$SharedLogBase;

    SharedLogBase() throws RasException {
    }

    static synchronized void acquireHostLock(File aLockFile) throws SharedLogLockException {
        int numberOfRetries = 0;
        boolean success = false;
        boolean firstRecovery = true;
        File lockFile = aLockFile;
        try {
            while (!success) {
                success = RasHelper.createNewFile(lockFile);
                if (success) {
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Contention detected attempting to get SharedLog lock");
                }
                if (numberOfRetries == 600) {
                    long lockTime;
                    long curTime = System.currentTimeMillis();
                    if (curTime - (lockTime = RasHelper.fileLastModified(lockFile)) > 300000L && firstRecovery) {
                        firstRecovery = false;
                        SharedLogBase.releaseHostLock(aLockFile);
                        numberOfRetries = 0;
                    } else {
                        SharedLogLockException e = new SharedLogLockException("Unable to obtain Shared Log Lock file " + lockFile.getPath());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception detected attempting to get Host Lock", (Object)e);
                        }
                        throw e;
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ++numberOfRetries;
            }
        }
        catch (Throwable t) {
            SharedLogLockException e = new SharedLogLockException("Unable to obtain Shared Log Lock file " + lockFile.getPath(), t);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception detected attempting to get Host Lock", (Object)e);
            }
            throw e;
        }
    }

    static void releaseHostLock(File lockFile) {
        try {
            RasHelper.deleteFile(lockFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    File copyLogFile(String fileName) throws IOException {
        File fileToReturn = null;
        RandomAccessFile targetFile = null;
        RandomAccessFile sourceFile = null;
        try {
            fileToReturn = this.createTemporaryFile();
            targetFile = this.createRandomAccessFile(fileToReturn.getPath(), "rw");
            sourceFile = this.createRandomAccessFile(fileName, "r");
            this.copyFile(sourceFile, targetFile);
            sourceFile.close();
            targetFile.close();
        }
        catch (IOException ioe) {
            try {
                if (targetFile != null) {
                    targetFile.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            try {
                if (sourceFile != null) {
                    sourceFile.close();
                }
            }
            catch (IOException ioe3) {
                // empty catch block
            }
            throw ioe;
        }
        return fileToReturn;
    }

    private File createTemporaryFile() throws IOException {
        String fileNamePrefix = "wsal";
        String fileNameSuffix = ".log";
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return File.createTempFile("wsal", ".log");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    RandomAccessFile createRandomAccessFile(String fileName, String mode) throws IOException {
        final String tempFileName = fileName;
        final String tempMode = mode;
        try {
            return (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new RandomAccessFile(tempFileName, tempMode);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private void copyFile(RandomAccessFile source, RandomAccessFile target) throws IOException {
        int chunkSize = 4096;
        byte[] buffer = new byte[chunkSize];
        long leftToCopy = source.length();
        boolean done = false;
        source.seek(0L);
        target.seek(0L);
        do {
            if (leftToCopy > (long)chunkSize) {
                source.readFully(buffer);
                target.write(buffer);
                leftToCopy -= (long)chunkSize;
                continue;
            }
            byte[] lastChunk = new byte[(int)leftToCopy];
            source.readFully(lastChunk);
            target.write(lastChunk);
            done = true;
        } while (!done);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deleteTemporaryFile(RandomAccessFile raf, File file) {
        try {
            try {
                raf.close();
            }
            catch (IOException e) {
                Object var5_4 = null;
                RasHelper.deleteFile(file);
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            RasHelper.deleteFile(file);
            throw throwable;
        }
        RasHelper.deleteFile(file);
    }

    Vector readCorruptedFile(RandomAccessFile file) {
        Vector<MessageEvent> msgs = new Vector<MessageEvent>();
        try {
            MessageEvent me;
            int blockSize = 4096;
            int fileSize = (int)file.length();
            if (fileSize < 1) {
                return null;
            }
            int maxMessageSize = fileSize - 4100;
            if (maxMessageSize > 100000) {
                maxMessageSize = 100000;
            }
            int fullReads = fileSize / blockSize;
            int partialSize = fileSize % blockSize;
            if (partialSize == 0) {
                --fullReads;
                partialSize = blockSize;
            }
            byte[] readBuffer = new byte[blockSize + 3];
            ByteArrayInputStream bais = new ByteArrayInputStream(readBuffer);
            DataInputStream dis = new DataInputStream(bais);
            int startOfChunk = 0;
            int bufferOffset = 0;
            int i = fullReads;
            while (i > 0) {
                file.seek(startOfChunk);
                file.readFully(readBuffer);
                bais.reset();
                bufferOffset = 0;
                while (bufferOffset != -1) {
                    if ((bufferOffset = this.findNextHeader(dis, blockSize + 3, bufferOffset)) == -1) continue;
                    me = this.getMessage(file, startOfChunk + bufferOffset, maxMessageSize);
                    if (me != null) {
                        msgs.addElement(me);
                    }
                    bufferOffset += 4;
                }
                startOfChunk += blockSize;
                --i;
            }
            readBuffer = new byte[partialSize];
            bais = new ByteArrayInputStream(readBuffer);
            dis = new DataInputStream(bais);
            bufferOffset = 0;
            file.seek(startOfChunk);
            file.readFully(readBuffer);
            while (bufferOffset != -1) {
                if ((bufferOffset = this.findNextHeader(dis, partialSize, bufferOffset)) == -1) continue;
                me = this.getMessage(file, startOfChunk + bufferOffset, maxMessageSize);
                if (me != null) {
                    msgs.addElement(me);
                }
                bufferOffset += 4;
            }
            return msgs;
        }
        catch (IOException ioe) {
            return msgs;
        }
    }

    private int findNextHeader(DataInputStream dis, int bufferSize, int bufferOffset) {
        int msgLocation = -1;
        boolean done = false;
        int matchLevel = 0;
        int startingOffset = 0;
        int bytesToProcess = bufferSize - bufferOffset;
        try {
            int i = bufferOffset;
            while (i < bufferSize) {
                byte aByte = dis.readByte();
                if (aByte == SharedLogConstants.svEntryHeader[0]) {
                    matchLevel = 1;
                    startingOffset = i;
                } else {
                    switch (matchLevel) {
                        case 1: {
                            if (aByte == SharedLogConstants.svEntryHeader[1]) {
                                matchLevel = 2;
                                break;
                            }
                            matchLevel = 0;
                            break;
                        }
                        case 2: {
                            if (aByte == SharedLogConstants.svEntryHeader[2]) {
                                matchLevel = 3;
                                break;
                            }
                            matchLevel = 0;
                            break;
                        }
                        case 3: {
                            matchLevel = aByte == SharedLogConstants.svEntryHeader[3] ? 4 : 0;
                        }
                    }
                }
                if (matchLevel == 4) {
                    return startingOffset;
                }
                ++i;
            }
            return -1;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return -1;
        }
    }

    private MessageEvent getMessage(RandomAccessFile file, int location, int maxMessageSize) {
        try {
            byte[] buffer = new byte[4];
            ByteArrayInputStream myBais = new ByteArrayInputStream(buffer);
            DataInputStream myDis = new DataInputStream(myBais);
            file.seek(location + 4);
            file.readFully(buffer);
            int blockSize = myDis.readInt();
            if (blockSize > maxMessageSize) {
                return null;
            }
            byte[] eventData = new byte[blockSize];
            ByteArrayInputStream eventBais = new ByteArrayInputStream(eventData);
            DataInputStream eventDis = new DataInputStream(eventBais);
            file.seek(location + 8);
            file.readFully(eventData);
            MessageEvent event = new MessageEvent();
            event.readFromStream(eventDis);
            return event;
        }
        catch (IOException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

