/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogBase;
import com.ibm.ejs.ras.SharedLogConstants;
import com.ibm.ejs.ras.SharedLogHeader;
import com.ibm.ejs.ras.SharedLogLockException;
import com.ibm.ejs.ras.SharedLogReader;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

class SharedLogWriter
extends SharedLogBase
implements TraceEventListener {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ejs$ras$SharedLogWriter == null ? (class$com$ibm$ejs$ras$SharedLogWriter = SharedLogWriter.class$("com.ibm.ejs.ras.SharedLogWriter")) : class$com$ibm$ejs$ras$SharedLogWriter, null, "com.ibm.ejs.resources.RasMessages");
    private static String svFqFileName = null;
    private static File svFile = null;
    private static String svFqLockFileName = null;
    private static File svLockFile = null;
    static int svFileLength;
    static int svMaxMessageSize;
    private static SharedLogWriter svSharedLogWriter;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private boolean ivUsable;
    private boolean ivVerifyCompleted;
    private boolean ivRecovered;
    private Vector ivUnwrittenEvents;
    private long ivFirstErrorTime;
    static /* synthetic */ Class class$com$ibm$ejs$ras$SharedLogWriter;

    static synchronized SharedLogWriter getInstance() {
        if (svSharedLogWriter == null) {
            try {
                svSharedLogWriter = new SharedLogWriter();
            }
            catch (Throwable t) {
                svSharedLogWriter = null;
            }
        }
        return svSharedLogWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SharedLogWriter() throws RasException {
        block14: {
            this.ivUsable = false;
            this.ivVerifyCompleted = false;
            this.ivRecovered = false;
            this.ivUnwrittenEvents = null;
            this.ivFirstErrorTime = 0L;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SharedLogWriter - ctor");
            }
            svFqFileName = RasProperties.getActivityLogName();
            svFileLength = RasProperties.getActivityLogSize();
            svFqLockFileName = svFqFileName + ".lck";
            svLockFile = new File(svFqLockFileName);
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
            svMaxMessageSize = svFileLength - 4100;
            if (svMaxMessageSize > 100000) {
                svMaxMessageSize = 100000;
            }
            boolean lockAcquired = false;
            try {
                try {
                    SharedLogBase.acquireHostLock(svLockFile);
                    lockAcquired = true;
                    this.ivUsable = true;
                    this.verifyLogFile(false);
                    this.ivVerifyCompleted = true;
                }
                catch (SharedLogLockException slle) {
                    Object var7_3 = null;
                    if (lockAcquired) {
                        SharedLogBase.releaseHostLock(svLockFile);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
                        Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
                        Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
                        Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
                    }
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "SharedLogWriter - ctor");
                    return;
                }
                catch (RasException re) {
                    this.ivUsable = false;
                    Tr.error(tc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{svFqFileName, re});
                    throw re;
                }
                catch (IOException ioe) {
                    this.ivUsable = false;
                    RasException e = new RasException(ioe);
                    Tr.error(tc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{svFqFileName, e});
                    throw e;
                }
                Object var7_2 = null;
                if (!lockAcquired) break block14;
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                if (lockAcquired) {
                    SharedLogBase.releaseHostLock(svLockFile);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
                    Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
                    Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
                    Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
                }
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "SharedLogWriter - ctor");
                throw throwable;
            }
            SharedLogBase.releaseHostLock(svLockFile);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
            Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
            Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
            Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "SharedLogWriter - ctor");
    }

    public void auditEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void warningEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void errorEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void fatalEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void serviceEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void debugEvent(TraceEvent event) {
    }

    public void dumpEvent(TraceEvent event) {
    }

    public void eventEvent(TraceEvent event) {
    }

    public void entryEvent(TraceEvent event) {
    }

    public void exitEvent(TraceEvent event) {
    }

    public void infoEvent(MessageEvent event) {
    }

    public void systemErrEvent(StreamEvent event) {
    }

    public void systemOutEvent(StreamEvent event) {
    }

    public void uncondTraceEvent(TraceEvent event) {
    }

    /*
     * Loose catch block
     */
    private synchronized void logMessage(MessageEvent event) {
        block33: {
            boolean lockAcquired;
            byte[] data;
            RandomAccessFile file;
            block31: {
                SharedLogHeader header;
                if (event == null) {
                    return;
                }
                if (!this.ivUsable && this.ivVerifyCompleted) {
                    return;
                }
                file = null;
                data = this.prepareEntry(event);
                if (data == null || data.length > svMaxMessageSize) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - message size is invalid", data);
                    }
                    return;
                }
                lockAcquired = false;
                SharedLogBase.acquireHostLock(svLockFile);
                lockAcquired = true;
                if (!this.ivVerifyCompleted) {
                    this.ivUsable = true;
                    this.verifyLogFile(true);
                    this.ivVerifyCompleted = true;
                }
                file = this.createRandomAccessFile(svFqFileName, "rw");
                try {
                    header = new SharedLogHeader(file);
                }
                catch (IOException ioe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - failed reading header for file, attempting recovery", ioe);
                    }
                    this.recoverFile(file);
                    this.ivRecovered = true;
                    header = new SharedLogHeader(file);
                }
                this.writeEvent(file, header, data);
                Object var10_8 = null;
                if (file == null) break block31;
                try {
                    file.close();
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            if (lockAcquired) {
                SharedLogBase.releaseHostLock(svLockFile);
            }
            break block33;
            {
                catch (SharedLogLockException slle) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - caught SharedLogLockException", (Object)slle);
                    }
                    if (this.ivUnwrittenEvents == null) {
                        this.ivUnwrittenEvents = new Vector(10);
                        this.ivUnwrittenEvents.addElement(data);
                        this.ivFirstErrorTime = System.currentTimeMillis();
                    } else {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - this.ivFirstErrorTime < 300000L) {
                            this.ivUnwrittenEvents.addElement(data);
                        } else {
                            this.ivUsable = false;
                            Tr.removeTraceEventListener(this);
                            Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", (Object)slle);
                        }
                    }
                    Object var10_9 = null;
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                    }
                    if (lockAcquired) {
                        SharedLogBase.releaseHostLock(svLockFile);
                    }
                    break block33;
                }
                catch (Throwable t) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - caught exception", t);
                    }
                    this.ivUsable = false;
                    Tr.removeTraceEventListener(this);
                    Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", t);
                    Object var10_10 = null;
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                    }
                    if (lockAcquired) {
                        SharedLogBase.releaseHostLock(svLockFile);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
                if (lockAcquired) {
                    SharedLogBase.releaseHostLock(svLockFile);
                }
                throw throwable;
            }
        }
    }

    private void writeEvent(RandomAccessFile file, SharedLogHeader header, byte[] data) throws IOException {
        if (this.ivUnwrittenEvents != null) {
            int size = this.ivUnwrittenEvents.size();
            int i = 0;
            while (i < size) {
                byte[] entry = (byte[])this.ivUnwrittenEvents.elementAt(i);
                this.writeDataAndHeader(file, header, entry);
                ++i;
            }
            this.ivUnwrittenEvents = null;
        }
        this.writeDataAndHeader(file, header, data);
    }

    private byte[] prepareEntry(MessageEvent event) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare entry");
        }
        try {
            this.baos.reset();
            event.writeToStream(this.dos);
            byte[] data = this.baos.toByteArray();
            this.baos.reset();
            this.dos.write(SharedLogConstants.svEntryHeader, 0, SharedLogConstants.svEntryHeader.length);
            this.dos.writeInt(data.length);
            this.dos.write(data, 0, data.length);
            this.dos.write(SharedLogConstants.svEntryTrailer, 0, SharedLogConstants.svEntryTrailer.length);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare entry");
            }
            return this.baos.toByteArray();
        }
        catch (IOException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare entry", e);
            }
            return null;
        }
    }

    private void writeDataAndHeader(RandomAccessFile file, SharedLogHeader header, byte[] data) throws IOException {
        int nextByte;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeDataAndHeader");
        }
        int curFreeSpace = header.ivFreeSpace;
        int dataLength = data.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - writing " + dataLength + " bytes to  location " + curFreeSpace);
        }
        if (curFreeSpace + dataLength <= header.ivMaxSize) {
            file.seek(curFreeSpace);
            file.write(data);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - data wraps");
            }
            int firstHalfSize = header.ivMaxSize - curFreeSpace;
            int secondHalfSize = dataLength - firstHalfSize;
            byte[] firstData = new byte[firstHalfSize];
            System.arraycopy(data, 0, firstData, 0, firstHalfSize);
            byte[] secondData = new byte[secondHalfSize];
            System.arraycopy(data, firstHalfSize, secondData, 0, secondHalfSize);
            file.seek(curFreeSpace);
            file.write(firstData);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - firstHalf writing " + firstHalfSize + " bytes to  location " + curFreeSpace);
            }
            header.ivFileWrapped = true;
            file.seek(SharedLogHeader.DATA_AREA_OFFSET);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - 2ndHalf writing " + secondHalfSize + " bytes to  location " + SharedLogHeader.DATA_AREA_OFFSET);
            }
            file.write(secondData);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - write complete, filePointer = " + file.getFilePointer());
        }
        if ((nextByte = (int)file.getFilePointer()) == header.ivMaxSize) {
            header.ivFreeSpace = SharedLogHeader.DATA_AREA_OFFSET;
            header.ivFileWrapped = true;
        } else {
            header.ivFreeSpace = nextByte;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - freeSpace ptr = " + header.ivFreeSpace);
        }
        header.writeHeader(file);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeDataAndHeader");
        }
    }

    private void verifyLogFile(boolean added) throws IOException, RasException {
        RandomAccessFile raFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyLogFile");
        }
        try {
            raFile = this.createRandomAccessFile(svFqFileName, "rw");
        }
        catch (FileNotFoundException fnf) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verifyLogFile caught FileNotFound Exception", fnf);
            }
            throw new RasException("unable to access file " + svFqFileName, fnf);
        }
        if (raFile.length() == 0L) {
            SharedLogHeader sharedLogHeader = new SharedLogHeader(raFile, svFileLength);
        } else {
            this.processExistingFile(raFile, added);
        }
        raFile.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyLogFile");
        }
    }

    private void processExistingFile(RandomAccessFile file, boolean added) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processExistingFile");
        }
        SharedLogHeader header = null;
        try {
            header = new SharedLogHeader(file);
        }
        catch (IOException ioe) {
            this.recoverFile(file);
            this.ivRecovered = true;
            header = new SharedLogHeader(file);
        }
        if (header.ivMaxSize != svFileLength) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processExistingFile - changing size of log file");
            }
            try {
                SharedLogReader reader = new SharedLogReader(svFqFileName, true);
                file.setLength(svFileLength);
                header.ivMaxSize = svFileLength;
                header.ivFreeSpace = SharedLogHeader.DATA_AREA_OFFSET;
                header.ivFileWrapped = false;
                header.writeHeader(file);
                boolean done = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processExistingFile - rewriting existing messages");
                }
                do {
                    MessageEvent event;
                    if ((event = reader.getNextMessage()) == null) {
                        done = true;
                        continue;
                    }
                    this.logMessage(event);
                } while (!done);
            }
            catch (RasException re) {
                if (!added) {
                    Tr.warning(tc, "MSG_SHARED_LOG_CHANGE_SIZE_FAILED", (Object)re);
                }
                Tr.removeTraceEventListener(this);
                Tr.warning(tc, "MSG_SHARED_LOG_CHANGE_SIZE_FAILED", (Object)re);
                Tr.addTraceEventListener(this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processExistingFile");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recoverFile(RandomAccessFile file) throws IOException {
        block13: {
            block12: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "recoverFile");
                }
                try {
                    try {
                        if (file.length() == 0L) {
                            SharedLogHeader header = new SharedLogHeader(file, svFileLength);
                            Object var8_5 = null;
                            if (!tc.isEntryEnabled()) return;
                            break block12;
                        }
                        if (this.ivRecovered) {
                            throw new IOException("SharedLogWriter.recoverFile - multiple attempts not allowed");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "recoverFile - recovering existing file");
                        }
                        Vector msgs = this.readCorruptedFile(file);
                        file.setLength(0L);
                        SharedLogHeader header = new SharedLogHeader(file, svFileLength);
                        if (msgs != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "recoverFile - writing " + msgs.size() + " messages back to the file");
                            }
                            Enumeration enumeration = msgs.elements();
                            while (enumeration.hasMoreElements()) {
                                MessageEvent te = (MessageEvent)enumeration.nextElement();
                                byte[] entry = this.prepareEntry(te);
                                if (entry == null) continue;
                                this.writeDataAndHeader(file, header, entry);
                            }
                        }
                        break block13;
                    }
                    catch (IOException e) {
                        if (!tc.isDebugEnabled()) throw e;
                        Tr.debug(tc, "recoverFile - Exception occurred", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "recoverFile");
                    throw throwable;
                }
            }
            Tr.exit(tc, "recoverFile");
            return;
        }
        Object var8_6 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "recoverFile");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        svMaxMessageSize = 100000;
        svSharedLogWriter = null;
    }
}

