/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.SharedLogReader;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceNLS;
import java.io.PrintStream;
import java.util.Locale;

public class ShowLog {
    private static String svBundle = "com.ibm.ejs.resources.RasMessages";

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        outputXml = false;
        languageSpecified = false;
        languageArg = null;
        countrySpecified = false;
        countryArg = null;
        inputFilename = null;
        outputFilename = null;
        if (args.length < 1) {
            ShowLog.usage();
            return;
        }
        done = false;
        state = 0;
        argToProcess = 0;
        numberOfArgs = args.length;
        arg = null;
        while (!done) {
            switch (state) {
                case 0: {
                    if (argToProcess >= numberOfArgs) {
                        System.out.println("incorrect number of arguments specified");
                        System.exit(-1);
                    }
                    if ((arg = args[argToProcess++]).equalsIgnoreCase("-xml")) {
                        state = 1;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-language")) {
                        state = 2;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-country")) {
                        state = 3;
                        break;
                    }
                    state = 4;
                    break;
                }
                case 1: {
                    if (outputXml) {
                        System.out.println("-xml switch pecified more than once");
                        System.exit(-1);
                    } else {
                        outputXml = true;
                        state = 0;
                        break;
                    }
                }
                case 2: {
                    if (!languageSpecified) ** GOTO lbl46
                    System.out.println("-language switch specified multiple times.");
                    System.exit(-1);
                    ** GOTO lbl53
lbl46:
                    // 1 sources

                    languageSpecified = true;
                    if ((languageArg = args[argToProcess++]).startsWith("-")) {
                        System.out.println("Missing language specifier after -language switch");
                        System.exit(-1);
                    } else {
                        state = 0;
                        break;
                    }
                }
lbl53:
                // 3 sources

                case 3: {
                    if (!countrySpecified) ** GOTO lbl58
                    System.out.println("-country switch specified multiple times.");
                    System.exit(-1);
                    ** GOTO lbl65
lbl58:
                    // 1 sources

                    countrySpecified = true;
                    if ((countryArg = args[argToProcess++]).startsWith("-")) {
                        System.out.println("Missing country specifier after -country switch");
                        System.exit(-1);
                    } else {
                        state = 0;
                        break;
                    }
                }
lbl65:
                // 3 sources

                case 4: {
                    if (arg.startsWith("-")) {
                        System.out.println("unrecognized switch " + arg + " specified");
                        System.exit(-1);
                    }
                    inputFilename = arg;
                    if (argToProcess < numberOfArgs && (outputFilename = args[argToProcess++]).startsWith("-")) {
                        System.out.println("switch " + outputFilename + " is not allowed at the present position");
                        System.exit(-1);
                    }
                    if (argToProcess < numberOfArgs) {
                        System.out.println("too many arguments specified");
                        System.exit(-1);
                        break;
                    }
                    done = true;
                }
            }
        }
        ps = null;
        numRecords = 0;
        if (outputFilename == null) {
            ps = (PrintStream)Tr.getSystemOut();
        } else {
            try {
                RasHelper.validateFileName(outputFilename.trim());
                fos = RasHelper.createFileOutputStream(outputFilename, false);
                ps = new PrintStream(fos);
            }
            catch (Throwable t) {
                System.out.println("Unable to open output file " + outputFilename);
                System.exit(-1);
            }
        }
        locale = Locale.getDefault();
        if (countryArg == null) {
            countryArg = "";
        }
        if (languageArg != null) {
            try {
                locale = new Locale(languageArg, countryArg);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        etl = new ExtendedTraceLogger(ps, outputXml, locale);
        etl.printHeader();
        try {
            slr = new SharedLogReader(inputFilename, false);
            me = slr.getNextMessage();
            while (me != null) {
                etl.logMessage(me);
                me = slr.getNextMessage();
                ++numRecords;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!outputXml) {
            ps.println();
        }
        etl.printFooter(numRecords);
        ps.close();
    }

    private static void usage() {
        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG001", "This program dumps a Websphere binary log file to standard out or a file."));
        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG002", "Usage: showlog binaryFilename [outputFilename]"));
        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG003", "where:"));
        System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG004", "binaryFilename should be a binary log filename in the WASHOME/logs directory or a fully-qualified binary log filename.  showlog will not look in the current directory."));
        System.err.println();
        System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG005", "outputFilename is optional.  If no filename is given, showlog dumps binaryFilename to standard out.  Otherwise, outputFilename will be created in the current directory unless it is a fully-qualified filename."));
        System.err.println();
    }
}

