/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.TraceComponent;
import java.io.FilterOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;

public class StreamEvent
extends RasEvent {
    private String ivStringData = null;
    private byte[] ivByteArray = null;
    private char[] ivCharArray = null;
    private Vector ivDataCache = null;

    StreamEvent(int type, TraceComponent tc, String data) {
        super(type, tc, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivStringData = data;
    }

    StreamEvent(int type, TraceComponent tc, byte[] data) {
        super(type, tc, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivByteArray = data;
    }

    StreamEvent(int type, TraceComponent tc, char[] data) {
        super(type, tc, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivCharArray = data;
    }

    synchronized void addDataCache(Vector vec) {
        this.ivDataCache = vec;
    }

    synchronized void writeSelfToStream(PrintStream stream, String format, boolean terminate, StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        if ("basic".equals(format)) {
            this.formatHeaderBasic(buffer, formatter, date, fPos);
            stream.print(new String(buffer));
        } else {
            this.formatHeaderAdvanced(buffer, formatter, date, fPos);
            stream.println(new String(buffer));
            stream.print(RasEvent.svAdvancedPadding);
        }
        this.writeDataToStream(stream, terminate);
    }

    synchronized void writeDataToStream(PrintStream stream, boolean terminate) {
        try {
            if (this.ivStringData != null) {
                stream.print(this.ivStringData);
            }
            if (this.ivCharArray != null) {
                stream.print(this.ivCharArray);
            }
            if (this.ivByteArray != null) {
                ((FilterOutputStream)stream).write(this.ivByteArray);
            }
            if (this.ivDataCache != null) {
                int size = this.ivDataCache.size();
                int i = 0;
                while (i < size) {
                    Object x = this.ivDataCache.elementAt(i);
                    if (x instanceof String) {
                        stream.print((String)x);
                    }
                    if (x instanceof char[]) {
                        stream.print((char[])x);
                    }
                    if (x instanceof byte[]) {
                        ((FilterOutputStream)stream).write((byte[])x);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (terminate) {
            stream.println();
        }
    }

    synchronized void writeSelfToStream(PrintWriter writer, String format, boolean terminate, StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        if ("basic".equals(format)) {
            this.formatHeaderBasic(buffer, formatter, date, fPos);
            writer.print(new String(buffer));
        } else {
            this.formatHeaderAdvanced(buffer, formatter, date, fPos);
            writer.println(new String(buffer));
            writer.print(RasEvent.svAdvancedPadding);
        }
        this.writeDataToStream(writer, terminate);
    }

    synchronized void writeDataToStream(PrintWriter writer, boolean terminate) {
        if (this.ivStringData != null) {
            writer.print(this.ivStringData);
        }
        if (this.ivCharArray != null) {
            writer.print(this.ivCharArray);
        }
        if (this.ivByteArray != null) {
            String x = new String(this.ivByteArray);
            writer.write(x);
        }
        if (this.ivDataCache != null) {
            int size = this.ivDataCache.size();
            int i = 0;
            while (i < size) {
                Object x = this.ivDataCache.elementAt(i);
                if (x instanceof String) {
                    writer.print((String)x);
                }
                if (x instanceof char[]) {
                    writer.print((char[])x);
                }
                if (x instanceof byte[]) {
                    String y = new String((byte[])x);
                    writer.write(y);
                }
                ++i;
            }
        }
        if (terminate) {
            writer.println();
        }
    }
}

