/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.SystemStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventListener;
import com.ibm.ejs.ras.WrappingFileOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

public class SystemOutStream
extends SystemStream
implements TraceEventListener,
LogRolloverListener {
    private static String svSystemOut = "SystemOut";
    private static TraceComponent svTc = Tr.register(svSystemOut, null, "com.ibm.ejs.resources.RasMessages");
    private static SystemOutStream svSos;
    private static WrappingFileOutputStream svFile;
    private boolean ivSuppressStacks;

    public static synchronized void replaceSystemOutStream(String fileName, int rolloverType, int maxBackups, long rolloverSize, int baseHour, int rolloverPeriod, boolean suppress, boolean formatOutput, String formatType, boolean suppressStacks) throws RasException {
        NullOutputStream nos = new NullOutputStream();
        if (fileName == null || fileName.equalsIgnoreCase("console")) {
            SystemOutStream sos = new SystemOutStream(nos, System.out, suppress, formatOutput, formatType, suppressStacks);
            RasHelper.setSystemOut(sos);
            Tr.replaceTraceEventListener(sos, svSos);
            svSos = sos;
            return;
        }
        if (fileName.equalsIgnoreCase("none")) {
            PrintStream ps = new PrintStream(nos);
            RasHelper.setSystemOut(ps);
            Tr.replaceTraceEventListener(null, svSos);
            svSos = null;
            return;
        }
        try {
            String name = RasHelper.generateOutputFileName(fileName, svSystemOut, svTc);
            svFile = new WrappingFileOutputStream(name, rolloverType, maxBackups, rolloverSize, baseHour, rolloverPeriod);
            PrintStream ps = new PrintStream(svFile);
            SystemOutStream sos = new SystemOutStream(nos, ps, suppress, formatOutput, formatType, suppressStacks);
            svFile.addRolloverListener(sos);
            RasHelper.setSystemOut(sos);
            Tr.replaceTraceEventListener(sos, svSos);
            svSos = sos;
        }
        catch (RasException re) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Out", re});
            throw re;
        }
        catch (Throwable t) {
            Tr.error(svTc, "MSG_STREAM_REPLACEMENT_FAILED", new Object[]{"System.Out", t});
            throw new RasException("Redirection of System.out to file " + fileName + " failed", t);
        }
    }

    static synchronized String rolloverLogFileImmediate(String fileName) throws RasException {
        if (svFile == null) {
            throw new RasException("System.out currently not redirected to a log file");
        }
        try {
            return svFile.rolloverImmediate(fileName);
        }
        catch (IOException ioe) {
            throw new RasException(ioe);
        }
    }

    static void initialize() {
        if (svSos != null) {
            svSos.printHeader();
        }
    }

    private SystemOutStream(OutputStream dummy, PrintStream stream, boolean suppress, boolean format, String formatType, boolean suppressStacks) {
        super(dummy, stream, suppress, format, formatType);
        this.ivSuppressStacks = suppressStacks;
    }

    public void logRolled() {
        this.printHeader();
    }

    public void auditEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void debugEvent(TraceEvent event) {
    }

    public void dumpEvent(TraceEvent event) {
    }

    public void errorEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void eventEvent(TraceEvent event) {
    }

    public void entryEvent(TraceEvent event) {
    }

    public void exitEvent(TraceEvent event) {
    }

    public void fatalEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void infoEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void serviceEvent(MessageEvent event) {
    }

    public void systemErrEvent(StreamEvent event) {
    }

    public void systemOutEvent(StreamEvent event) {
    }

    public void uncondTraceEvent(TraceEvent event) {
        this.logTrace(event);
    }

    public void warningEvent(MessageEvent event) {
        this.logMessage(event);
    }

    private synchronized void logTrace(TraceEvent event) {
        if (event == null) {
            return;
        }
        this.writeWebSphereEvent(this.formatEvent(event));
    }

    private synchronized void logMessage(MessageEvent event) {
        if (event == null) {
            return;
        }
        this.writeWebSphereEvent(this.formatEvent(event));
    }

    private String formatEvent(TraceEvent te) {
        if ("advanced".equals(this.ivFormatType)) {
            return te.formatAdvanced(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
        }
        return te.formatBasic(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
    }

    private String formatEvent(MessageEvent me) {
        if ("advanced".equals(this.ivFormatType)) {
            return me.formatAdvanced(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
        }
        return me.formatBasic(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
    }

    StreamEvent createEvent(String data) {
        StreamEvent event = new StreamEvent(13, svTc, data);
        return event;
    }

    StreamEvent createEvent(byte[] data) {
        StreamEvent event = new StreamEvent(13, svTc, data);
        return event;
    }

    StreamEvent createEvent(char[] data) {
        StreamEvent event = new StreamEvent(13, svTc, data);
        return event;
    }

    void dispatchEvent(StreamEvent event) {
        Tr.systemOut(event);
    }

    void printHeader() {
        String javaVersion;
        String headLine = "************ Start Display Current Environment ************";
        String tailLine = "************* End Display Current Environment *************";
        String server = "WebSphere {0} running with process name {1} and process id {2}";
        String os = "Host Operating System is {0}, version {1}";
        String jvm = "Java version = {0}, Java Compiler = {1}, Java VM name = {2}";
        String sysRoot = "was.install.root = {0}";
        String userRoot = "user.install.root = {0}";
        String jhome = "Java Home = {0}";
        String wsext = "ws.ext.dirs = {0}";
        String cp = "Classpath = {0}";
        String lp = "Java Library path = {0}";
        if (this.ivStream == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.println(headLine);
        String version = RasHelper.getVersionId();
        if (version != null && !version.equals("")) {
            ps.println(MessageFormat.format(server, version, RasHelper.getServerName(), RasHelper.getProcessId()));
        }
        if ((javaVersion = RasHelper.getSystemProperty("java.fullversion")) == null) {
            javaVersion = RasHelper.getSystemProperty("java.version");
        }
        String a = RasHelper.getSystemProperty("os.name");
        String b = RasHelper.getSystemProperty("os.version");
        ps.println(MessageFormat.format(os, a, b));
        a = RasHelper.getSystemProperty("java.compiler");
        b = RasHelper.getSystemProperty("java.vm.name");
        ps.println(MessageFormat.format(jvm, javaVersion, a, b));
        a = RasHelper.getSystemProperty("was.install.root");
        ps.println(MessageFormat.format(sysRoot, a));
        a = RasHelper.getSystemProperty("user.install.root");
        ps.println(MessageFormat.format(userRoot, a));
        a = RasHelper.getSystemProperty("java.home");
        ps.println(MessageFormat.format(jhome, a));
        a = RasHelper.getSystemProperty("ws.ext.dirs");
        ps.println(MessageFormat.format(wsext, a));
        a = RasHelper.getSystemProperty("java.class.path");
        ps.println(MessageFormat.format(cp, a));
        a = RasHelper.getSystemProperty("java.library.path");
        ps.println(MessageFormat.format(lp, a));
        ps.println(tailLine);
        ps.flush();
        byte[] bytes = baos.toByteArray();
        try {
            if (svFile != null) {
                svFile.write(bytes);
            } else {
                ((FilterOutputStream)this.ivStream).write(bytes);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    static {
        svFile = null;
    }

    private static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

