/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;

abstract class SystemStream
extends PrintStream {
    private static final String svTrue = "true";
    private static final String svFalse = "false";
    PrintStream ivStream;
    private boolean ivSuppress;
    private boolean ivFormatted;
    String ivFormatType;
    private boolean ivWritePending = false;
    private StreamEvent ivEvent = null;
    private Vector ivCache;
    StringBuffer ivBuffer;
    DateFormat ivFormatter;
    Date ivDate;
    FieldPosition ivFieldPos;

    SystemStream(OutputStream dummy, PrintStream stream, boolean suppress, boolean format, String formatType) {
        super(dummy);
        this.ivStream = stream;
        this.ivFormatted = format;
        this.ivFormatType = formatType;
        this.ivSuppress = suppress;
        this.ivBuffer = new StringBuffer();
        this.ivFormatter = RasHelper.getBasicDateFormatter();
        this.ivDate = new Date();
        this.ivFieldPos = new FieldPosition(0);
    }

    abstract StreamEvent createEvent(String var1);

    abstract StreamEvent createEvent(byte[] var1);

    abstract StreamEvent createEvent(char[] var1);

    abstract void dispatchEvent(StreamEvent var1);

    public void flush() {
        this.ivStream.flush();
    }

    public void close() {
        this.ivStream.close();
    }

    public boolean checkError() {
        return this.ivStream.checkError();
    }

    public void write(int b) {
        if (this.ivSuppress) {
            return;
        }
        byte[] data = new byte[]{(byte)b};
        if (ComponentManager.svTraceEnabled) {
            this.cacheTraceData(data);
        }
        if (!this.ivFormatted) {
            this.ivStream.write(b);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.write(b);
                } else {
                    StreamEvent sse = this.createEvent(data);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                    this.ivWritePending = true;
                }
            }
        }
    }

    public void write(byte[] buffer, int offset, int len) {
        block15: {
            if (this.ivSuppress) {
                return;
            }
            if (len == 0) {
                return;
            }
            if (buffer == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || len < 0) {
                throw new IndexOutOfBoundsException();
            }
            int size = buffer.length;
            if (offset > size || len > size || offset + len > size) {
                throw new IndexOutOfBoundsException();
            }
            if (offset + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            byte[] data = new byte[len];
            System.arraycopy(buffer, offset, data, 0, len);
            if (ComponentManager.svTraceEnabled) {
                this.cacheTraceData(data);
            }
            try {
                if (!this.ivFormatted) {
                    ((FilterOutputStream)this.ivStream).write(data);
                    break block15;
                }
                SystemStream systemStream = this;
                synchronized (systemStream) {
                    if (this.ivWritePending) {
                        ((FilterOutputStream)this.ivStream).write(data);
                    } else {
                        StreamEvent sse = this.createEvent(data);
                        sse.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                        this.ivWritePending = true;
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public void print(boolean x) {
        if (this.ivSuppress) {
            return;
        }
        if (!x) {
            this.doPrint(svFalse);
        } else {
            this.doPrint(svTrue);
        }
    }

    public void print(char x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(int x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(long x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(float x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(double x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(char[] x) {
        if (this.ivSuppress) {
            return;
        }
        if (ComponentManager.svTraceEnabled) {
            this.cacheTraceData(x);
        }
        if (!this.ivFormatted) {
            this.ivStream.print(x);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.print(x);
                } else {
                    StreamEvent sse = this.createEvent(x);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                    this.ivWritePending = true;
                }
            }
        }
    }

    public void print(String x) {
        if (this.ivSuppress) {
            return;
        }
        this.doPrint(x);
    }

    public void print(Object obj) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(obj);
        this.doPrint(writeData);
    }

    public void println() {
        if (this.ivSuppress) {
            return;
        }
        String writeData = null;
        StreamEvent sse = null;
        if (ComponentManager.svTraceEnabled) {
            sse = this.getTraceData(writeData);
            this.dispatchEvent(sse);
        }
        if (!this.ivFormatted) {
            this.ivStream.println();
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.println();
                } else {
                    sse = this.createEvent(writeData);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    public void println(boolean x) {
        if (this.ivSuppress) {
            return;
        }
        if (x) {
            this.doPrintLine(svTrue);
        } else {
            this.doPrintLine(svFalse);
        }
    }

    public void println(char x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(int x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(long x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(float x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(double x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(char[] x) {
        if (this.ivSuppress) {
            return;
        }
        StreamEvent sse = null;
        if (ComponentManager.svTraceEnabled) {
            sse = this.getTraceData(x);
            this.dispatchEvent(sse);
        }
        if (!this.ivFormatted) {
            this.ivStream.println(x);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.println(x);
                } else {
                    sse = this.createEvent(x);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    public void println(String x) {
        if (this.ivSuppress) {
            return;
        }
        this.doPrintLine(x);
    }

    public void println(Object x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    void writeWebSphereEvent(String data) {
        if (this.ivWritePending) {
            this.ivStream.println();
        }
        this.ivStream.println(data);
    }

    private final void doPrint(String data) {
        if (ComponentManager.svTraceEnabled) {
            this.cacheTraceData(data);
        }
        if (!this.ivFormatted) {
            this.ivStream.print(data);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.print(data);
                } else {
                    StreamEvent sse = this.createEvent(data);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                    this.ivWritePending = true;
                }
            }
        }
    }

    private final void doPrintLine(String data) {
        if (ComponentManager.svTraceEnabled) {
            StreamEvent sse = this.getTraceData(data);
            this.dispatchEvent(sse);
        }
        if (!this.ivFormatted) {
            this.ivStream.println(data);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.println(data);
                } else {
                    StreamEvent sse = this.createEvent(data);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    private synchronized void cacheTraceData(String data) {
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(data);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(data);
        }
    }

    private synchronized void cacheTraceData(byte[] data) {
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(data);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(data);
        }
    }

    private synchronized void cacheTraceData(char[] data) {
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(data);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(data);
        }
    }

    private synchronized StreamEvent getTraceData(String data) {
        if (this.ivEvent == null) {
            return this.createEvent(data);
        }
        StreamEvent se = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(data);
        se.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        return se;
    }

    private synchronized StreamEvent getTraceData(byte[] data) {
        if (this.ivEvent == null) {
            return this.createEvent(data);
        }
        StreamEvent se = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(data);
        se.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        return se;
    }

    private synchronized StreamEvent getTraceData(char[] data) {
        if (this.ivEvent == null) {
            return this.createEvent(data);
        }
        StreamEvent se = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(data);
        se.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        return se;
    }
}

