/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEventGenerator;
import com.ibm.ejs.ras.TraceEventGeneratorImpl;
import com.ibm.ejs.ras.TraceEventListener;
import com.ibm.ejs.ras.TraceLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Tr {
    private static ComponentManager compMgr;
    private static TraceEventGenerator svTeg;
    private static Object[] svNullParamArray;
    private static TraceLogger svStartupListener;
    private static OutputStream svSystemOut;
    private static OutputStream svSystemErr;
    private static Vector svInternalQueue;

    private Tr() {
    }

    public static TraceComponent register(String name) {
        return compMgr.register(name);
    }

    public static TraceComponent register(Class aClass) {
        return compMgr.register(aClass.getName());
    }

    public static TraceComponent register(String name, String group) {
        if (group == null || group.equals("")) {
            return compMgr.register(name);
        }
        return compMgr.register(name, group);
    }

    public static TraceComponent register(Class aClass, String group) {
        if (group == null || group.equals("")) {
            return compMgr.register(aClass.getName());
        }
        return compMgr.register(aClass.getName(), group);
    }

    public static TraceComponent register(String name, String group, String resourceBundleName) {
        TraceComponent tc = null;
        tc = group == null || group.equals("") ? compMgr.register(name) : compMgr.register(name, group);
        tc.setResourceBundleName(resourceBundleName);
        return tc;
    }

    public static TraceComponent register(Class aClass, String group, String resourceBundleName) {
        TraceComponent tc = null;
        tc = group == null || group.equals("") ? compMgr.register(aClass.getName()) : compMgr.register(aClass.getName(), group);
        tc.setResourceBundleName(resourceBundleName);
        return tc;
    }

    public static void registerDumpable(TraceComponent tc, Dumpable d) {
        compMgr.registerDumpable(tc, d);
    }

    static ComponentManager getComponentManager() {
        return compMgr;
    }

    static synchronized void addTraceEventListener(TraceEventListener listener) {
        svTeg.addTraceEventListener(listener, false);
    }

    public static final void audit(TraceComponent tc, String msgKey) {
        if (RasProperties.svFilterMessageLevel >= RasProperties.Audit) {
            svTeg.fireMessageEvent(1, tc, null, msgKey, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void audit(TraceComponent tc, String msgKey, Object objs) {
        if (RasProperties.svFilterMessageLevel >= RasProperties.Audit) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            svTeg.fireMessageEvent(1, tc, null, msgKey, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void debug(TraceComponent tc, String msg) {
        if (tc.ivDebugEnabled) {
            svTeg.fireTraceEvent(2, tc, null, msg, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void debug(TraceComponent tc, String msg, Object objs) {
        if (tc.ivDebugEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            svTeg.fireTraceEvent(2, tc, null, msg, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void dump(TraceComponent tc, String msg) {
        if (tc.ivDumpEnabled || tc.ivDebugEnabled) {
            svTeg.fireTraceEvent(3, tc, null, msg, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void dump(TraceComponent tc, String msg, Object objs) {
        if (tc.ivDumpEnabled || tc.ivDebugEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            svTeg.fireTraceEvent(3, tc, null, msg, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void error(TraceComponent tc, String msgKey) {
        svTeg.fireMessageEvent(4, tc, null, msgKey, null);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void error(TraceComponent tc, String msgKey, Object objs) {
        if (objs == null) {
            objs = svNullParamArray;
        }
        svTeg.fireMessageEvent(4, tc, null, msgKey, objs);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void event(TraceComponent tc, String msg) {
        if (tc.ivEventEnabled) {
            svTeg.fireTraceEvent(5, tc, null, msg, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void event(TraceComponent tc, String msg, Object objs) {
        if (tc.ivEventEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            svTeg.fireTraceEvent(5, tc, null, msg, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void entry(TraceComponent tc, String methodName) {
        if (tc.ivEntryEnabled) {
            svTeg.fireTraceEvent(6, tc, methodName, methodName, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void entry(TraceComponent tc, String methodName, Object objs) {
        if (tc.ivEntryEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            svTeg.fireTraceEvent(6, tc, methodName, methodName, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void exit(TraceComponent tc, String methodName) {
        if (tc.ivEntryEnabled) {
            svTeg.fireTraceEvent(7, tc, methodName, methodName, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void exit(TraceComponent tc, String methodName, Object objs) {
        if (tc.ivEntryEnabled) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            svTeg.fireTraceEvent(7, tc, methodName, methodName, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void fatal(TraceComponent tc, String msgKey) {
        svTeg.fireMessageEvent(8, tc, null, msgKey, null);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void fatal(TraceComponent tc, String msgKey, Object objs) {
        if (objs == null) {
            objs = svNullParamArray;
        }
        svTeg.fireMessageEvent(8, tc, null, msgKey, objs);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void info(TraceComponent tc, String msgKey) {
        svTeg.fireMessageEvent(11, tc, null, msgKey, null);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void info(TraceComponent tc, String msgKey, Object objs) {
        if (objs == null) {
            objs = svNullParamArray;
        }
        svTeg.fireMessageEvent(11, tc, null, msgKey, objs);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    static final void systemErr(StreamEvent event) {
        svTeg.fireRasEvent(event);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    static final void systemOut(StreamEvent event) {
        svTeg.fireRasEvent(event);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void service(TraceComponent tc, String msgKey) {
        if (RasProperties.svFilterMessageLevel >= RasProperties.Service) {
            if (RasHelper.isServer()) {
                svTeg.fireMessageEvent(9, tc, null, msgKey, null);
            } else {
                svTeg.fireMessageEvent(1, tc, null, msgKey, null);
            }
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void service(TraceComponent tc, String msgKey, Object objs) {
        if (RasProperties.svFilterMessageLevel >= RasProperties.Service) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            if (RasHelper.isServer()) {
                svTeg.fireMessageEvent(9, tc, null, msgKey, objs);
            } else {
                svTeg.fireMessageEvent(1, tc, null, msgKey, objs);
            }
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void uncondEvent(TraceComponent tc, String msg) {
        svTeg.fireTraceEvent(12, tc, null, msg, null);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void uncondEvent(TraceComponent tc, String msg, Object objs) {
        if (objs == null) {
            objs = svNullParamArray;
        }
        svTeg.fireTraceEvent(12, tc, null, msg, objs);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void uncondFormattedEvent(TraceComponent tc, String msgKey) {
        svTeg.fireMessageEvent(11, tc, null, msgKey, null);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void uncondFormattedEvent(TraceComponent tc, String msgKey, Object objs) {
        if (objs == null) {
            objs = svNullParamArray;
        }
        svTeg.fireMessageEvent(11, tc, null, msgKey, objs);
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void warning(TraceComponent tc, String msgKey) {
        if (RasProperties.svFilterMessageLevel >= RasProperties.Warning) {
            svTeg.fireMessageEvent(10, tc, null, msgKey, null);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static final void warning(TraceComponent tc, String msgKey, Object objs) {
        if (RasProperties.svFilterMessageLevel >= RasProperties.Warning) {
            if (objs == null) {
                objs = svNullParamArray;
            }
            svTeg.fireMessageEvent(10, tc, null, msgKey, objs);
        }
        if (svInternalQueue != null) {
            Tr.dispatchInternalEvents();
        }
    }

    public static void logJrasEvent(RasEvent event) {
        if (event != null) {
            svTeg.fireRasEvent(event);
        }
    }

    static synchronized void createServerStartupListener() {
        if (svStartupListener != null) {
            return;
        }
        try {
            svStartupListener = new TraceLogger(svSystemOut, true);
            svTeg.addTraceEventListener(svStartupListener, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static synchronized void removeTraceEventListener(TraceEventListener listener) {
        svTeg.removeTraceEventListener(listener);
    }

    static synchronized void replaceTraceEventListener(TraceEventListener newOne, TraceEventListener old) {
        if (svStartupListener != null) {
            svTeg.removeTraceEventListener(svStartupListener);
            svStartupListener = null;
        }
        svTeg.replaceTraceEventListener(newOne, old);
    }

    static synchronized void addJmxListener(TraceEventListener listener) {
        svTeg.addTraceEventListener(listener, true);
    }

    static synchronized void setTraceEventGenerator(TraceEventGenerator teg) {
        svTeg = teg;
    }

    static OutputStream getSystemOut() {
        return svSystemOut;
    }

    static OutputStream getSystemErr() {
        return svSystemErr;
    }

    static synchronized void queueInternalEvent(RasEvent event) {
        if (svInternalQueue == null) {
            svInternalQueue = new Vector();
        }
        svInternalQueue.addElement(event);
    }

    private static synchronized void dispatchInternalEvents() {
        if (svInternalQueue == null) {
            return;
        }
        Vector v = svInternalQueue;
        svInternalQueue = null;
        int size = v.size();
        int i = 0;
        while (i < size) {
            RasEvent event = (RasEvent)v.elementAt(i);
            Tr.logJrasEvent(event);
            ++i;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processTraceSettings() {
        InputStream s;
        String fileName;
        block21: {
            void var6_14;
            fileName = RasHelper.getSystemProperty("traceSettingsFile");
            if (fileName == null || fileName.equals("")) {
                return;
            }
            fileName = fileName.trim();
            s = null;
            s = RasHelper.getResourceAsStream(fileName);
            if (s == null) break block21;
            System.out.println("Processing Trace Settings File: " + fileName);
            Properties props = new Properties();
            props.load(s);
            Enumeration enumeration = ((Hashtable)props).keys();
            String outputFileName = null;
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (key.equalsIgnoreCase("traceFileName")) {
                    outputFileName = props.getProperty(key);
                    continue;
                }
                String string = props.getProperty(key);
                String traceString = key + "=" + string;
                try {
                    ManagerAdmin.checkTraceString(traceString);
                    compMgr.processTraceString(traceString, false);
                }
                catch (MalformedTraceStringException mtse) {
                    System.out.println("Error processing Trace String: " + ((Throwable)((Object)mtse)).getMessage());
                }
            }
            if (outputFileName == null) break block21;
            OutputStream os = null;
            if (outputFileName.equalsIgnoreCase("stdout")) {
                os = svSystemOut;
            } else {
                try {
                    RasHelper.validateFileName(outputFileName.trim());
                    os = RasHelper.createFileOutputStream(outputFileName, false);
                }
                catch (RasException rasException) {
                    System.out.println("Unable to open specified file " + outputFileName);
                    rasException.printStackTrace(System.out);
                    os = svSystemOut;
                }
            }
            Object var6_10 = null;
            if (RasProperties.svTraceFormat.equalsIgnoreCase("loganalyzer")) {
                ExtendedTraceLogger extendedTraceLogger = new ExtendedTraceLogger(os);
            } else if (RasProperties.svTraceFormat.equalsIgnoreCase("advanced")) {
                TraceLogger traceLogger = new TraceLogger(os, false);
            } else {
                TraceLogger traceLogger = new TraceLogger(os, true);
            }
            svTeg.addTraceEventListener((TraceEventListener)var6_14, false);
        }
        Object var10_17 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Throwable t) {
                System.out.println("caught exception trying to open trace properties file " + fileName);
                t.printStackTrace(System.out);
                Object var10_18 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static {
        svNullParamArray = new Object[]{null};
        svStartupListener = null;
        svSystemOut = null;
        svSystemErr = null;
        svInternalQueue = null;
        svSystemOut = System.out;
        svSystemErr = System.err;
        compMgr = new ComponentManager();
        svTeg = new TraceEventGeneratorImpl();
        RasProperties.loadProperties();
        Tr.processTraceSettings();
    }
}

