/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceEnableEvent;

public class TraceElement {
    String ivName;
    boolean ivDebugEnabled;
    boolean ivEventEnabled;
    boolean ivEntryEnabled;

    TraceElement(String name) {
        this.ivName = name;
        this.ivDebugEnabled = false;
        this.ivEventEnabled = false;
        this.ivEntryEnabled = false;
    }

    public final String getName() {
        return this.ivName;
    }

    public final boolean isDebugEnabled() {
        return this.ivDebugEnabled;
    }

    public final boolean isEventEnabled() {
        return this.ivEventEnabled;
    }

    public final boolean isEntryEnabled() {
        return this.ivEntryEnabled;
    }

    String getTraceSpecification() {
        StringBuffer b = new StringBuffer(this.ivName);
        if (this.ivDebugEnabled && this.ivEventEnabled && this.ivEntryEnabled) {
            b.append("=all=enabled");
            return new String(b);
        }
        if (!(this.ivDebugEnabled || this.ivEventEnabled || this.ivEntryEnabled)) {
            b.append("=all=disabled");
            return new String(b);
        }
        b.append(this.ivDebugEnabled ? "=debug=enabled" : "=debug=disabled");
        b.append(this.ivEventEnabled ? ",event=enabled" : ",event=disabled");
        b.append(this.ivEntryEnabled ? ",entryExit=enabled" : ",entryExit=disabled");
        return new String(b);
    }

    String getStartsWith(String prefix, int level) {
        int lenPrefix = prefix.length();
        String result = "";
        if (this.ivName.startsWith(prefix)) {
            String s = this.ivName.substring(lenPrefix);
            if (s.startsWith(".")) {
                s = s.substring(1);
            }
            String[] components = RasHelper.split(s, 46);
            StringBuffer b = new StringBuffer(s.length());
            int len = components.length;
            int i = level;
            while (i < len - 1) {
                b.append(components[i]);
                b.append('.');
                ++i;
            }
            if (level < len) {
                b.append(components[len - 1]);
            }
            result = new String(b);
        }
        return result;
    }

    void applyTraceEnableEvent(TraceEnableEvent event) {
        boolean enabled = event.enabled();
        switch (event.getType()) {
            case 0: {
                this.ivDebugEnabled = enabled;
                this.ivEventEnabled = enabled;
                this.ivEntryEnabled = enabled;
                break;
            }
            case 1: {
                this.ivDebugEnabled = enabled;
                break;
            }
            case 3: {
                this.ivEventEnabled = enabled;
                break;
            }
            case 2: {
                this.ivEntryEnabled = enabled;
            }
        }
    }
}

