/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ejs.ras.Untraceable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;

public class TraceEvent
extends RasEvent {
    private String[] ivStrings;
    byte[] ivRawData = null;
    static /* synthetic */ Class class$java$lang$Object;

    public TraceEvent(int type, TraceComponent tc, String text, Object parms, String organization, String product, String component, String className, String methodName, String extendedMessage) {
        super(type, tc, className, methodName, text, organization, product, component, extendedMessage, true);
        this.convertParameters(parms);
    }

    TraceEvent(int type, TraceComponent tc, String methodName, String msgKey, Object parms) {
        super(type, tc, null, methodName, msgKey, "IBM", "WebSphere", "Application Server", null, false);
        this.convertParameters(parms);
    }

    private void convertParameters(Object parms) {
        if (parms == null) {
            String[] x = new String[]{this.ivMsgKey};
            this.ivStrings = x;
        } else {
            Object[] objs = null;
            Class<?> objectClass = parms.getClass();
            if (objectClass.isArray()) {
                if ((class$java$lang$Object == null ? (class$java$lang$Object = TraceEvent.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(objectClass.getComponentType())) {
                    objs = (Object[])parms;
                } else {
                    objs = RasHelper.primitiveArrayToString(parms);
                    if (Byte.TYPE.equals(parms.getClass().getComponentType())) {
                        this.ivRawData = (byte[])parms;
                    }
                }
            } else {
                objs = new Object[]{parms};
            }
            int numObjs = objs.length;
            this.ivStrings = new String[numObjs + 1];
            this.ivStrings[0] = this.ivMsgKey;
            String param = null;
            int i = numObjs - 1;
            while (i >= 0) {
                if (objs[i] == null) {
                    this.ivStrings[i + 1] = "<null>";
                } else if (objs[i] instanceof String) {
                    this.ivStrings[i + 1] = (String)objs[i];
                } else {
                    try {
                        param = objs[i] instanceof Untraceable ? objs[i].getClass().getName() : (objs[i] instanceof Traceable ? ((Traceable)objs[i]).toTraceString() : (objs[i] instanceof Throwable ? RasHelper.throwableToString((Throwable)objs[i]) : objs[i].toString()));
                        if (param == null) {
                            param = "<malformed parameter>";
                        }
                        this.ivStrings[i + 1] = param;
                    }
                    catch (Throwable t) {
                        this.ivStrings[i + 1] = "<malformed parameter>";
                    }
                }
                --i;
            }
        }
    }

    final String[] getStrs() {
        return this.ivStrings;
    }

    public String formatBasic(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        this.formatHeaderBasic(buffer, formatter, date, fPos);
        buffer.append(this.ivStrings[0]);
        int length = this.ivStrings.length;
        int i = 1;
        while (i < length) {
            buffer.append(RasEvent.lineSeparator);
            buffer.append(RasEvent.svBasicPadding);
            buffer.append(this.ivStrings[i]);
            ++i;
        }
        return new String(buffer);
    }

    public String formatAdvanced(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        this.formatHeaderAdvanced(buffer, formatter, date, fPos);
        int length = this.ivStrings.length;
        if (length == 1 && this.ivStrings[0].equals("")) {
            return new String(buffer);
        }
        buffer.append(RasEvent.lineSeparator);
        buffer.append(RasEvent.svAdvancedPadding);
        buffer.append(this.ivStrings[0]);
        int i = 1;
        while (i < length) {
            buffer.append(" parm");
            buffer.append(i);
            buffer.append("=");
            buffer.append(this.ivStrings[i]);
            ++i;
        }
        return new String(buffer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

