/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ComponentManager;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasEvent;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventGenerator;
import com.ibm.ejs.ras.TraceEventListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

class TraceEventGeneratorImpl
implements TraceEventGenerator {
    private Vector listeners = new Vector();
    private TraceEventListener[] svEventListeners = null;
    private TraceEventListener jmxListener;

    TraceEventGeneratorImpl() {
    }

    public void addTraceEventListener(TraceEventListener listener, boolean first) {
        if (listener != null) {
            if (first) {
                this.jmxListener = listener;
            } else {
                Vector vector = this.listeners;
                synchronized (vector) {
                    if (first) {
                        this.listeners.insertElementAt(listener, 0);
                    } else {
                        this.listeners.addElement(listener);
                    }
                    this.svEventListeners = null;
                }
            }
        }
    }

    public void removeTraceEventListener(TraceEventListener listener) {
        if (listener != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.removeElement(listener);
                this.svEventListeners = null;
            }
        }
    }

    public void replaceTraceEventListener(TraceEventListener newOne, TraceEventListener old) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (old != null) {
                this.listeners.removeElement(old);
            }
            if (newOne != null) {
                this.listeners.addElement(newOne);
            }
            this.svEventListeners = null;
        }
    }

    public void fireMessageEvent(int type, TraceComponent tc, String methodName, String msg, Object objs) {
        MessageEvent event = new MessageEvent(type, tc, null, msg, objs);
        this.fireMessageEvent(event);
        this.fireJMXMessage(event);
    }

    public void fireTraceEvent(int type, TraceComponent tc, String methodName, String msg, Object objs) {
        TraceEvent event = new TraceEvent(type, tc, null, msg, objs);
        this.fireTraceEvent(event);
    }

    public void fireRasEvent(RasEvent event) {
        if (event == null) {
            return;
        }
        if (event instanceof MessageEvent) {
            MessageEvent me = (MessageEvent)event;
            this.fireMessageEvent(me);
            this.fireJMXMessage(me);
        } else if (event instanceof TraceEvent) {
            TraceEvent te = (TraceEvent)event;
            this.fireTraceEvent(te);
        } else {
            StreamEvent sse = (StreamEvent)event;
            this.fireStreamEvent(sse);
        }
    }

    private synchronized void fireMessageEvent(MessageEvent event) {
        TraceEventListener[] l;
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.svEventListeners == null) {
                this.svEventListeners = new TraceEventListener[this.listeners.size()];
                this.listeners.copyInto(this.svEventListeners);
            }
            l = this.svEventListeners;
        }
        int i = l.length - 1;
        while (i >= 0) {
            switch (event.ivType) {
                case 11: {
                    l[i].infoEvent(event);
                    break;
                }
                case 1: {
                    l[i].auditEvent(event);
                    break;
                }
                case 9: {
                    l[i].serviceEvent(event);
                    break;
                }
                case 10: {
                    l[i].warningEvent(event);
                    break;
                }
                case 4: {
                    l[i].errorEvent(event);
                    break;
                }
                case 8: {
                    l[i].fatalEvent(event);
                    if (!ComponentManager.svTraceEnabled) break;
                    String logRootDir = null;
                    try {
                        logRootDir = RasProperties.getDefaultLoggingDirectory() + File.separator;
                    }
                    catch (RasException re) {
                        logRootDir = "." + File.separator;
                    }
                    String serverName = null;
                    int index = RasHelper.getServerName().lastIndexOf(92);
                    serverName = index != -1 ? RasHelper.getServerName().substring(index + 1) : RasHelper.getServerName();
                    SimpleDateFormat sdf = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
                    Date date = new Date(event.ivTimeStamp);
                    String ts = sdf.format(date);
                    String dumpFilename = logRootDir + serverName + "FatalError" + ts + ".log";
                    ManagerAdmin.dumpRingBuffer(dumpFilename);
                }
            }
            --i;
        }
    }

    private void fireJMXMessage(MessageEvent event) {
        if (this.jmxListener == null) {
            return;
        }
        switch (event.ivType) {
            case 11: {
                this.jmxListener.infoEvent(event);
                break;
            }
            case 1: {
                this.jmxListener.auditEvent(event);
                break;
            }
            case 9: {
                this.jmxListener.serviceEvent(event);
                break;
            }
            case 10: {
                this.jmxListener.warningEvent(event);
                break;
            }
            case 4: {
                this.jmxListener.errorEvent(event);
                break;
            }
            case 8: {
                this.jmxListener.fatalEvent(event);
            }
        }
    }

    private synchronized void fireTraceEvent(TraceEvent event) {
        TraceEventListener[] l;
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.svEventListeners == null) {
                this.svEventListeners = new TraceEventListener[this.listeners.size()];
                this.listeners.copyInto(this.svEventListeners);
            }
            l = this.svEventListeners;
        }
        int i = l.length - 1;
        while (i >= 0) {
            switch (event.ivType) {
                case 2: {
                    l[i].debugEvent(event);
                    break;
                }
                case 3: {
                    l[i].dumpEvent(event);
                    break;
                }
                case 5: {
                    l[i].eventEvent(event);
                    break;
                }
                case 6: {
                    l[i].entryEvent(event);
                    break;
                }
                case 7: {
                    l[i].exitEvent(event);
                    break;
                }
                case 12: {
                    l[i].uncondTraceEvent(event);
                }
            }
            --i;
        }
    }

    private synchronized void fireStreamEvent(StreamEvent event) {
        TraceEventListener[] l;
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.svEventListeners == null) {
                this.svEventListeners = new TraceEventListener[this.listeners.size()];
                this.listeners.copyInto(this.svEventListeners);
            }
            l = this.svEventListeners;
        }
        int i = l.length - 1;
        while (i >= 0) {
            switch (event.ivType) {
                case 13: {
                    l[i].systemOutEvent(event);
                    break;
                }
                case 14: {
                    l[i].systemErrEvent(event);
                }
            }
            --i;
        }
    }
}

