/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent;
import com.ibm.ejs.ras.TraceEvent;
import com.ibm.ejs.ras.TraceEventListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;

class TraceLogger
implements TraceEventListener,
LogRolloverListener {
    private boolean ivBasicFormat;
    OutputStream ivOs;
    PrintWriter ivOut;
    protected StringBuffer ivBuffer = new StringBuffer();
    protected DateFormat ivFormatter;
    protected Date ivDate = new Date();
    protected FieldPosition ivFieldPos = new FieldPosition(0);

    TraceLogger(OutputStream stream) {
        this.ivOs = stream;
        this.ivOut = new PrintWriter(stream, true);
    }

    TraceLogger(OutputStream stream, boolean isBasicFormat) {
        this(stream);
        this.ivFormatter = RasHelper.getBasicDateFormatter();
        this.ivBasicFormat = isBasicFormat;
    }

    public synchronized void logRolled() {
        this.printHeader();
    }

    public void auditEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void debugEvent(TraceEvent event) {
        this.logTrace(event);
    }

    public void dumpEvent(TraceEvent event) {
        this.logTrace(event);
    }

    public void errorEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void eventEvent(TraceEvent event) {
        this.logTrace(event);
    }

    public void entryEvent(TraceEvent event) {
        this.logTrace(event);
    }

    public void exitEvent(TraceEvent event) {
        this.logTrace(event);
    }

    public void fatalEvent(MessageEvent event) {
        this.logMessage(event);
        Throwable t = new Throwable();
        t.printStackTrace(this.ivOut);
    }

    public void infoEvent(MessageEvent event) {
        this.logMessage(event);
    }

    public void serviceEvent(MessageEvent event) {
    }

    public void systemErrEvent(StreamEvent event) {
        this.logSystemStream(event);
    }

    public void systemOutEvent(StreamEvent event) {
        this.logSystemStream(event);
    }

    public void uncondTraceEvent(TraceEvent event) {
        this.logTrace(event);
    }

    public void warningEvent(MessageEvent event) {
        this.logMessage(event);
    }

    synchronized void logMessage(MessageEvent event) {
        if (event == null) {
            return;
        }
        if (this.ivBasicFormat) {
            this.ivOut.println(event.formatBasic(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos));
        } else {
            this.ivOut.println(event.formatAdvanced(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos));
        }
    }

    synchronized void logTrace(TraceEvent event) {
        if (event == null) {
            return;
        }
        if (this.ivBasicFormat) {
            this.ivOut.println(event.formatBasic(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos));
        } else {
            this.ivOut.println(event.formatAdvanced(this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos));
        }
    }

    synchronized void logSystemStream(StreamEvent event) {
        if (event == null) {
            return;
        }
        if (this.ivBasicFormat) {
            event.writeSelfToStream(this.ivOut, "basic", true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
        } else {
            event.writeSelfToStream(this.ivOut, "advanced", true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
        }
    }

    synchronized void printHeader() {
        String javaVersion;
        String headLine = "************ Start Display Current Environment ************";
        String tailLine = "************* End Display Current Environment *************";
        String server = "WebSphere {0} running with process name {1} and process id {2}";
        String os = "Host Operating System is {0}, version {1}";
        String jvm = "Java version = {0}, Java Compiler = {1}, Java VM name = {2}";
        String sysRoot = "was.install.root = {0}";
        String userRoot = "user.install.root = {0}";
        String jhome = "Java Home = {0}";
        String wsext = "ws.ext.dirs = {0}";
        String cp = "Classpath = {0}";
        String lp = "Java Library path = {0}";
        String ts = "Current trace specification = {0}";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println(headLine);
        String version = RasHelper.getVersionId();
        if (version != null && !version.equals("")) {
            pw.println(MessageFormat.format(server, version, RasHelper.getServerName(), RasHelper.getProcessId()));
        }
        if ((javaVersion = RasHelper.getSystemProperty("java.fullversion")) == null) {
            javaVersion = RasHelper.getSystemProperty("java.version");
        }
        String a = RasHelper.getSystemProperty("os.name");
        String b = RasHelper.getSystemProperty("os.version");
        pw.println(MessageFormat.format(os, a, b));
        a = RasHelper.getSystemProperty("java.compiler");
        b = RasHelper.getSystemProperty("java.vm.name");
        pw.println(MessageFormat.format(jvm, javaVersion, a, b));
        pw.println(MessageFormat.format(sysRoot, RasHelper.getSystemProperty("was.install.root")));
        pw.println(MessageFormat.format(userRoot, RasHelper.getSystemProperty("user.install.root")));
        pw.println(MessageFormat.format(jhome, RasHelper.getSystemProperty("java.home")));
        pw.println(MessageFormat.format(wsext, RasHelper.getSystemProperty("ws.ext.dirs")));
        pw.println(MessageFormat.format(cp, RasHelper.getSystemProperty("java.class.path")));
        pw.println(MessageFormat.format(lp, RasHelper.getSystemProperty("java.library.path")));
        pw.println(MessageFormat.format(ts, ManagerAdmin.getTraceSpecification()));
        pw.println(tailLine);
        pw.flush();
        byte[] bytes = baos.toByteArray();
        try {
            this.ivOs.write(bytes);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }
}

