/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASHandler;
import com.ibm.ras.RASUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class RASConsoleHandler
extends RASHandler {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = -3408886461563487379L;

    public RASConsoleHandler() {
    }

    public RASConsoleHandler(String name) {
        super(name);
    }

    public RASConsoleHandler(String name, String desc) {
        super(name, desc);
    }

    public void openDevice() {
        this.closeDevice();
        this.openPrintStream(System.out);
    }

    protected void openPrintStream(PrintStream stream) {
        Object object = this.deviceLock;
        synchronized (object) {
            block5: {
                try {
                    String codePage = RASUtil.getConsoleCodePage();
                    OutputStreamWriter osw = codePage != null && this.getClass().getClassLoader() == null ? new OutputStreamWriter((OutputStream)stream, codePage) : new OutputStreamWriter(stream);
                    this.pWriter = new PrintWriter((Writer)osw, true);
                    this.deviceOpen = true;
                }
                catch (Exception e) {
                    if (++this.deviceFailures > 2) break block5;
                    RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_OPEN_FILE", stream));
                    e.printStackTrace();
                }
            }
        }
    }

    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.pWriter = null;
            this.deviceOpen = false;
        }
    }
}

