/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASTraceEvent;
import com.ibm.ras.RASTraceFormatter;

public class RASEnhancedTraceFormatter
extends RASTraceFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 6797520221459165451L;
    private static final String SPACE = "  ";
    private static final String TIME = "Time:     ";
    private static final String CLASS_NAME = "Class:    ";
    private static final String METHOD_NAME = "Method:   ";
    private static final String THREAD_ID = "Thread ID:";
    private static final String LOGGER = "Logger:   ";

    public String format(RASIEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        RASTraceEvent tevent = (RASTraceEvent)event;
        long timeStamp = tevent.getTimeStamp();
        bfr.append("Time:       " + this.getTime(timeStamp) + this.lineSep);
        Object item = tevent.getAttribute("loggingClass");
        if (item != null) {
            bfr.append("Class:      " + item + this.lineSep);
        }
        if ((item = tevent.getAttribute("loggingMethod")) != null) {
            bfr.append("Method:     " + item + this.lineSep);
        }
        if ((item = tevent.getAttribute("threadID")) != null) {
            bfr.append("Thread ID:  " + item + this.lineSep);
        }
        if ((item = tevent.getAttribute("logger")) != null) {
            bfr.append("Logger:     " + item + this.lineSep);
        }
        bfr.append(SPACE + this.getText(tevent));
        return bfr.toString();
    }
}

