/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASUtil;
import java.util.Hashtable;

public class RASEvent
implements RASIEvent,
RASConstants {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 1940479735618402090L;
    private boolean isMessageEvent;
    private long type = 0L;
    private long timeStamp;
    private String msgText = "";
    private String[] msgParms = null;
    private Hashtable attribs = null;

    protected static String[] objectsToStrings(Object[] parms) {
        String nullMsg = null;
        String[] inserts = null;
        if (parms != null) {
            inserts = new String[parms.length];
            int j = 0;
            while (j < parms.length) {
                if (parms[j] == null) {
                    if (nullMsg == null) {
                        nullMsg = RASUtil.rasMsgs.getMessage("NULL_OBJECT");
                    }
                    inserts[j] = nullMsg;
                } else {
                    inserts[j] = parms[j].toString();
                }
                ++j;
            }
        }
        return inserts;
    }

    public RASEvent() {
        this.setTimeStamp(System.currentTimeMillis());
    }

    public RASEvent(long type, String text, Object[] parms) {
        this();
        this.setType(type);
        this.setText(text);
        this.setParameters(RASEvent.objectsToStrings(parms));
    }

    public RASEvent(long type, String text, String[] parms) {
        this(type, text, (Object[])parms);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getType() {
        return this.type;
    }

    public void setType(long type) {
        this.type = type;
    }

    public String getText() {
        return this.msgText;
    }

    public void setText(String text) {
        if (text != null) {
            this.msgText = text;
        }
    }

    public String[] getParameters() {
        return this.msgParms;
    }

    public void setParameters(String[] parms) {
        this.msgParms = parms;
    }

    public Object getAttribute(String name) {
        Object attrib = null;
        if (name != null && this.attribs != null) {
            attrib = this.attribs.get(name);
        }
        return attrib;
    }

    public void setAttribute(String name, Object attrib) {
        if (name != null && attrib != null) {
            if (this.attribs == null) {
                this.attribs = new Hashtable();
            }
            this.attribs.put(name, attrib);
        }
    }

    public void setMessageEvent(boolean flag) {
        this.isMessageEvent = flag;
    }

    public boolean isMessageEvent() {
        return this.isMessageEvent;
    }

    public Hashtable getSupportedTypes() {
        return new Hashtable();
    }

    public long maskLongValue(String types) {
        return 0L;
    }

    public String maskToString(long types) {
        return "";
    }
}

