/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIMaskChangeGenerator;
import com.ibm.ras.RASIMaskChangeListener;
import com.ibm.ras.RASMaskChangeEvent;
import com.ibm.ras.RASObject;
import com.ibm.ras.RASUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RASMaskChangeGenerator
extends RASObject
implements RASIMaskChangeGenerator {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 338264656140674871L;
    private long messageMask;
    private long traceMask;
    private Vector messageEventClasses;
    private Vector traceEventClasses;
    private Vector maskChangeListeners;

    public RASMaskChangeGenerator() {
    }

    public RASMaskChangeGenerator(String name) {
        super(name);
    }

    public RASMaskChangeGenerator(String name, String desc) {
        super(name, desc);
    }

    protected void init() {
        super.init();
        if (this.maskChangeListeners == null) {
            this.maskChangeListeners = new Vector();
        }
        this.messageEventClasses = new Vector();
        this.traceEventClasses = new Vector();
        this.setMessageMask(7L);
        this.setTraceMask(2047L);
    }

    public Hashtable getConfig() {
        Hashtable ht = super.getConfig();
        ht.put("messageEventClasses", RASUtil.vectorToString(this.messageEventClasses));
        ht.put("traceEventClasses", RASUtil.vectorToString(this.traceEventClasses));
        ht.put("messageMask", this.messageMaskToString(this.getMessageMask()));
        ht.put("traceMask", this.traceMaskToString(this.getTraceMask()));
        return ht;
    }

    public void setConfig(Hashtable ht) {
        super.setConfig(ht);
        if (ht.containsKey("messageEventClasses")) {
            this.messageEventClasses = RASUtil.stringToVector((String)ht.get("messageEventClasses"));
        }
        if (ht.containsKey("traceEventClasses")) {
            this.traceEventClasses = RASUtil.stringToVector((String)ht.get("traceEventClasses"));
        }
        if (ht.containsKey("messageMask")) {
            this.setMessageMask(this.messageMaskLongValue((String)ht.get("messageMask")));
        }
        if (ht.containsKey("traceMask")) {
            this.setTraceMask(this.traceMaskLongValue((String)ht.get("traceMask")));
        }
    }

    public long getMessageMask() {
        return this.messageMask;
    }

    public void setMessageMask(long mask) {
        RASMaskChangeEvent mc = new RASMaskChangeEvent(this, this.messageMask, mask, true);
        this.messageMask = mask;
        this.fireMaskChangedEvent(mc);
    }

    public long getTraceMask() {
        return this.traceMask;
    }

    public void setTraceMask(long mask) {
        RASMaskChangeEvent mc = new RASMaskChangeEvent(this, this.traceMask, mask, false);
        this.traceMask = mask;
        this.fireMaskChangedEvent(mc);
    }

    public void addMaskChangeListener(RASIMaskChangeListener listener) {
        if (listener != null && !this.maskChangeListeners.contains(listener)) {
            this.maskChangeListeners.addElement(listener);
        }
    }

    public void removeMaskChangeListener(RASIMaskChangeListener listener) {
        if (listener != null && this.maskChangeListeners.contains(listener)) {
            this.maskChangeListeners.removeElement(listener);
        }
    }

    public Enumeration getMaskChangeListeners() {
        return this.maskChangeListeners.elements();
    }

    public void fireMaskChangedEvent(RASMaskChangeEvent mc) {
        Enumeration e = this.getMaskChangeListeners();
        while (e.hasMoreElements()) {
            RASIMaskChangeListener c = (RASIMaskChangeListener)e.nextElement();
            c.maskValueChanged(mc);
        }
    }

    public void addMessageEventClass(String name) {
        if (name != null && !this.messageEventClasses.contains(name)) {
            this.messageEventClasses.addElement(name);
        }
    }

    public void removeMessageEventClass(String name) {
        if (name != null && this.messageEventClasses.contains(name)) {
            this.messageEventClasses.removeElement(name);
        }
    }

    public Enumeration getMessageEventClasses() {
        return this.messageEventClasses.elements();
    }

    public void addTraceEventClass(String name) {
        if (name != null && !this.traceEventClasses.contains(name)) {
            this.traceEventClasses.addElement(name);
        }
    }

    public void removeTraceEventClass(String name) {
        if (name != null && this.traceEventClasses.contains(name)) {
            this.traceEventClasses.removeElement(name);
        }
    }

    public Enumeration getTraceEventClasses() {
        return this.traceEventClasses.elements();
    }

    public long messageMaskLongValue(String types) {
        return this.maskLongValue(this.getMessageEventClasses(), types);
    }

    public String messageMaskToString(long types) {
        return this.maskToString(this.getMessageEventClasses(), types);
    }

    public long traceMaskLongValue(String types) {
        return this.maskLongValue(this.getTraceEventClasses(), types);
    }

    public String traceMaskToString(long types) {
        return this.maskToString(this.getTraceEventClasses(), types);
    }

    private long maskLongValue(Enumeration e, String types) {
        long mask = 0L;
        if (e != null && types != null) {
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                RASIEvent event = (RASIEvent)RASUtil.createObject(name);
                if (event == null) continue;
                mask |= event.maskLongValue(types);
            }
        }
        return mask;
    }

    private String maskToString(Enumeration e, long types) {
        StringBuffer bfr = new StringBuffer();
        if (e != null) {
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                RASIEvent event = (RASIEvent)RASUtil.createObject(name);
                if (event == null) continue;
                bfr.append(event.maskToString(types));
                bfr.append(" ");
            }
        }
        return bfr.toString();
    }
}

