/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class RASMessageCatalog {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final String PROP_FILE = "/RASMessageCatalog/catalog.properties";
    private static final String KEY_DEBUG = "debug";
    private boolean debug = false;
    private Locale locale = Locale.getDefault();
    private MessageFormat msgFormatter = new MessageFormat("");
    private ResourceBundle msgBundle;
    private String baseName = null;

    public RASMessageCatalog(String baseName) throws MissingResourceException {
        this(baseName, (Locale)null);
    }

    public RASMessageCatalog(String baseName, Locale loc) throws MissingResourceException {
        this.baseName = baseName;
        this.setLocale(loc);
        this.msgBundle = ResourceBundle.getBundle(baseName, this.getLocale());
        this.checkDebugOverride();
    }

    public RASMessageCatalog(ResourceBundle bundle) {
        this.msgBundle = bundle;
        this.checkDebugOverride();
    }

    public RASMessageCatalog(ResourceBundle bundle, Locale loc) {
        this(bundle);
        this.setLocale(loc);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale loc) {
        if (loc != null) {
            this.locale = loc;
            this.msgFormatter.setLocale(this.locale);
            if (this.baseName != null) {
                this.msgBundle = ResourceBundle.getBundle(this.baseName, this.getLocale());
            }
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    private void checkDebugOverride() {
        InputStream is = this.getClass().getResourceAsStream(PROP_FILE);
        if (is != null) {
            try {
                Properties props = new Properties();
                BufferedInputStream bis = new BufferedInputStream(is);
                props.load(bis);
                bis.close();
                String debugFlag = props.getProperty(KEY_DEBUG);
                if (debugFlag.equals("true")) {
                    this.setDebug(true);
                } else if (debugFlag.equals("false")) {
                    this.setDebug(false);
                }
            }
            catch (Exception e) {
                RASUtil.rasMsgs.getMessage("ERR_DEBUG_PROP", PROP_FILE);
                e.printStackTrace();
            }
        }
    }

    public String getMessage(String key) throws MissingResourceException {
        return this.getMessage(key, null);
    }

    public String getMessage(String key, Object insert1) throws MissingResourceException {
        Object[] inserts = new Object[]{insert1};
        return this.getMessage(key, inserts);
    }

    public String getMessage(String key, Object insert1, Object insert2) throws MissingResourceException {
        Object[] inserts = new Object[]{insert1, insert2};
        return this.getMessage(key, inserts);
    }

    /*
     * Unable to fully structure code
     */
    public String getMessage(String key, Object[] inserts) throws MissingResourceException {
        msg = this.msgBundle.getString(key);
        if (inserts != null) {
            block9: {
                this.msgFormatter.applyPattern(msg);
                inserts = RASUtil.checkNullObjects(inserts);
                bfr = new StringBuffer();
                try {
                    bfr = this.msgFormatter.format(inserts, bfr, (FieldPosition)null);
                    break block9;
                }
                catch (IllegalArgumentException e1) {
                    j = 0;
                    ** while (j < inserts.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (!(inserts[j] instanceof Number) && !(inserts[j] instanceof Date)) {
                        inserts[j] = inserts[j].toString();
                    }
                    ++j;
                    continue;
                }
lbl16:
                // 1 sources

                bfr = new StringBuffer();
                try {
                    bfr = this.msgFormatter.format(inserts, bfr, (FieldPosition)null);
                    break block9;
                }
                catch (IllegalArgumentException e2) {
                    bfr = new StringBuffer();
                    bfr.append(msg);
                    j = 0;
                    ** while (j < inserts.length)
                }
lbl-1000:
                // 1 sources

                {
                    bfr.append(", p" + (j + 1) + "=" + inserts[j].toString());
                    ++j;
                    continue;
                }
            }
            msg = bfr.toString();
        }
        if (this.isDebug()) {
            msg = "[" + msg + "]";
        }
        return msg;
    }

    /*
     * Unable to fully structure code
     */
    public String getMsg(String key, Object[] inserts) {
        block8: {
            block9: {
                bfr = new StringBuffer(256);
                try {
                    bfr.append(this.getMessage(key, inserts));
                    break block8;
                }
                catch (MissingResourceException e) {
                    if (this.isDebug()) {
                        bfr.append("[");
                    }
                    if (this.baseName == null) {
                        bfr.append(RASUtil.rasMsgs.getMessage("ERR_MISSING_KEY_NO_FILE", key));
                    } else {
                        bfr.append(RASUtil.rasMsgs.getMessage("ERR_MISSING_KEY", key, this.baseName));
                    }
                    if (inserts == null) {
                        bfr.append(".");
                        break block9;
                    }
                    inserts = RASUtil.checkNullObjects(inserts);
                    j = 0;
                    ** while (j < inserts.length)
                }
lbl-1000:
                // 1 sources

                {
                    bfr.append(", p" + (j + 1) + "=" + inserts[j].toString());
                    ++j;
                    continue;
                }
            }
            if (this.isDebug()) {
                bfr.append("]");
            }
        }
        return bfr.toString();
    }

    public char getChar(String key) {
        String temp = this.getMessage(key);
        char c = this.isDebug() ? temp.charAt(1) : temp.charAt(0);
        return c;
    }
}

