/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASMultiFileHandler;
import com.ibm.ras.RASUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class RASSerialFileHandler
extends RASMultiFileHandler {
    private static final String S = "(C) Copyright IBM Corp. 1999.";
    static final long serialVersionUID = -7658382020079098965L;
    private transient File outputFile = null;
    private transient ObjectOutput objectOutput = null;

    public RASSerialFileHandler() {
    }

    public RASSerialFileHandler(String name) {
        super(name);
    }

    public RASSerialFileHandler(String name, String desc) {
        super(name, desc);
    }

    public RASSerialFileHandler(String name, String desc, String file) {
        super(name, desc, file);
    }

    public void openDevice() {
        long fileSize = -1L;
        String fileName = this.getFileName();
        Object object = this.deviceLock;
        synchronized (object) {
            block7: {
                if (this.outputFile != null) {
                    fileSize = this.outputFile.length();
                }
                long maxFileSize = this.getMaxFileSize() * 1024;
                if (!this.deviceOpen || fileSize >= maxFileSize) {
                    this.closeDevice();
                    Vector dirList = this.getDirList(this.fileDir);
                    dirList = this.deleteExtraFiles(dirList, this.fileDir);
                    this.renameFiles(dirList, this.fileDir);
                    try {
                        RASUtil.makePath(fileName);
                        this.objectOutput = new ObjectOutputStream(new FileOutputStream(fileName, true));
                        this.outputFile = new File(fileName);
                        this.deviceOpen = true;
                    }
                    catch (Exception e) {
                        if (++this.deviceFailures > 2) break block7;
                        RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_OPEN_FILE", fileName));
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            super.closeDevice();
            try {
                if (this.objectOutput != null) {
                    this.objectOutput.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputFile = null;
            this.objectOutput = null;
        }
    }

    public void writeEvent(RASIEvent event) {
        this.openDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            block7: {
                if (this.deviceOpen) {
                    try {
                        this.objectOutput.writeObject(event);
                        this.objectOutput.flush();
                        if (this.deviceFailures != 0) {
                            RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("RETRY_OK", this.getName()));
                            this.deviceFailures = 0;
                        }
                    }
                    catch (Exception e) {
                        this.closeDevice();
                        if (++this.deviceFailures > 2) break block7;
                        RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_WRITE_MSG", this.getName()));
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector readSerializedEvents() {
        ObjectInput in = null;
        Vector<RASIEvent> events = new Vector<RASIEvent>();
        Object object = this.deviceLock;
        synchronized (object) {
            block17: {
                this.closeDevice();
                Vector dirList = this.getDirList(this.fileDir);
                int j = 0;
                while (j < dirList.size()) {
                    String file = this.fileDir + dirList.elementAt(j);
                    in = new ObjectInputStream(new FileInputStream(file));
                    boolean done = false;
                    while (!done) {
                        try {
                            events.addElement((RASIEvent)in.readObject());
                        }
                        catch (EOFException e) {
                            done = true;
                        }
                    }
                    in.close();
                    ++j;
                }
                Object var10_10 = null;
                if (in == null) return events;
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                {
                    break block17;
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var10_11 = null;
                        if (in == null) return events;
                        try {
                            in.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
            }
            return events;
        }
    }
}

