/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFormatter;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASTraceEvent;
import java.io.StringWriter;

public class RASTraceFormatter
extends RASFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = -5685726042408116109L;
    protected static String[] attribs = new String[]{"loggingClass", "loggingMethod", "threadID", "logger"};

    public RASTraceFormatter() {
        this.addEventClass("com.ibm.ras.RASTraceEvent");
    }

    public String format(RASIEvent event) {
        String sep = this.getSeparator();
        StringBuffer bfr = new StringBuffer(256);
        bfr.append(this.getTime(event.getTimeStamp()) + sep);
        int j = 0;
        while (j < attribs.length) {
            String attrib = (String)event.getAttribute(attribs[j]);
            if (attrib != null) {
                bfr.append(attrib + sep);
            }
            ++j;
        }
        bfr.append(this.lineSep);
        bfr.append("  ");
        bfr.append(this.getText((RASTraceEvent)event));
        return bfr.toString();
    }

    protected String getText(RASTraceEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        String stackTrace = (String)event.getAttribute("exceptionTrace");
        byte[] data = (byte[])event.getAttribute("hexData");
        if (stackTrace != null) {
            bfr.append(stackTrace);
        } else if (data != null) {
            bfr.append(this.bytesToHex(data));
        } else {
            bfr.append(event.getText());
            String[] parms = event.getParameters();
            if (parms != null) {
                int j = 0;
                while (j < parms.length) {
                    bfr.append(", p" + (j + 1) + "=" + parms[j]);
                    ++j;
                }
            }
        }
        if (stackTrace == null) {
            bfr.append(this.lineSep);
        }
        return bfr.toString();
    }

    protected String bytesToHex(byte[] data) {
        int byteCount = 1;
        StringWriter sw = new StringWriter();
        int lineStart = 0;
        while (lineStart < data.length) {
            int lineEnd = Math.min(lineStart + 32, data.length);
            StringBuffer asciiLine = new StringBuffer();
            int i = lineStart;
            while (i < lineEnd) {
                int b = data[i];
                if (b < 0) {
                    b += 256;
                }
                String hexStr = Integer.toString(b, 16).toUpperCase();
                if (b < 16) {
                    hexStr = "0" + hexStr;
                }
                sw.write(hexStr);
                if (byteCount % 16 == 0) {
                    sw.write("  ");
                } else if (byteCount % 2 == 0) {
                    sw.write(" ");
                }
                ++byteCount;
                if (b >= 32 && b <= 126) {
                    asciiLine.append((char)b);
                } else {
                    asciiLine.append('.');
                }
                ++i;
            }
            int padding = 32 - (lineEnd - lineStart);
            int j = 0;
            while (j < padding) {
                sw.write("  ");
                if (byteCount % 16 == 0) {
                    sw.write("  ");
                } else if (byteCount % 2 == 0) {
                    sw.write(" ");
                }
                ++byteCount;
                ++j;
            }
            sw.write(asciiLine.toString());
            sw.write(this.lineSep);
            sw.write("  ");
            lineStart += 32;
        }
        return sw.toString();
    }
}

