/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASITraceEvent;
import com.ibm.ras.RASITraceLogger;
import com.ibm.ras.RASLogger;
import com.ibm.ras.RASMaskChangeEvent;
import com.ibm.ras.RASStackTrace;
import com.ibm.ras.RASTraceEvent;
import java.util.Enumeration;

public class RASTraceLogger
extends RASLogger
implements RASITraceLogger,
RASITraceEvent {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 1591839978606424893L;
    public static final String ENTRY = "Entry";
    public static final String EXIT = "Exit";

    public RASTraceLogger() {
    }

    public RASTraceLogger(String name) {
        super(name);
    }

    public RASTraceLogger(String name, String desc) {
        super(name, desc);
    }

    public RASTraceLogger(String name, String desc, String server, String client) {
        super(name, desc);
        this.setServer(server);
        this.setClient(client);
    }

    protected void init() {
        super.init();
        this.addTraceEventClass("com.ibm.ras.RASTraceEvent");
    }

    public void entry(long type, Object obj, String methodName) {
        if (this.isLoggable(type |= 4L)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, ENTRY, null, null);
        }
    }

    public void entry(long type, Object obj, String methodName, Object parm1) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{parm1};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, ENTRY, parms, null);
        }
    }

    public void entry(long type, Object obj, String methodName, Object parm1, Object parm2) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{parm1, parm2};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, ENTRY, parms, null);
        }
    }

    public void entry(long type, Object obj, String methodName, Object[] parms) {
        if (this.isLoggable(type |= 4L)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, ENTRY, parms, null);
        }
    }

    public void entry(long type, String className, String methodName) {
        if (this.isLoggable(type |= 4L)) {
            this.logTrace(type, className, methodName, ENTRY, null, null);
        }
    }

    public void entry(long type, String className, String methodName, Object parm1) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{parm1};
            this.logTrace(type, className, methodName, ENTRY, parms, null);
        }
    }

    public void entry(long type, String className, String methodName, Object parm1, Object parm2) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{parm1, parm2};
            this.logTrace(type, className, methodName, ENTRY, parms, null);
        }
    }

    public void entry(long type, String className, String methodName, Object[] parms) {
        if (this.isLoggable(type |= 4L)) {
            this.logTrace(type, className, methodName, ENTRY, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName) {
        if (this.isLoggable(type |= 4L)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, null, null);
        }
    }

    public void exit(long type, Object obj, String methodName, byte retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Byte(retValue)};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName, short retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Short(retValue)};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName, int retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Integer(retValue)};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName, long retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Long(retValue)};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName, float retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Float(retValue)};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName, double retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Double(retValue)};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName, char retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Character(retValue)};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName, boolean retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, Object obj, String methodName, Object retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{retValue};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName) {
        if (this.isLoggable(type |= 4L)) {
            this.logTrace(type, className, methodName, EXIT, null, null);
        }
    }

    public void exit(long type, String className, String methodName, byte retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Byte(retValue)};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName, short retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Short(retValue)};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName, int retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Integer(retValue)};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName, long retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Long(retValue)};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName, float retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Float(retValue)};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName, double retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Double(retValue)};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName, char retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Character(retValue)};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName, boolean retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void exit(long type, String className, String methodName, Object retValue) {
        if (this.isLoggable(type |= 4L)) {
            Object[] parms = new Object[]{retValue};
            this.logTrace(type, className, methodName, EXIT, parms, null);
        }
    }

    public void trace(long type, Object obj, String methodName, String text) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, text, null, null);
        }
    }

    public void trace(long type, Object obj, String methodName, String text, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, text, parms, null);
        }
    }

    public void trace(long type, Object obj, String methodName, String text, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, text, parms, null);
        }
    }

    public void trace(long type, Object obj, String methodName, String text, Object[] parms) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, text, parms, null);
        }
    }

    public void trace(long type, String className, String methodName, String text) {
        if (this.isLoggable(type)) {
            this.logTrace(type, className, methodName, text, null, null);
        }
    }

    public void trace(long type, String className, String methodName, String text, Object parm1) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1};
            this.logTrace(type, className, methodName, text, parms, null);
        }
    }

    public void trace(long type, String className, String methodName, String text, Object parm1, Object parm2) {
        if (this.isLoggable(type)) {
            Object[] parms = new Object[]{parm1, parm2};
            this.logTrace(type, className, methodName, text, parms, null);
        }
    }

    public void trace(long type, String className, String methodName, String text, Object[] parms) {
        if (this.isLoggable(type)) {
            this.logTrace(type, className, methodName, text, parms, null);
        }
    }

    public void trace(long type, Object obj, String methodName, byte[] data) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, data);
        }
    }

    public void trace(long type, String className, String methodName, byte[] data) {
        if (this.isLoggable(type)) {
            this.logTrace(type, className, methodName, data);
        }
    }

    public void exception(long type, Object obj, String methodName, Exception exception) {
        this.exception(type, obj, methodName, (Throwable)exception);
    }

    public void exception(long type, String className, String methodName, Exception exception) {
        this.exception(type, className, methodName, (Throwable)exception);
    }

    public void exception(long type, Object obj, String methodName, Throwable exception) {
        if (this.isLoggable(type |= 8L)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, null, null, exception);
        }
    }

    public void exception(long type, String className, String methodName, Throwable exception) {
        if (this.isLoggable(type |= 8L)) {
            this.logTrace(type, className, methodName, null, null, exception);
        }
    }

    public void stackTrace(long type, Object obj, String methodName) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, null, null, new RASStackTrace());
        }
    }

    public void stackTrace(long type, Object obj, String methodName, String text) {
        if (this.isLoggable(type)) {
            String className = obj.getClass().getName();
            this.logTrace(type, className, methodName, null, null, new RASStackTrace(text));
        }
    }

    public void stackTrace(long type, String className, String methodName) {
        if (this.isLoggable(type)) {
            this.logTrace(type, className, methodName, null, null, new RASStackTrace());
        }
    }

    public void stackTrace(long type, String className, String methodName, String text) {
        if (this.isLoggable(type)) {
            this.logTrace(type, className, methodName, null, null, new RASStackTrace(text));
        }
    }

    protected void logTrace(long type, String className, String methodName, String text, Object[] parms, Throwable exception) {
        RASTraceEvent event = new RASTraceEvent(type, text, parms, className, methodName, (RASITraceLogger)this, this.getServer(), this.getClient(), exception);
        this.fireRASEvent(event);
    }

    protected void logTrace(long type, String className, String methodName, byte[] data) {
        RASTraceEvent event = new RASTraceEvent(type, className, methodName, this, this.getServer(), this.getClient(), data);
        this.fireRASEvent(event);
    }

    public synchronized void maskValueChanged(RASMaskChangeEvent mc) {
        this.isLoggableMask = 0L;
        Enumeration e = this.getHandlers();
        while (e.hasMoreElements()) {
            RASIHandler h = (RASIHandler)e.nextElement();
            this.isLoggableMask |= h.getTraceMask();
        }
        this.isLoggableMask &= this.getTraceMask();
    }
}

