/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class RASConfig
extends Hashtable {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = -5466198196850427009L;
    private boolean modified = false;
    private transient int inUseCount = 0;
    private transient RASObject object = null;

    public RASConfig() {
    }

    public RASConfig(Hashtable config) {
        this.setConfig(config);
    }

    public Hashtable getConfig() {
        return this;
    }

    public void setConfig(Hashtable config) {
        Enumeration e = config.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.put(key, config.get(key));
        }
        RASObject object = this.getObject();
        if (object != null) {
            object.setConfig(config);
        }
    }

    public int getInUseCount() {
        return this.inUseCount;
    }

    public void setInUseCount(int count) {
        this.inUseCount = count;
    }

    public int incrementInUseCount() {
        ++this.inUseCount;
        return this.inUseCount;
    }

    public int decrementInUseCount() {
        if (this.inUseCount > 0) {
            --this.inUseCount;
        }
        return this.inUseCount;
    }

    public synchronized void setModified(boolean flag) {
        this.modified = flag;
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public RASObject getObject() {
        return this.object;
    }

    public void setObject(RASObject object) {
        this.object = object;
    }

    protected void updateActiveObjects(RASConfig oldConfig) {
        RASObject obj;
        if (oldConfig != null && (obj = oldConfig.getObject()) != null) {
            this.setObject(obj);
            this.setInUseCount(oldConfig.getInUseCount());
            obj.setConfig(this);
        }
    }

    public String toString() {
        StringBuffer bfr = new StringBuffer();
        Enumeration e = this.keys();
        bfr.append("    RASConfig Object:\r\n");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            bfr.append("      " + key + ":  " + (String)this.get(key) + "\r\n");
        }
        bfr.append("      In Use Count:  " + this.inUseCount + "\r\n");
        return bfr.toString();
    }
}

