/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.ejs.ras.Tr;
import com.ibm.ras.RASMessageLogger;
import com.ibm.ras.RASTraceLogger;
import com.ibm.websphere.ras.WsJrasMessageLogger;
import com.ibm.websphere.ras.WsJrasTraceLogger;
import java.util.Hashtable;

public class Manager {
    private static final Object svMgrLock = new Object();
    private static Manager svMgr = null;
    private static String svIbm = "IBM";
    private static String svWebSphere = "WebSphere";
    private Hashtable ivTraceLoggers = new Hashtable(20);
    private Hashtable ivMessageLoggers = new Hashtable(20);
    private long ivMsgLoggingMask;

    public static Manager getManager() {
        if (svMgr == null) {
            Object object = svMgrLock;
            synchronized (object) {
                if (svMgr == null) {
                    svMgr = new Manager(true);
                }
            }
        }
        return svMgr;
    }

    public Manager() {
        this(true);
    }

    private Manager(boolean dummy) {
    }

    public RASMessageLogger createRASMessageLogger(String organization, String product, String component, String name) throws IllegalArgumentException {
        this.checkParameters(organization, product, component, name);
        WsJrasMessageLogger logger = null;
        boolean created = false;
        Hashtable hashtable = this.ivMessageLoggers;
        synchronized (hashtable) {
            logger = (WsJrasMessageLogger)this.ivMessageLoggers.get(name);
            if (logger == null) {
                logger = new WsJrasMessageLogger(organization, product, component, name);
                this.ivMessageLoggers.put(name, logger);
                created = true;
            }
        }
        if (!created) {
            this.checkLoggerCoherency(logger, organization, product, component);
        }
        return logger;
    }

    public RASMessageLogger createRASMessageLogger(String component, String name) throws IllegalArgumentException {
        return this.createRASMessageLogger(svIbm, svWebSphere, component, name);
    }

    public RASTraceLogger createRASTraceLogger(String organization, String product, String component, String name) throws IllegalArgumentException {
        this.checkParameters(organization, product, component, name);
        WsJrasTraceLogger logger = null;
        Hashtable hashtable = this.ivTraceLoggers;
        synchronized (hashtable) {
            logger = (WsJrasTraceLogger)this.ivTraceLoggers.get(name);
            if (logger == null) {
                logger = new WsJrasTraceLogger(organization, product, component, name);
                this.ivTraceLoggers.put(name, logger);
            }
        }
        return logger;
    }

    public RASTraceLogger createRASTraceLogger(String component, String name) throws IllegalArgumentException {
        return this.createRASTraceLogger(svIbm, svWebSphere, component, name);
    }

    public void addLoggerToGroup(RASTraceLogger logger, String groupName) throws IllegalArgumentException {
        if (logger == null) {
            throw new IllegalArgumentException("Logger parameter is invalid");
        }
        if (groupName == null || groupName.equals("")) {
            throw new IllegalArgumentException("Group parameter is invalid");
        }
        WsJrasTraceLogger myLogger = null;
        try {
            myLogger = (WsJrasTraceLogger)logger;
            Tr.register(myLogger.ivTrName, groupName);
            myLogger.traceStateChanged();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Specified RASITraceLogger is not a WebSphere TraceLogger");
        }
    }

    private void checkParameters(String organization, String product, String component, String name) throws IllegalArgumentException {
        if (organization == null || organization.equals("")) {
            throw new IllegalArgumentException("Organization parameter is invalid");
        }
        if (product == null || product.equals("")) {
            throw new IllegalArgumentException("Product parameter is invalid");
        }
        if (component == null || component.equals("")) {
            throw new IllegalArgumentException("Component parameter is invalid");
        }
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Name parameter is invalid");
        }
    }

    private void checkLoggerCoherency(RASMessageLogger logger, String organization, String product, String component) throws IllegalArgumentException {
        if (!organization.equals(logger.getOrganization())) {
            throw new IllegalArgumentException("Organization parameter mismatch");
        }
        if (!product.equals(logger.getProduct())) {
            throw new IllegalArgumentException("Product parameter mismatch");
        }
        if (!component.equals(logger.getComponent())) {
            throw new IllegalArgumentException("Component parameter mismatch");
        }
    }
}

